/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import java.util.HashMap;

public class NameMapping {
    public static final String DEFAULT_BLOCK_NAME = "*DEFAULT*";
    private String mOldServiceName;
    private String mOldComponentName;
    private String mOldBlockName;
    private String mNewServiceName;
    private String mNewComponentPath;
    private String mNewComponentName;
    private String mNewBlockName;
    private HashMap mArgNameMap = new HashMap();
    private VariableSettingsHolder mExtraArgs = new VariableSettingsHolder();
    private String[] mExtraArgNames;
    private static final String WIN32_PATH = "/system/win32";
    private static final String METABASE_SS = "metabase services";
    private static final String METABASE_PATH = "/system/win32";
    private static final String METABASE_NAME = "Metabase SS";
    private static final String WINDOWS_SS = "windows services";
    private static final String WINDOWS_PATH = "/system/win32";
    private static final String WINDOWS_NAME = "Windows Services SS";
    private static final String OLD_IIS_SITE_SS = "IIS web site or virtual directory settings";
    private static final String OLD_IIS_SITE_NAME = "IIS Site RH";
    private static final String NEW_IIS_SITE_SS = "metabase services";
    private static final String NEW_IIS_SITE_PATH = "/system/win32";
    private static final String NEW_IIS_SITE_NAME = "Metabase SS";
    private static final String OLD_IIS_GLOBAL_SS = "IIS global settings";
    private static final String OLD_IIS_GLOBAL_NAME = "IIS Global Settings RH";
    private static final String NEW_IIS_GLOBAL_SS = "metabase services";
    private static final String NEW_IIS_GLOBAL_PATH = "/system/win32";
    private static final String NEW_IIS_GLOBAL_NAME = "Metabase SS";
    private static final String OLD_ISAPI_SITE_SS = "website ISAPI filter settings";
    private static final String OLD_ISAPI_SITE_NAME = "Website ISAPI Filter RH";
    private static final String NEW_ISAPI_SITE_SS = "metabase services";
    private static final String NEW_ISAPI_SITE_PATH = "/system/win32";
    private static final String NEW_ISAPI_SITE_NAME = "Metabase SS";
    private static final String OLD_ISAPI_GLOBAL_SS = "global ISAPI filter settings";
    private static final String OLD_ISAPI_GLOBAL_NAME = "Global ISAPI Filter RH";
    private static final String NEW_ISAPI_GLOBAL_SS = "metabase services";
    private static final String NEW_ISAPI_GLOBAL_PATH = "/system/win32";
    private static final String NEW_ISAPI_GLOBAL_NAME = "Metabase SS";
    private static final String OLD_COM_PLUS_SS = "COM+ application";
    private static final String OLD_COM_PLUS_NAME = "COMPlus RH";
    private static final String NEW_COM_PLUS_SS = "COM+ application services";
    private static final String NEW_COM_PLUS_PATH = "/system/win32";
    private static final String NEW_COM_PLUS_NAME = "COMPlus SS";
    private static final String OLD_REG_KEY_SS = "registry key";
    private static final String OLD_REG_KEY_NAME = "Registry RH";
    private static final String NEW_REG_KEY_SS = "registry key services";
    private static final String NEW_REG_KEY_PATH = "/system/win32";
    private static final String NEW_REG_KEY_NAME = "Registry Key SS";
    private static final String OLD_DSN_SS = "data source name";
    private static final String OLD_DSN_NAME = "DSN RH";
    private static final String NEW_DSN_SS = "data source name services";
    private static final String NEW_DSN_PATH = "/system/win32";
    private static final String NEW_DSN_NAME = "DSN SS";
    private static final String OLD_BATCH_FILE_SS = "windows batch file";
    private static final String OLD_BATCH_FILE_NAME = "Batch File RH";
    private static final String NEW_BATCH_FILE_SS = "windows services";
    private static final String NEW_BATCH_FILE_PATH = "/system/win32";
    private static final String NEW_BATCH_FILE_NAME = "Windows Services SS";
    private static final String OLD_CSCRIPT_FILE_SS = "windows scripting host script";
    private static final String OLD_CSCRIPT_FILE_NAME = "Windows Scripting Host RH";
    private static final String NEW_CSCRIPT_FILE_SS = "windows services";
    private static final String NEW_CSCRIPT_FILE_PATH = "/system/win32";
    private static final String NEW_CSCRIPT_FILE_NAME = "Windows Services SS";
    private static final String OLD_WIN_SERVICES_SS = "windows services";
    private static final String OLD_WIN_SERVICES_NAME = "Windows Services SS";
    private static final String NEW_WIN_SERVICES_SS = "windows services";
    private static final String NEW_WIN_SERVICES_PATH = "/system/win32";
    private static final String NEW_WIN_SERVICES_NAME = "Windows Services SS";
    private static final String OLD_CORE_SERVICES_SS = "windows services";
    private static final String OLD_CORE_SERVICES_NAME = "Windows Services SS";
    private static final String NEW_CORE_SERVICES_SS = "core services";
    private static final String NEW_CORE_SERVICES_PATH = "/system/";
    private static final String NEW_CORE_SERVICES_NAME = "Core Services SS";
    private static final String OLD_COM_OBJECT_SS = "COM object";
    private static final String OLD_COM_OBJECT_NAME = "COM Component RH";
    private static final String NEW_COM_OBJECT_SS = "windows services";
    private static final String NEW_COM_OBJECT_PATH = "/system/win32";
    private static final String NEW_COM_OBJECT_NAME = "Windows Services SS";
    private static final String OLD_MSI_FILE_SS = "windows installer file";
    private static final String OLD_MSI_FILE_NAME = "MSI RH";
    private static final String NEW_MSI_FILE_SS = "windows services";
    private static final String NEW_MSI_FILE_PATH = "/system/win32";
    private static final String NEW_MSI_FILE_NAME = "Windows Services SS";
    private static final String OLD_REG_FILE_SS = "windows registry file";
    private static final String OLD_REG_FILE_NAME = "Registry File RH";
    private static final String NEW_REG_FILE_SS = "windows services";
    private static final String NEW_REG_FILE_PATH = "/system/win32";
    private static final String NEW_REG_FILE_NAME = "Windows Services SS";

    public String getOldComponentName() {
        return this.mOldComponentName;
    }

    public String getOldServiceName() {
        return this.mOldServiceName;
    }

    public String getOldBlockName() {
        return this.mOldBlockName;
    }

    public String getNewComponentPath() {
        return this.mNewComponentPath;
    }

    public String getNewComponentName() {
        return this.mNewComponentName;
    }

    public String getNewServiceName() {
        return this.mNewServiceName;
    }

    public String getNewBlockName() {
        return this.mNewBlockName;
    }

    public String getNewBlockName(String oldBlockName) {
        return DEFAULT_BLOCK_NAME.equals(this.mNewBlockName) ? oldBlockName : this.mNewBlockName;
    }

    void mapBlockName(String oldName, String newName) {
        this.mOldBlockName = oldName;
        this.mNewBlockName = newName;
    }

    void mapBlockName(String oldName) {
        this.mapBlockName(oldName, oldName);
    }

    void mapArgName(String oldName, String newName) {
        this.mArgNameMap.put(oldName, newName);
    }

    public String mapArgName(String oldName) {
        String result = (String)this.mArgNameMap.get(oldName);
        if (result == null) {
            result = oldName;
        }
        return result;
    }

    void addExtraArg(String name, String value) {
        this.mExtraArgNames = null;
        this.mExtraArgs.setVarValue(name, value);
    }

    public int getNumExtraArgs() {
        return this.mExtraArgs.size();
    }

    public String getExtraArgName(int ndx) {
        return this.getExtraArgNames()[ndx];
    }

    public String getExtraArgValue(int ndx) {
        return this.mExtraArgs.getVarValue(this.getExtraArgName(ndx));
    }

    private String[] getExtraArgNames() {
        if (this.mExtraArgNames == null) {
            this.mExtraArgNames = this.mExtraArgs.getVarNames();
        }
        return this.mExtraArgNames;
    }

    public NameMapping(String oldServiceName, String oldCompName, String newServiceName, String newCompPath, String newCompName) {
        this.mOldServiceName = oldServiceName;
        this.mOldComponentName = oldCompName;
        this.mNewServiceName = newServiceName;
        this.mNewComponentPath = newCompPath;
        this.mNewComponentName = newCompName;
        this.mapBlockName(DEFAULT_BLOCK_NAME);
    }

    public static NameMapping newIISSite() {
        return new NameMapping(OLD_IIS_SITE_SS, OLD_IIS_SITE_NAME, "metabase services", "/system/win32", "Metabase SS");
    }

    public static NameMapping newIISGlobalSettings() {
        return new NameMapping(OLD_IIS_GLOBAL_SS, OLD_IIS_GLOBAL_NAME, "metabase services", "/system/win32", "Metabase SS");
    }

    public static NameMapping newISAPISite() {
        return new NameMapping(OLD_ISAPI_SITE_SS, OLD_ISAPI_SITE_NAME, "metabase services", "/system/win32", "Metabase SS");
    }

    public static NameMapping newISAPIGlobal() {
        return new NameMapping(OLD_ISAPI_GLOBAL_SS, OLD_ISAPI_GLOBAL_NAME, "metabase services", "/system/win32", "Metabase SS");
    }

    public static NameMapping newCOMPlus() {
        return new NameMapping(OLD_COM_PLUS_SS, OLD_COM_PLUS_NAME, NEW_COM_PLUS_SS, "/system/win32", NEW_COM_PLUS_NAME);
    }

    public static NameMapping newRegistryKey() {
        return new NameMapping(OLD_REG_KEY_SS, OLD_REG_KEY_NAME, NEW_REG_KEY_SS, "/system/win32", NEW_REG_KEY_NAME);
    }

    public static NameMapping newDSN() {
        return new NameMapping(OLD_DSN_SS, OLD_DSN_NAME, NEW_DSN_SS, "/system/win32", NEW_DSN_NAME);
    }

    public static NameMapping newBatchFile() {
        return new NameMapping(OLD_BATCH_FILE_SS, OLD_BATCH_FILE_NAME, "windows services", "/system/win32", "Windows Services SS");
    }

    public static NameMapping newCscriptFile() {
        return new NameMapping(OLD_CSCRIPT_FILE_SS, OLD_CSCRIPT_FILE_NAME, "windows services", "/system/win32", "Windows Services SS");
    }

    public static NameMapping newWindowsServices() {
        return new NameMapping("windows services", "Windows Services SS", "windows services", "/system/win32", "Windows Services SS");
    }

    public static NameMapping newCoreServices() {
        return new NameMapping("windows services", "Windows Services SS", NEW_CORE_SERVICES_SS, NEW_CORE_SERVICES_PATH, NEW_CORE_SERVICES_NAME);
    }

    public static NameMapping newCOMObject() {
        return new NameMapping(OLD_COM_OBJECT_SS, OLD_COM_OBJECT_NAME, "windows services", "/system/win32", "Windows Services SS");
    }

    public static NameMapping newMSIFile() {
        return new NameMapping(OLD_MSI_FILE_SS, OLD_MSI_FILE_NAME, "windows services", "/system/win32", "Windows Services SS");
    }

    public static NameMapping newRegistryFile() {
        return new NameMapping(OLD_REG_FILE_SS, OLD_REG_FILE_NAME, "windows services", "/system/win32", "Windows Services SS");
    }
}

