/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanTable;
import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.migrate.m30to40.NameMapping;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class MigrateUtil {
    private static final char RSRC_PATH_SEP = '/';
    private static final char COMP_PATH_SEP = '/';
    private static final String ROOT_PATH = "/resources";
    private static final int MAX_DIR_LEN = 2048;
    private static final HashMap RSRC_NAME_MAP = new HashMap();
    private static final String EXPORT_BLOCK_NAME = "export";
    private static final String INSTALL_BLOCK_NAME = "install";
    private static final String UNINSTALL_BLOCK_NAME = "uninstall";
    private static final String DEFAULT_SNAPSHOT_NAME = "default";
    private static final String METABASE_SNAPSHOT_NAME = "captureSettings";
    private static final String METABASE_PACKAGE = "com.raplix.rolloutexpress.plugins.win32.execjava.metabase.";
    private static final String METABASE_EXPORTER_ARG = "resourceExporterFactoryName";
    private static final String TMP_FILE_SUFFIX_ARG = "tmpFileSuffix";
    private static final String IIS_SITE_EXPORTER_NAME = "com.raplix.rolloutexpress.plugins.win32.execjava.metabase.WebSiteExportFactory";
    private static final String IIS_GLOBAL_EXPORTER_NAME = "com.raplix.rolloutexpress.plugins.win32.execjava.metabase.GlobalSettingsExportFactory";
    private static final String ISAPI_SITE_EXPORTER_NAME = "com.raplix.rolloutexpress.plugins.win32.execjava.metabase.WebSiteFilterExportFactory";
    private static final String ISAPI_GLOBAL_EXPORTER_NAME = "com.raplix.rolloutexpress.plugins.win32.execjava.metabase.GlobalFilterExportFactory";
    private static final HashMap SS_NAME_MAP;
    private static final HashMap COMP_NAME_MAP;
    private static ExecutionPlanIDSet AUTO_GEN_PLANS;

    public static String getCompPath(String rsrcName) {
        rsrcName = MigrateUtil.mapRsrcName(rsrcName);
        int lastSep = rsrcName.lastIndexOf(47);
        StringBuffer rsrcPath = new StringBuffer(ROOT_PATH);
        if (lastSep < 1) {
            return rsrcPath.toString();
        }
        rsrcPath.append('/');
        int curNdx = 0;
        if (rsrcName.charAt(0) == '/') {
            ++curNdx;
        }
        int dirLen = 0;
        while (curNdx < lastSep) {
            char ch = rsrcName.charAt(curNdx);
            switch (ch) {
                case '/': {
                    rsrcPath.append('/');
                    dirLen = 0;
                    break;
                }
                default: {
                    dirLen = MigrateUtil.append(rsrcPath, ch, dirLen);
                }
            }
            ++curNdx;
        }
        return rsrcPath.toString();
    }

    private static int append(StringBuffer buf, String str, int dirLen) {
        int strLen = str.length();
        if (dirLen + strLen > 2048) {
            buf.append('/');
            dirLen = 0;
        }
        buf.append(str);
        return dirLen += strLen;
    }

    private static int append(StringBuffer buf, char ch, int dirLen) {
        int strLen = 1;
        if (dirLen + strLen > 2048) {
            buf.append('/');
            dirLen = 0;
        }
        buf.append(ch);
        return dirLen += strLen;
    }

    public static String getCompName(String rsrcName) {
        int lastSep = (rsrcName = MigrateUtil.mapRsrcName(rsrcName)).lastIndexOf(47);
        if (lastSep != -1) {
            rsrcName = rsrcName.substring(lastSep + 1);
        }
        return rsrcName;
    }

    private static String mapRsrcName(String rsrcName) {
        String result = (String)RSRC_NAME_MAP.get(rsrcName = FileSpec.convertPathSeparatorToUniversal(rsrcName));
        if (result == null) {
            result = rsrcName;
        }
        return result;
    }

    private static NameMapping addUninstall(NameMapping mapping) {
        mapping.mapBlockName(UNINSTALL_BLOCK_NAME);
        mapping.addExtraArg("deleteFile", "true");
        return mapping;
    }

    private static void addMapping(NameMapping mapping) {
        MigrateUtil.addMapping(SS_NAME_MAP, mapping.getOldServiceName(), mapping);
        MigrateUtil.addMapping(COMP_NAME_MAP, mapping.getOldComponentName(), mapping);
    }

    private static void addMapping(HashMap map, String key, NameMapping mapping) {
        HashMap<String, NameMapping> blockMap = (HashMap<String, NameMapping>)map.get(key);
        if (blockMap == null) {
            blockMap = new HashMap<String, NameMapping>();
            map.put(key, blockMap);
        }
        blockMap.put(mapping.getOldBlockName(), mapping);
    }

    public static NameMapping getMappedSS(String oldSSName, String oldSSBlockName) {
        return MigrateUtil.getMapping(SS_NAME_MAP, oldSSName, oldSSBlockName);
    }

    public static NameMapping getMappedComp(String oldCompName, String oldCompBlockName) {
        return MigrateUtil.getMapping(COMP_NAME_MAP, oldCompName, oldCompBlockName);
    }

    private static NameMapping getMapping(HashMap map, String key, String blockName) {
        if (MigrateUtil.isAutoGenPlan()) {
            return null;
        }
        NameMapping result = null;
        HashMap blockMap = (HashMap)map.get(key);
        if (blockMap != null && (result = (NameMapping)blockMap.get(blockName)) == null) {
            result = (NameMapping)blockMap.get("*DEFAULT*");
        }
        return result;
    }

    static void initAutoGenPlans() throws PersistenceManagerException {
        final AutoGeneratedPlanTable t = AutoGeneratedPlanTable.DEFAULT;
        Select query = t.select(AutoGeneratedPlanTable.sList(t.PlanID));
        ResultSetProcessor proc = new ResultSetProcessor(){

            public void processResultSet(ResultSet rs) throws SQLException, PersistenceManagerException {
                while (rs.next()) {
                    AUTO_GEN_PLANS.add(t.PlanID.retrieveValue(rs));
                }
            }
        };
        AutoGeneratedPlanTable.execute(query, proc);
    }

    public static boolean isAutoGenPlan() {
        ObjectID curID = TransformMigrator.getCurrentObjectID();
        return curID != null && AUTO_GEN_PLANS.contains(curID);
    }

    static {
        RSRC_NAME_MAP.put("systemcomps/cmdInDir.bat", "/system/win32/cmdInDir.bat");
        RSRC_NAME_MAP.put("systemcomps/cscriptInDir.bat", "/system/win32/cscriptInDir.bat");
        RSRC_NAME_MAP.put("systemcomps/IMSABOWrapper.dll", "/system/win32/IMSABOWrapper.dll");
        SS_NAME_MAP = new HashMap();
        COMP_NAME_MAP = new HashMap();
        MigrateUtil.addMapping(NameMapping.newIISSite());
        NameMapping iisSiteExport = NameMapping.newIISSite();
        iisSiteExport.mapBlockName(EXPORT_BLOCK_NAME);
        iisSiteExport.addExtraArg(METABASE_EXPORTER_ARG, IIS_SITE_EXPORTER_NAME);
        MigrateUtil.addMapping(iisSiteExport);
        NameMapping iisSiteSnapshot = NameMapping.newIISSite();
        iisSiteSnapshot.mapBlockName(DEFAULT_SNAPSHOT_NAME, METABASE_SNAPSHOT_NAME);
        iisSiteSnapshot.addExtraArg(METABASE_EXPORTER_ARG, IIS_SITE_EXPORTER_NAME);
        iisSiteSnapshot.addExtraArg(TMP_FILE_SUFFIX_ARG, "_IIS_site.xml");
        MigrateUtil.addMapping(iisSiteSnapshot);
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newIISSite()));
        MigrateUtil.addMapping(NameMapping.newIISGlobalSettings());
        NameMapping iisGlobalExport = NameMapping.newIISGlobalSettings();
        iisGlobalExport.mapBlockName(EXPORT_BLOCK_NAME);
        iisGlobalExport.addExtraArg(METABASE_EXPORTER_ARG, IIS_GLOBAL_EXPORTER_NAME);
        MigrateUtil.addMapping(iisGlobalExport);
        NameMapping iisGlobalSnapshot = NameMapping.newIISGlobalSettings();
        iisGlobalSnapshot.mapBlockName(DEFAULT_SNAPSHOT_NAME, METABASE_SNAPSHOT_NAME);
        iisGlobalSnapshot.addExtraArg(METABASE_EXPORTER_ARG, IIS_GLOBAL_EXPORTER_NAME);
        iisGlobalSnapshot.addExtraArg(TMP_FILE_SUFFIX_ARG, "_IIS_global.xml");
        MigrateUtil.addMapping(iisGlobalSnapshot);
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newIISGlobalSettings()));
        MigrateUtil.addMapping(NameMapping.newISAPIGlobal());
        NameMapping isapiGlobalExport = NameMapping.newISAPIGlobal();
        isapiGlobalExport.mapBlockName(EXPORT_BLOCK_NAME);
        isapiGlobalExport.addExtraArg(METABASE_EXPORTER_ARG, ISAPI_GLOBAL_EXPORTER_NAME);
        MigrateUtil.addMapping(isapiGlobalExport);
        NameMapping isapiGlobalSnapshot = NameMapping.newISAPIGlobal();
        isapiGlobalSnapshot.mapBlockName(DEFAULT_SNAPSHOT_NAME, METABASE_SNAPSHOT_NAME);
        isapiGlobalSnapshot.addExtraArg(METABASE_EXPORTER_ARG, ISAPI_GLOBAL_EXPORTER_NAME);
        isapiGlobalSnapshot.addExtraArg(TMP_FILE_SUFFIX_ARG, "_ISAPI_global.xml");
        MigrateUtil.addMapping(isapiGlobalSnapshot);
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newISAPIGlobal()));
        MigrateUtil.addMapping(NameMapping.newISAPISite());
        NameMapping isapiSiteExport = NameMapping.newISAPISite();
        isapiSiteExport.mapBlockName(EXPORT_BLOCK_NAME);
        isapiSiteExport.addExtraArg(METABASE_EXPORTER_ARG, ISAPI_SITE_EXPORTER_NAME);
        MigrateUtil.addMapping(isapiSiteExport);
        NameMapping isapiSiteSnapshot = NameMapping.newISAPISite();
        isapiSiteSnapshot.mapBlockName(DEFAULT_SNAPSHOT_NAME, METABASE_SNAPSHOT_NAME);
        isapiSiteSnapshot.addExtraArg(METABASE_EXPORTER_ARG, ISAPI_SITE_EXPORTER_NAME);
        isapiSiteSnapshot.addExtraArg(TMP_FILE_SUFFIX_ARG, "_ISAPI_site.xml");
        MigrateUtil.addMapping(isapiSiteSnapshot);
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newISAPISite()));
        MigrateUtil.addMapping(NameMapping.newCOMPlus());
        NameMapping comPlusInstallAsUser = NameMapping.newCOMPlus();
        comPlusInstallAsUser.mapBlockName("installAsUser", INSTALL_BLOCK_NAME);
        MigrateUtil.addMapping(comPlusInstallAsUser);
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newCOMPlus()));
        MigrateUtil.addMapping(NameMapping.newRegistryKey());
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newRegistryKey()));
        MigrateUtil.addMapping(NameMapping.newDSN());
        MigrateUtil.addMapping(MigrateUtil.addUninstall(NameMapping.newDSN()));
        NameMapping batchFile = NameMapping.newBatchFile();
        batchFile.mapBlockName(INSTALL_BLOCK_NAME, "runBatFile");
        batchFile.mapArgName("rsrcInstallPath", "batFilePath");
        MigrateUtil.addMapping(batchFile);
        NameMapping cscriptFile = NameMapping.newCscriptFile();
        cscriptFile.mapBlockName(INSTALL_BLOCK_NAME, "runCscriptFile");
        cscriptFile.mapArgName("rsrcInstallPath", "cscriptFilePath");
        MigrateUtil.addMapping(cscriptFile);
        MigrateUtil.addMapping(NameMapping.newWindowsServices());
        NameMapping coreServices = NameMapping.newCoreServices();
        coreServices.mapBlockName("deleteFile");
        coreServices.mapArgName("fileName", "absPath");
        MigrateUtil.addMapping(coreServices);
        NameMapping comObjectInstall = NameMapping.newCOMObject();
        comObjectInstall.mapBlockName(INSTALL_BLOCK_NAME, "registerCOMObject");
        comObjectInstall.mapArgName("rsrcInstallPath", "filePath");
        MigrateUtil.addMapping(comObjectInstall);
        NameMapping comObjectUninstall = NameMapping.newCOMObject();
        MigrateUtil.addUninstall(comObjectUninstall);
        comObjectUninstall.mapBlockName(UNINSTALL_BLOCK_NAME, "unregisterCOMObject");
        comObjectUninstall.mapArgName("rsrcInstallPath", "filePath");
        MigrateUtil.addMapping(comObjectUninstall);
        NameMapping msiFileInstall = NameMapping.newMSIFile();
        msiFileInstall.mapBlockName(INSTALL_BLOCK_NAME, "installMSI");
        msiFileInstall.mapArgName("rsrcInstallPath", "filePath");
        MigrateUtil.addMapping(msiFileInstall);
        NameMapping msiFileUninstall = NameMapping.newMSIFile();
        MigrateUtil.addUninstall(msiFileUninstall);
        msiFileUninstall.mapBlockName(UNINSTALL_BLOCK_NAME, "uninstallMSI");
        msiFileUninstall.mapArgName("rsrcInstallPath", "filePath");
        MigrateUtil.addMapping(msiFileUninstall);
        NameMapping regFileInstall = NameMapping.newRegistryFile();
        regFileInstall.mapBlockName(INSTALL_BLOCK_NAME, "importRegistry");
        regFileInstall.mapArgName("rsrcInstallPath", "filePath");
        MigrateUtil.addMapping(regFileInstall);
        AUTO_GEN_PLANS = new ExecutionPlanIDSet();
    }
}

