/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.PersistentVariableSettingsTable;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemService;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledCompToInstalledCompLinkTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResourceTable;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotTable;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.SystemServiceTargeter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;

class InstalledComponentMigrator
extends TableMigrator {
    private static final PersistentInstalledComponentTable TABLE = PersistentInstalledComponentTable.DEFAULT;
    private ConfigGenSubsystem mConfigGenSubsystem;
    private static final String INSTALL_PATH_VAR = "installPath";
    private static final String PATH_VAR = "path";
    private static final String ROOT_KEY_PREFIX = "$root$";
    private static final String KEY_SEP = ":";
    private static final int DB_STAMP_PRECISION = 1;

    public InstalledComponentMigrator(ConfigGenSubsystem configGenSubsystem) {
        this.setConfigGenSubsystem(configGenSubsystem);
    }

    public ConfigGenSubsystem getConfigGenSubsystem() {
        return this.mConfigGenSubsystem;
    }

    private void setConfigGenSubsystem(ConfigGenSubsystem configGenSubsystem) {
        this.mConfigGenSubsystem = configGenSubsystem;
    }

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return InstalledComponentMigrator.sList(InstalledComponentMigrator.TABLE.ID);
    }

    protected ColumnNode getOrderColumn() {
        return InstalledComponentMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        return InstalledComponentMigrator.where(InstalledComponentMigrator.isNull(InstalledComponentMigrator.TABLE.ParentContainerID));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        return new InstCompData(rs);
    }

    private void migrate(InstalledComponentID id) throws PersistenceManagerException, RPCException, ConfigGenException, InstallDBException {
        InstalledComponent ic = id.getByIDQuery().select();
        Host targetHost = ic.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID().getByIDQuery().select();
        TargetedConfigContext tcCtx = new TargetedConfigContext(targetHost);
        PersistentInstallDBContext idbCtx = new PersistentInstallDBContext();
        ConfigGenerator baseCG = this.getConfigGenSubsystem().getConfigGenerator().newTargetScope(tcCtx, idbCtx);
        Component comp = ic.getComponentID().getByIDQuery().select();
        this.migrateVarSettings(comp, ic);
        this.migrateSnapshots(comp, ic);
        ComponentConfigManager cm = this.getConfigGenSubsystem().getConfigGenerator().newComponentManager(ic.getVariableSettingsID());
        Date installDate = ic.getInstallDate();
        if (installDate != null) {
            ComponentRefDecl[] refs = comp.getCompRefList(null);
            int numRefs = refs.length;
            for (int i = 0; i < numRefs; ++i) {
                this.createNestedInstalledComponent(ic, baseCG, cm, refs[i], i, numRefs, idbCtx, tcCtx, comp);
            }
        }
    }

    private void migrateVarSettings(Component comp, InstalledComponent ic) throws PersistenceManagerException, RPCException, ConfigGenException {
        GeneratedVariableSettingsID gvsID = ic.getVariableSettingsID();
        GeneratedVariableSettings origVars = this.getConfigGenSubsystem().getVariableSettings(gvsID);
        VariableSettingsHolder newVars = new VariableSettingsHolder();
        String baseCompName = comp.getExtendsTypeName();
        String keyPrefix = baseCompName;
        if (keyPrefix == null) {
            keyPrefix = ROOT_KEY_PREFIX;
        }
        keyPrefix = keyPrefix + KEY_SEP;
        newVars.setVarValue(keyPrefix + PATH_VAR, comp.getPath().getFullPathString());
        String[] varNames = origVars.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            newVars.setVarValue(keyPrefix + varNames[i], origVars.getVarValue(varNames[i]));
        }
        if (baseCompName != null) {
            if (!SystemService.TYPE_NAME.equals(baseCompName)) {
                System.err.println("unexpected component type \"" + baseCompName + "\" found for installed " + "component " + ic.getID() + ".  " + "Generated variable settings will not " + "be properly migrated");
            } else {
                this.addInstallPath(origVars, newVars, keyPrefix, comp);
                String rootPrefix = "$root$:";
                this.addVar(newVars, rootPrefix, keyPrefix, PATH_VAR);
                this.addVar(newVars, rootPrefix, keyPrefix, "name");
                this.addVar(newVars, rootPrefix, keyPrefix, "description");
                this.addVar(newVars, rootPrefix, keyPrefix, "label");
                this.addVar(newVars, rootPrefix, keyPrefix, "softwareVendor");
                this.addVar(newVars, rootPrefix, keyPrefix, "author");
                this.addVar(newVars, rootPrefix, keyPrefix, INSTALL_PATH_VAR);
            }
        }
        String encodedVarStr = StringAttributeMap.arrayToSQLString(newVars.getVarSettings());
        PersistentVariableSettingsTable t = PersistentVariableSettingsTable.DEFAULT;
        InstalledComponentMigrator.execute(t.update(InstalledComponentMigrator.uList(InstalledComponentMigrator.set(t.VarSettings, encodedVarStr)), InstalledComponentMigrator.where(InstalledComponentMigrator.equals(t.ID, gvsID))));
    }

    private void addInstallPath(VariableSettingsSource origVars, VariableSettingsHolder newVars, String origPrefix, Component comp) throws PersistenceManagerException, RPCException, ConfigGenException {
        if (origVars.containsVarValue(INSTALL_PATH_VAR)) {
            return;
        }
        VarDecl installPathVar = comp.resolveVar(INSTALL_PATH_VAR, null);
        String installPathVal = installPathVar.getDefaultValue();
        ConfigGenerator gen = this.newUnresVarScope(origVars);
        installPathVal = gen.generate(installPathVal);
        newVars.setVarValue(origPrefix + INSTALL_PATH_VAR, installPathVal);
    }

    private ConfigGenerator newUnresVarScope(VariableSettingsSource vars) throws ConfigGenException {
        PromptParamList params = new PromptParamList();
        String[] varNames = vars.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            params.addParam(new PromptParam(varNames[i]));
        }
        return this.getConfigGenSubsystem().getConfigGenerator().newCallScope(params, vars);
    }

    private void addVar(VariableSettingsHolder vars, String newPrefix, String origPrefix, String key) {
        vars.setVarValue(newPrefix + key, vars.getVarValue(origPrefix + key));
    }

    private void migrateSnapshots(Component comp, InstalledComponent ic) throws PersistenceManagerException {
        String baseName = comp.getExtendsTypeName();
        if (baseName != null) {
            SnapshotTable t = SnapshotTable.DEFAULT;
            InstalledComponentMigrator.execute(t.update(InstalledComponentMigrator.uList(InstalledComponentMigrator.set(t.CreatorExtendsTypeName, baseName)), InstalledComponentMigrator.where(InstalledComponentMigrator.equals(t.InstalledComponentID, ic.getID()))));
        }
    }

    private void createNestedInstalledComponent(InstalledComponent parentIC, ConfigGenerator baseCG, ComponentConfigManager parentCM, ComponentRefDecl ref, int refNum, int numRefs, InstallDBContext idbCtx, TargetedConfigContext tcCtx, Component parentComp) throws PersistenceManagerException, RPCException, ConfigGenException, InstallDBException {
        if (ref.getComponent() == null) {
            System.err.println("reference " + ref.getName() + " of component " + parentComp.getName() + " (" + parentComp.getVersionNumber() + ") is abstract.  Nested installed component" + " record will not be created.");
            return;
        }
        ComponentID compID = ref.getComponent().getID();
        Component comp = compID.getByIDQuery().select();
        InstalledComponentID newID = InstalledComponentID.generateInstalledComponentID();
        GeneratedVariableSettingsID gvsID = this.computeNestedVars(parentIC, parentComp, comp, baseCG, parentCM, ref);
        Date installDate = this.computeInstallDate(parentIC, refNum, numRefs);
        InstalledComponentMigrator.execute(TABLE.insert(InstalledComponentMigrator.cList(InstalledComponentMigrator.TABLE.ID, InstalledComponentMigrator.TABLE.UpdateCount, InstalledComponentMigrator.TABLE.ComponentID, InstalledComponentMigrator.TABLE.InstallPath).add(InstalledComponentMigrator.cList(InstalledComponentMigrator.TABLE.TargetID, InstalledComponentMigrator.TABLE.VariableSettingsID, InstalledComponentMigrator.TABLE.TaskID, InstalledComponentMigrator.TABLE.PlanID)).add(InstalledComponentMigrator.cList(InstalledComponentMigrator.TABLE.InstallDate, InstalledComponentMigrator.TABLE.ParentContainerID, InstalledComponentMigrator.TABLE.RootContainerID, InstalledComponentMigrator.TABLE.ReachableContainerID)).add(InstalledComponentMigrator.cList(InstalledComponentMigrator.TABLE.ParentContainerRefName, (ColumnNode)InstalledComponentMigrator.TABLE.UninstallDate)), InstalledComponentMigrator.vList(InstalledComponentMigrator.v(newID), InstalledComponentMigrator.v(1), InstalledComponentMigrator.v(compID)).add(InstalledComponentMigrator.vList(InstalledComponentMigrator.v(parentIC.getInstallPath()), InstalledComponentMigrator.v(parentIC.getTargetID()))).add(InstalledComponentMigrator.vList(InstalledComponentMigrator.v(gvsID), InstalledComponentMigrator.v(parentIC.getTaskID()), InstalledComponentMigrator.v(parentIC.getPlanID()))).add(InstalledComponentMigrator.vList(InstalledComponentMigrator.v(installDate), InstalledComponentMigrator.v(parentIC.getID()), InstalledComponentMigrator.v(parentIC.getID()))).add(InstalledComponentMigrator.vList(InstalledComponentMigrator.v(parentIC.getID()), InstalledComponentMigrator.v(ref.getName()), InstalledComponentMigrator.v(parentIC.getUninstallDate())))));
        this.updateAncestorLinks(parentIC, newID);
        this.updateInstalledResources(parentIC, newID, comp);
        this.createDependencies(parentIC, comp, newID, idbCtx, tcCtx);
    }

    private GeneratedVariableSettingsID computeNestedVars(InstalledComponent parentIC, Component parent, Component comp, ConfigGenerator baseCG, ComponentConfigManager parentCM, ComponentRefDecl ref) throws PersistenceManagerException, RPCException, ConfigGenException {
        VariableSettingsHolder overrides = new VariableSettingsHolder(ref.resolveOverrideArgs(parentCM));
        Iterator containerVars = ResourceSelector.getContainerVars(comp.getID(), null).iterator();
        while (containerVars.hasNext()) {
            String containerVar = (String)containerVars.next();
            if (overrides.containsVarValue(containerVar) || parent.resolveVar(containerVar, null) != null) continue;
            String msg = "component " + parent.getName() + "(" + parent.getVersionNumber() + ") does not define " + " variable " + containerVar + " used by config " + "template " + comp.getName() + "(" + comp.getVersionNumber() + ").  Nested installed" + " component record will be incomplete.";
            System.err.println(msg);
            overrides.setVarValue(containerVar, "undefined");
        }
        ComponentConfigManager childCM = baseCG.newComponentRefManager(comp, overrides, parentIC.getID(), ref.getName());
        return childCM.saveSettings();
    }

    private Date computeInstallDate(InstalledComponent parentIC, int refNum, int numRefs) {
        Date result = (Date)parentIC.getInstallDate().clone();
        long time = result.getTime();
        result.setTime(time -= (long)((numRefs - refNum) * 1));
        return result;
    }

    private void updateAncestorLinks(InstalledComponent parentIC, InstalledComponentID childICID) throws PersistenceManagerException {
        InstalledCompToInstalledCompLinkTable lt = InstalledCompToInstalledCompLinkTable.DEFAULT;
        lt.addLink(parentIC.getID(), childICID);
    }

    private void updateInstalledResources(InstalledComponent parentIC, InstalledComponentID childICID, Component childComp) throws PersistenceManagerException {
        ResourceID rsrcID = childComp.getResource().getResourceID();
        PersistentInstalledResourceTable irt = PersistentInstalledResourceTable.DEFAULT;
        InstalledComponentMigrator.execute(irt.update(InstalledComponentMigrator.uList(InstalledComponentMigrator.set(irt.InstalledComponentID, childICID)), InstalledComponentMigrator.where(InstalledComponentMigrator.and(InstalledComponentMigrator.equals(irt.InstalledComponentID, parentIC.getID()), InstalledComponentMigrator.equals(irt.ResourceID, rsrcID)))));
    }

    private void createDependencies(InstalledComponent parentIC, Component childComp, InstalledComponentID childICID, InstallDBContext idbCtx, TargetedConfigContext tcCtx) throws PersistenceManagerException, RPCException, InstallDBException {
        ComponentType rhType;
        if (parentIC.getUninstallDate() == null && childComp.isInstanceOf(rhType = ComponentType.create("resource handler"))) {
            SystemServiceTargeter targeter = new SystemServiceTargeter(childComp.getExtendsTypeName());
            InstalledComponent childIC = childICID.getByIDQuery().select();
            Caller caller = new Caller(childIC, childComp, childComp.getExtendsType().getComponent());
            idbCtx.createDependency("type2handler", caller, targeter, tcCtx);
        }
    }

    private class InstCompData
    implements Migratable {
        private InstalledComponentID mInstCompID;

        public InstCompData(ResultSet rs) throws PersistenceManagerException, SQLException {
            this.mInstCompID = (InstalledComponentID)TABLE.ID.retrieveValue(rs);
        }

        public void migrate() throws PersistenceManagerException {
            try {
                InstalledComponentMigrator.this.migrate(this.mInstCompID);
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(e);
            }
            catch (ConfigGenException e) {
                throw new PersistenceManagerException(e);
            }
            catch (InstallDBException e) {
                throw new PersistenceManagerException(e);
            }
        }
    }
}

