/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;

class ComponentTempTable
extends Table {
    public final transient StringColumn VarSettings = new StringColumn(this, "VarSettings"){

        public String getColumnName() {
            return "C_VAR_SETTINGS";
        }
    };
    public final transient StringColumn DefaultInstallPath = new StringColumn(this, "DefaultInstallPath"){

        public String getColumnName() {
            return "C_DEFAULT_INSTALL_PATH";
        }
    };
    public final transient StringColumn DefaultInstallUser = new StringColumn(this, "DefaultInstallUser"){

        public String getColumnName() {
            return "C_DEFAULT_INSTALL_USER";
        }
    };
    public final transient StringColumn DefaultInstallGroup = new StringColumn(this, "DefaultInstallGroup"){

        public String getColumnName() {
            return "C_DEFAULT_INSTALL_GROUP";
        }
    };
    public final transient StringColumn CompID = new StringColumn(this, "CompID"){

        public String getColumnName() {
            return "OBJECTID";
        }
    };
    public final transient StringColumn ImplementsList = new StringColumn(this, "ImplementsList"){

        public String getColumnName() {
            return "C_IMPLEMENTS_LIST";
        }
    };
    public final transient StringColumn Name = new StringColumn(this, "Name"){

        public String getColumnName() {
            return "C_NAME";
        }
    };
    public final transient IntColumn Version = new IntColumn(this, "Version"){

        public String getColumnName() {
            return "VERSION";
        }
    };
    static final String SYSTEM_SERVICE_INTERFACE = "[SystemService]";
    static final String RESOURCE_HANDLER_INTERFACE = "[ResourceHandler]";
    public static final ComponentTempTable DEFAULT = new ComponentTempTable();

    public Class getJavaClass() {
        return null;
    }

    public ComponentTempTable(String alias) {
        super(alias);
        this.addColumn(this.VarSettings);
        this.addColumn(this.DefaultInstallPath);
        this.addColumn(this.DefaultInstallUser);
        this.addColumn(this.DefaultInstallGroup);
        this.addColumn(this.CompID);
        this.addColumn(this.ImplementsList);
        this.addColumn(this.Name);
        this.addColumn(this.Version);
    }

    public Select selectByID(ComponentID compID) {
        return this.select(ComponentTempTable.sList(this.VarSettings, this.DefaultInstallPath, this.DefaultInstallUser, this.DefaultInstallGroup).add(ComponentTempTable.sList(this.ImplementsList, this.Name, this.Version)), ComponentTempTable.where(ComponentTempTable.equals(this.CompID, compID.toString())));
    }

    public Select selectResourceHandlerNamesAndVersions() {
        return this.select(ComponentTempTable.sList(this.Name, (ScalarExp)this.Version), ComponentTempTable.where(this.isResourceHandler()));
    }

    public WhereClause whereIsSystemService() {
        return ComponentTempTable.where(this.isSystemService());
    }

    public ConditionalExpression isSystemService() {
        return ComponentTempTable.or(this.isResourceHandler(), ComponentTempTable.like(this.ImplementsList, "%[SystemService]%"));
    }

    public ConditionalExpression isResourceHandler() {
        return ComponentTempTable.like(this.ImplementsList, "%[ResourceHandler]%");
    }

    private ComponentTempTable() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new ComponentTempTable(alias);
    }

    public String getTableName() {
        return "RT_COMPONENT";
    }

    public void checkReadPermission() {
    }

    public void checkWritePermission() {
    }

    public void checkDeletePermission() {
    }
}

