/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.migrate.Migrator;
import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.migrate.m30to40.ComponentTempTable;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ConstraintViolationException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToComponentLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public class ComponentInfo {
    private static final ComponentTempTable TABLE = ComponentTempTable.DEFAULT;
    private ComponentID mCompID;
    private String mDefaultInstallPath;
    private String mDefaultInstallUser;
    private String mDefaultInstallGroup;
    private VariableSettingsHolder mVars = new VariableSettingsHolder();
    private String[] mVarNames;
    private HashSet mFinalVars = new HashSet();
    private String mCompName;
    private VersionNumber mVersion;
    private static final String INSTALL_PATH_VAR = "installPath";
    private static final String INSTALL_PATH_REF = ":[installPath]";

    public String getName() {
        return this.mCompName;
    }

    public String getVersion() {
        return this.mVersion.getAsString();
    }

    public int getNumVars() {
        return this.mVarNames.length;
    }

    public String getVarName(int index) {
        return this.mVarNames[index];
    }

    public String getVarValue(int index) {
        return this.mVars.getVarValue(this.getVarName(index));
    }

    public boolean containsVar(String varName) {
        return this.mVars.containsVarValue(varName);
    }

    public String getDefaultInstallPath() {
        return this.mDefaultInstallPath;
    }

    public String getDefaultInstallUser() {
        return this.mDefaultInstallUser;
    }

    public String getDefaultInstallGroup() {
        return this.mDefaultInstallGroup;
    }

    public boolean isFinalVar(int index) {
        return this.mFinalVars.contains(this.getVarName(index));
    }

    private boolean isSystemService(String implementsList) {
        return implementsList.indexOf("[ResourceHandler]") != -1 || implementsList.indexOf("[SystemService]") != -1;
    }

    public boolean addLinkToComp(String pathStr, String name, String version) throws PersistenceManagerException, RPCException {
        try {
            block4: {
                FolderID path = null;
                SingleComponentQuery q = SingleComponentQuery.byName(path, name, version);
                ComponentID refdCompID = q.selectSummaryView().getID();
                try {
                    ComponentToComponentLinkTable.DEFAULT.addLink(this.mCompID, refdCompID);
                }
                catch (ConstraintViolationException e) {
                    if ("c_comp_comp_link_unique".equals(e.getConstraintName())) break block4;
                    throw e;
                }
            }
            return true;
        }
        catch (NoResultsFoundException e) {
            ComponentImplTable ct = ComponentImplTable.DEFAULT;
            ComponentImplTable.execute(ct.update(ComponentImplTable.uList(ComponentImplTable.set(ct.Modifier, Modifier.ABSTRACT)), ComponentImplTable.where(ComponentImplTable.equals(ct.ID, this.mCompID))));
            return false;
        }
    }

    public static ComponentInfo getCurrentInfo() throws PersistenceManagerException {
        ComponentID compID = (ComponentID)TransformMigrator.getCurrentObjectID();
        Select query = TABLE.selectByID(compID);
        Processor p = new Processor(compID);
        QueryBuilder.execute(query, p);
        return p.getResult();
    }

    private ComponentInfo(ComponentID compID, ResultSet rs) throws SQLException {
        this.mCompID = compID;
        this.mDefaultInstallPath = ComponentInfo.TABLE.DefaultInstallPath.retrieveValue(rs);
        this.mDefaultInstallUser = ComponentInfo.TABLE.DefaultInstallUser.retrieveValue(rs);
        this.mDefaultInstallGroup = ComponentInfo.TABLE.DefaultInstallGroup.retrieveValue(rs);
        Database db = ((Migrator)Migrator.getApp()).getPMSubsystem().getDefaultDatabase();
        String varSettingsArrayStr = ComponentInfo.TABLE.VarSettings.retrieveValue(rs);
        String[] varSettingsArray = StringAttributeMap.arrayFromSQLString(db, varSettingsArrayStr);
        this.mVars.setVarSettings(varSettingsArray);
        String implementsList = ComponentInfo.TABLE.ImplementsList.retrieveValue(rs);
        this.mCompName = ComponentInfo.TABLE.Name.retrieveValue(rs);
        this.mVersion = new VersionNumber(ComponentInfo.TABLE.Version.retrieveValue(rs));
        if (this.isSystemService(implementsList) && !INSTALL_PATH_REF.equals(this.mDefaultInstallPath)) {
            if (this.mVars.containsVarValue(INSTALL_PATH_VAR)) {
                String msg = "Warning: System service component " + this.mCompName + " version " + this.mVersion.getAsString() + " defines a local \"" + INSTALL_PATH_VAR + "\" variable and " + "has a non-standard \"defaultInstallPath\" value: " + this.mDefaultInstallPath + ".  The install path must be " + "manually repaired.";
                System.err.println(msg);
            } else {
                this.mVars.setVarValue(INSTALL_PATH_VAR, this.mDefaultInstallPath);
                this.mFinalVars.add(INSTALL_PATH_VAR);
            }
        }
        this.mVarNames = this.mVars.getVarNames();
    }

    private static class Processor
    extends ResultSetProcessor {
        ComponentInfo mResult;
        ComponentID mCompID;

        public Processor(ComponentID compID) {
            this.mCompID = compID;
        }

        public void processResultSet(ResultSet inResultSet) throws SQLException {
            while (inResultSet.next()) {
                this.mResult = new ComponentInfo(this.mCompID, inResultSet);
            }
        }

        ComponentInfo getResult() {
            return this.mResult;
        }
    }
}

