/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m20to30;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.exception.ResourceSpecException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MigrateUtil
extends QueryBuilder {
    private static final String COMP_VAR_PREFIX = ":[component:";
    private static final ResourceTable RT = new ResourceTable("rT");
    private static final ComponentImplTable CT = new ComponentImplTable("cT");

    public static String migrateConfigValue(String value) {
        int colonIdx;
        if (value == null) {
            return null;
        }
        int idx = 0;
        int lastIdx = 0;
        StringBuffer buffer = new StringBuffer();
        while ((idx = value.indexOf(COMP_VAR_PREFIX, lastIdx)) != -1 && (colonIdx = value.indexOf(58, idx += COMP_VAR_PREFIX.length())) != -1) {
            String comp = value.substring(idx, colonIdx);
            String version = null;
            int tmp = comp.indexOf(35);
            if (tmp != -1) {
                version = comp.substring(tmp + 1);
                comp = comp.substring(0, tmp);
            }
            String path = null;
            tmp = comp.lastIndexOf(47);
            if (tmp != -1) {
                path = comp.substring(0, tmp);
                comp = comp.substring(tmp + 1);
            }
            buffer.append(value.substring(lastIdx, idx));
            buffer.append(comp);
            if (version != null) {
                buffer.append('#').append("1.").append(version);
            }
            if (path != null) {
                buffer.append("@{").append(path).append('}');
            }
            lastIdx = colonIdx;
        }
        buffer.append(value.substring(lastIdx, value.length()));
        return buffer.toString();
    }

    public static String getVersionNumber(String componentName, String resourceName, String currentVersion) {
        try {
            resourceName = new ResourceSpec(resourceName).getName();
            if (currentVersion != null && currentVersion.length() > 0) {
                return currentVersion;
            }
            AndExp cond = MigrateUtil.and(MigrateUtil.equals(MigrateUtil.RT.Name, resourceName), RT.isLatest());
            cond.add(MigrateUtil.isNull(MigrateUtil.RT.CustomParentID));
            VersionNumber v = MigrateUtil.getVersion(RT.select(MigrateUtil.sList(MigrateUtil.RT.Version), MigrateUtil.where(cond)));
            if (v != null) {
                return v.getAsString();
            }
        }
        catch (PersistenceManagerException e) {
            System.err.println("error converting version:" + e);
        }
        catch (ResourceSpecException e) {
            System.err.println("error converting version:" + e);
        }
        return "1.0";
    }

    private static VersionNumber getVersion(Select query) throws PersistenceManagerException {
        VersionProcessor p = new VersionProcessor();
        MigrateUtil.execute(query, p);
        return p.getResult();
    }

    private static class VersionProcessor
    extends ResultSetProcessor {
        VersionNumber mResult = null;

        private VersionProcessor() {
        }

        VersionNumber getResult() {
            return this.mResult;
        }

        public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            if (inResultSet.next()) {
                int version = RT.Version.retrieveValue(inResultSet);
                this.mResult = new VersionNumber(version);
            }
        }
    }
}

