/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m20to30;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.migrate.Migrator;
import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.migrate.m20to30.CompRsrcLinkMigrator;
import com.raplix.rolloutexpress.migrate.m20to30.CompVarValueMigrator;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.util.file.Transform;
import com.raplix.util.logger.Logger;
import java.io.IOException;

public class MigrateData
extends Migrator {
    public static final String PLAN_COMP_FILE_ARG = "-pcfile";
    public static final String COMP_RSRC_FILE_ARG = "-crfile";
    public static final String NS_FILE_ARG = "-nsfile";
    private String mXSLPlanCompFile = null;
    private String mXSLCompRsrcVerFile = null;
    private String mNamespaceTransformFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block10: {
            MigrateData migrator;
            int nErrors;
            block11: {
                nErrors = 0;
                migrator = null;
                migrator = new MigrateData(args);
                migrator.start();
                nErrors = migrator.doMigration();
                Object var5_3 = null;
                if (migrator == null) break block10;
                try {
                    migrator.shutdown();
                }
                catch (RaplixShutdownException rse) {
                    if (!Logger.isErrorEnabled(MigrateData.class)) break block11;
                    Logger.error("Error shutting down: ", rse, MigrateData.class);
                }
            }
            migrator.exitProcess(nErrors);
            {
                break block10;
                catch (Exception e) {
                    block12: {
                        ++nErrors;
                        if (Logger.isErrorEnabled(MigrateData.class)) {
                            Logger.error("Unexpected Error: ", e, MigrateData.class);
                        }
                        Object var5_4 = null;
                        if (migrator == null) break block10;
                        try {
                            migrator.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (!Logger.isErrorEnabled(MigrateData.class)) break block12;
                            Logger.error("Error shutting down: ", rse, MigrateData.class);
                        }
                    }
                    migrator.exitProcess(nErrors);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (migrator != null) {
                    block13: {
                        try {
                            migrator.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (!Logger.isErrorEnabled(MigrateData.class)) break block13;
                            Logger.error("Error shutting down: ", rse, MigrateData.class);
                        }
                    }
                    migrator.exitProcess(nErrors);
                }
                throw throwable;
            }
        }
    }

    protected EntityMigrator[] getMigrators() throws IOException {
        Transform[] planTransforms = new Transform[]{this.getPerl5TransformerFromFile(this.mNamespaceTransformFile), this.getXSLTTransformerFromFile(this.mXSLPlanCompFile)};
        Transform[] compTransforms = new Transform[]{planTransforms[0], planTransforms[1], this.getXSLTTransformerFromFile(this.mXSLCompRsrcVerFile)};
        return new EntityMigrator[]{new CompRsrcLinkMigrator(this.mPM.getDefaultDatabase()), new TransformMigrator(ComponentImplTable.DEFAULT, compTransforms, ComponentImplTable.DEFAULT.XMLContent), new TransformMigrator(ExecutionPlanImplTable.DEFAULT, planTransforms, ExecutionPlanImplTable.DEFAULT.BodyXML), new CompVarValueMigrator(this.mPM.getDefaultDatabase(), ComponentVariableSettingsImplTable.DEFAULT, ComponentVariableSettingsImplTable.DEFAULT.OverrideSettings)};
    }

    MigrateData(String[] args) throws ConfigurationException {
        super(args);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(PLAN_COMP_FILE_ARG)) {
                this.mXSLPlanCompFile = args[++i];
                continue;
            }
            if (args[i].startsWith(COMP_RSRC_FILE_ARG)) {
                this.mXSLCompRsrcVerFile = args[++i];
                continue;
            }
            if (!args[i].startsWith(NS_FILE_ARG)) continue;
            this.mNamespaceTransformFile = args[++i];
        }
        if (this.mXSLPlanCompFile == null) {
            throw new IllegalArgumentException("Please supply the path to the XSL transform file (planComp_2.0_3.0.xsl) as -pcfile <fileName>");
        }
        if (this.mXSLCompRsrcVerFile == null) {
            throw new IllegalArgumentException("Please supply the path to the XSL transform file (compRsrcVersion_2.0_3.0.xsl) as -crfile <fileName>");
        }
        if (this.mNamespaceTransformFile == null) {
            throw new IllegalArgumentException("Please supply the path to the perl transform file (namespace_2.0_3.0.xsl) as -nsfile <fileName>");
        }
    }
}

