/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m20to30;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m20to30.MigrateUtil;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CompVarValueMigrator
extends TableMigrator {
    private Database mDB;
    private Table mTable;
    private StringColumn mArrayStringColumn;

    public CompVarValueMigrator(Database db, Table inTable, StringColumn inArrayStringColumn) {
        this.mDB = db;
        this.mTable = inTable;
        this.mArrayStringColumn = inArrayStringColumn;
    }

    protected Table getTable() {
        return this.mTable;
    }

    protected SelectList getSelectList() {
        return CompVarValueMigrator.sList(this.mTable.ID, (ScalarExp)this.mArrayStringColumn);
    }

    protected ColumnNode getOrderColumn() {
        return this.mTable.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID ID2 = this.mTable.ID.retrieveValue(rs);
        String sqlArrayStr = this.mArrayStringColumn.retrieveValue(rs);
        final String[] vals = StringAttributeMap.arrayFromSQLString(this.mDB, sqlArrayStr);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                CompVarValueMigrator.this.migrate(ID2, vals);
            }

            public String toString() {
                return "ID:" + ID2;
            }
        };
    }

    private void migrate(ObjectID id, String[] vals) throws PersistenceManagerException {
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = MigrateUtil.migrateConfigValue(vals[i]);
        }
        String arrayStr = StringAttributeMap.arrayToSQLString(vals);
        CompVarValueMigrator.execute(CompVarValueMigrator.update(this.mTable, CompVarValueMigrator.uList(CompVarValueMigrator.set(this.mArrayStringColumn, arrayStr)), CompVarValueMigrator.where(CompVarValueMigrator.equals(this.mTable.ID, id))));
    }
}

