/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.util.file.Transform;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TransformMigrator
extends TableMigrator {
    private Table mTable;
    private Transform[] mTransforms;
    private StringColumn mColumn;
    private String mWrapperElemOpen;
    private String mWrapperElemClose;
    private static ObjectID currentID = null;

    public TransformMigrator(Table table, Transform[] transforms, StringColumn column) {
        this.mTable = table;
        this.mTransforms = transforms;
        this.mColumn = column;
    }

    public TransformMigrator(Table table, Transform[] transforms, StringColumn column, String wrapperElemOpen, String wrapperElemClose) {
        this(table, transforms, column);
        this.mWrapperElemOpen = wrapperElemOpen;
        this.mWrapperElemClose = wrapperElemClose;
    }

    protected Table getTable() {
        return this.mTable;
    }

    protected SelectList getSelectList() {
        return TransformMigrator.sList(this.mTable.ID, (ScalarExp)this.mColumn);
    }

    protected ColumnNode getOrderColumn() {
        return this.mTable.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = this.mTable.ID.retrieveValue(rs);
        final String value = this.mColumn.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                TransformMigrator.this.migrate(id, value);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String value) throws PersistenceManagerException, IOException {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        currentID = id;
        for (int i = 0; i < this.mTransforms.length; ++i) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Executing Transform:" + i, this);
            }
            value = this.transform(value, this.mTransforms[i]);
        }
        TransformMigrator.execute(TransformMigrator.update(this.mTable, TransformMigrator.uList(TransformMigrator.set(this.mColumn, value)), TransformMigrator.where(TransformMigrator.equals(this.mTable.ID, id))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transform(String value, Transform tx) throws IOException {
        String string;
        block7: {
            StringReader reader = null;
            StringWriter writer = null;
            try {
                reader = new StringReader(this.addWrapperElem(value));
                writer = new StringWriter();
                tx.apply(reader, writer);
                string = this.removeWrapperElem(writer.toString());
                Object var7_6 = null;
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var7_7 = null;
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer == null) break block8;
                    try {
                        writer.close();
                    }
                    catch (IOException ignored) {}
                }
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return string;
    }

    private String addWrapperElem(String value) {
        if (this.mWrapperElemOpen != null) {
            value = this.mWrapperElemOpen + value;
        }
        if (this.mWrapperElemClose != null) {
            value = value + this.mWrapperElemClose;
        }
        return value;
    }

    private String removeWrapperElem(String value) {
        int start;
        if (this.mWrapperElemOpen != null && (start = value.indexOf(this.mWrapperElemOpen)) != -1) {
            value = value.substring(start + this.mWrapperElemOpen.length());
        }
        if (this.mWrapperElemClose != null && (start = value.lastIndexOf(this.mWrapperElemClose)) != -1) {
            value = value.substring(0, start);
        }
        return value;
    }

    public static ObjectID getCurrentObjectID() {
        return currentID;
    }
}

