/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate;

import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

public abstract class TableMigrator
extends QueryBuilder
implements EntityMigrator {
    private static final int NUM_ROWS_STEP = 10;

    protected abstract Table getTable();

    protected abstract SelectList getSelectList();

    protected abstract ColumnNode getOrderColumn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int migrate() throws PersistenceManagerException {
        int nErrors = 0;
        Table t = this.getTable();
        int numRows = TableMigrator.selectCount(this.getTable());
        Select query = this.createSelect();
        for (int offset = 0; offset < numRows; offset += 10) {
            Migratable[] results = this.fetchRows(query, offset, 10);
            for (int i = 0; i < results.length; ++i) {
                boolean updateFailed = true;
                try {
                    if (results[i] != null) {
                        results[i].migrate();
                    }
                    updateFailed = false;
                    continue;
                }
                catch (PersistenceManagerException pme) {
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error("Error migrating " + this.getTable().getTableName() + ":" + results[i], pme, this);
                    continue;
                }
                catch (IOException ioe) {
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error("Error migrating " + this.getTable().getTableName() + ":" + results[i], ioe, this);
                    continue;
                }
                finally {
                    if (updateFailed) {
                        ++nErrors;
                    }
                }
            }
        }
        return nErrors;
    }

    private Select createSelect() {
        return TableMigrator.select(this.getSelectList(), this.getTableList(), this.getWhereClause(), this.getOrderByList());
    }

    protected TableList getTableList() {
        return TableMigrator.tList(this.getTable());
    }

    protected WhereClause getWhereClause() {
        return null;
    }

    protected OrderByList getOrderByList() {
        return TableMigrator.oList(TableMigrator.orderByAsc(this.getOrderColumn()));
    }

    private Migratable[] fetchRows(Select query, int offset, int size) throws PersistenceManagerException {
        Processor processor = new Processor();
        TableMigrator.execute(TableMigrator.limit(query, size, offset), processor);
        return processor.getResults();
    }

    protected abstract Migratable processRow(ResultSet var1) throws PersistenceManagerException, SQLException;

    private class Processor
    extends ResultSetProcessor {
        private LinkedList results = new LinkedList();

        private Processor() {
        }

        public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            while (inResultSet.next()) {
                this.results.add(TableMigrator.this.processRow(inResultSet));
            }
        }

        Migratable[] getResults() {
            return this.results.toArray(new Migratable[this.results.size()]);
        }
    }
}

