/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.util.file.Perl5Transform;
import com.raplix.util.file.XSLTTransform;
import com.raplix.util.logger.Logger;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public abstract class Migrator
extends Application {
    protected NetSubsystem mNetworkSubsystem;
    protected PersistenceManager mPM = new PersistenceManager(this);
    protected UserDBSubsystem mUserDB;
    protected HostDBSubsystem mHostDB;
    protected NotificationManager mNotificationManager;
    protected ResourceSubsystem mResourceSubsystem;
    protected ConfigGenSubsystem mConfigGenSubsystem;
    protected PluginDBSubsystem mPluginDB;

    public Migrator(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs);
        this.mNetworkSubsystem = NetSubsystem.createNetSubsystemForLocal(this);
        this.mHostDB = new HostDBSubsystem(this);
        this.mNotificationManager = new NotificationManager((Application)this, true);
        this.mUserDB = new UserDBSubsystem(this);
        this.mConfigGenSubsystem = new ConfigGenSubsystem(this);
        this.mResourceSubsystem = new ResourceSubsystem((Application)this, true);
        this.mPluginDB = new PluginDBSubsystem(this);
        RPCManager rpc = this.mNetworkSubsystem.getRPC();
        try {
            this.mPM.registerRPCInterfaces(rpc);
            this.mNetworkSubsystem.registerRPCInterfaces(rpc);
            this.mNotificationManager.registerRPCInterfaces(rpc);
            this.mUserDB.registerRPCInterfaces(rpc);
            this.mPluginDB.registerRPCInterfaces(rpc);
            this.mConfigGenSubsystem.registerRPCInterfaces(rpc);
            this.mResourceSubsystem.registerRPCInterfaces(rpc);
        }
        catch (RPCException rpce) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Encountered an exception while registering subsystem with RPC manager", rpce, this);
            }
            throw new ConfigurationException("Unable to register subystem with RPC manager", (Throwable)rpce);
        }
        this.mPM.postInit();
        this.mHostDB.postInit();
    }

    protected abstract EntityMigrator[] getMigrators() throws IOException;

    public int doMigration() throws Exception {
        EntityMigrator[] migrators = this.getMigrators();
        int nErrors = 0;
        for (int i = 0; i < migrators.length; ++i) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Running Migrator:" + i + ":" + migrators[i], this);
            }
            nErrors += migrators[i].migrate();
        }
        return nErrors;
    }

    protected XSLTTransform getXSLTTransformerFromFile(String fileName) throws IOException {
        return new XSLTTransform(new StreamSource(new FileReader(fileName)));
    }

    protected Perl5Transform getPerl5TransformerFromFile(String fileName) throws IOException {
        return new Perl5Transform(new InputSource(new FileReader(fileName)));
    }

    protected String getVersionString() {
        return "";
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNetworkSubsystem;
    }

    protected void shutdown() throws RaplixShutdownException {
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            block31: {
                                                                block30: {
                                                                    try {
                                                                        this.mPluginDB.prepareForShutdown();
                                                                    }
                                                                    catch (RaplixShutdownException rse) {
                                                                        if (this.mShutdownRequestIsEmergency) break block30;
                                                                        throw new RaplixShutdownException("Cannot shutdown: pluginDB subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                    }
                                                                }
                                                                try {
                                                                    this.mResourceSubsystem.prepareForShutdown();
                                                                }
                                                                catch (RaplixShutdownException rse) {
                                                                    if (this.mShutdownRequestIsEmergency) break block31;
                                                                    throw new RaplixShutdownException("Cannot shutdown: resource subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                }
                                                            }
                                                            try {
                                                                this.mConfigGenSubsystem.prepareForShutdown();
                                                            }
                                                            catch (RaplixShutdownException rse) {
                                                                if (this.mShutdownRequestIsEmergency) break block32;
                                                                throw new RaplixShutdownException("Cannot shutdown: config gen subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                            }
                                                        }
                                                        try {
                                                            this.mUserDB.prepareForShutdown();
                                                        }
                                                        catch (RaplixShutdownException rse) {
                                                            if (this.mShutdownRequestIsEmergency) break block33;
                                                            throw new RaplixShutdownException("Cannot shutdown: userDB subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                        }
                                                    }
                                                    try {
                                                        this.mNotificationManager.prepareForShutdown();
                                                    }
                                                    catch (RaplixShutdownException rse) {
                                                        if (this.mShutdownRequestIsEmergency) break block34;
                                                        throw new RaplixShutdownException("Cannot shutdown: notification subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                    }
                                                }
                                                try {
                                                    this.mHostDB.prepareForShutdown();
                                                }
                                                catch (RaplixShutdownException rse) {
                                                    if (this.mShutdownRequestIsEmergency) break block35;
                                                    throw new RaplixShutdownException("Cannot shutdown: hostDB subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                }
                                            }
                                            try {
                                                this.mNetworkSubsystem.prepareForShutdown();
                                            }
                                            catch (RaplixShutdownException rse) {
                                                if (this.mShutdownRequestIsEmergency) break block36;
                                                throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                            }
                                        }
                                        try {
                                            this.mPM.prepareForShutdown();
                                        }
                                        catch (RaplixShutdownException rse) {
                                            if (this.mShutdownRequestIsEmergency) break block37;
                                            throw new RaplixShutdownException("Cannot shutdown: PersistenceManager subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                        }
                                    }
                                    try {
                                        this.mPluginDB.shutdown();
                                    }
                                    catch (RaplixShutdownException rse) {
                                        if (this.mShutdownRequestIsEmergency) break block38;
                                        throw new RaplixShutdownException("Cannot shutdown: plugin db cannot shutdown.  Specific error: " + rse.getMessage());
                                    }
                                }
                                try {
                                    this.mResourceSubsystem.shutdown();
                                }
                                catch (RaplixShutdownException rse) {
                                    if (this.mShutdownRequestIsEmergency) break block39;
                                    throw new RaplixShutdownException("Cannot shutdown: resource subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                }
                            }
                            try {
                                this.mConfigGenSubsystem.shutdown();
                            }
                            catch (RaplixShutdownException rse) {
                                if (this.mShutdownRequestIsEmergency) break block40;
                                throw new RaplixShutdownException("Cannot shutdown: config gen subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                            }
                        }
                        this.mUserDB.shutdown();
                        try {
                            this.mNotificationManager.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (this.mShutdownRequestIsEmergency) break block41;
                            throw new RaplixShutdownException("Cannot shutdown: notification subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                        }
                    }
                    try {
                        this.mHostDB.shutdown();
                    }
                    catch (RaplixShutdownException rse) {
                        if (this.mShutdownRequestIsEmergency) break block42;
                        throw new RaplixShutdownException("Cannot shutdown: hostdb cannot shutdown.  Specific error: " + rse.getMessage());
                    }
                }
                try {
                    this.mNetworkSubsystem.shutdown();
                }
                catch (RaplixShutdownException rse) {
                    if (this.mShutdownRequestIsEmergency) break block43;
                    throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                }
            }
            try {
                this.mPM.shutdown();
            }
            catch (RaplixShutdownException rse) {
                if (this.mShutdownRequestIsEmergency) break block44;
                throw new RaplixShutdownException("Cannot shutdown: PersistenceManager subsystem cannot shutdown.  Specific error: " + rse.getMessage());
            }
        }
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
        Subsystem.addConfigurationForSubsystem(inTable, NotificationManager.class);
        Subsystem.addConfigurationForSubsystem(inTable, NetSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, UserDBSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, HostDBSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, ConfigGenSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, PersistenceManager.class);
        Subsystem.addConfigurationForSubsystem(inTable, ResourceSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, PluginDBSubsystem.class);
    }

    public PersistenceManager getPMSubsystem() {
        return this.mPM;
    }

    public UserDBSubsystem getUserDBSubsystem() throws UnsupportedSubsystemException {
        return this.mUserDB;
    }

    public NotificationManager getNotificationManager() throws UnsupportedSubsystemException {
        return this.mNotificationManager;
    }

    public ResourceSubsystem getResourceSubsystem() {
        return this.mResourceSubsystem;
    }

    public ConfigGenSubsystem getConfigGenSubsystem() {
        return this.mConfigGenSubsystem;
    }

    public PluginDBSubsystem getPluginDBSubsystem() {
        return this.mPluginDB;
    }

    public HostDBSubsystem getHostDBSubsystem() {
        return this.mHostDB;
    }
}

