/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.SetList;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ArrayColumnMigrator
extends TableMigrator {
    private Table mSourceTable;
    private StringColumn mSourceIDColumn;
    private StringColumn mSourceColumn;
    private Table mTargetTable;
    private IDColumn mTargetColumn;
    private IDColumn mTargetArrayValueColumn;

    public ArrayColumnMigrator(Table inSourceTable, StringColumn inSourceIDColumn, StringColumn inSourceColumn, Table inTargetTable, IDColumn inTargetColumn) {
        this(inSourceTable, inSourceIDColumn, inSourceColumn, inTargetTable, inTargetColumn, null);
    }

    public ArrayColumnMigrator(Table inSourceTable, StringColumn inSourceIDColumn, StringColumn inSourceColumn, Table inTargetTable, IDColumn inTargetColumn, IDColumn inTargetArrayValueColumn) {
        this.mSourceTable = inSourceTable;
        this.mSourceIDColumn = inSourceIDColumn;
        this.mSourceColumn = inSourceColumn;
        this.mTargetTable = inTargetTable;
        this.mTargetColumn = inTargetColumn;
        this.mTargetArrayValueColumn = inTargetArrayValueColumn;
    }

    protected Table getTable() {
        return this.mSourceTable;
    }

    protected SelectList getSelectList() {
        return ArrayColumnMigrator.sList(this.mSourceIDColumn, (ScalarExp)this.mSourceColumn);
    }

    protected ColumnNode getOrderColumn() {
        return this.mSourceIDColumn;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID objectID = new ObjectID(this.mSourceIDColumn.retrieveValue(rs));
        String arrayValue = this.mSourceColumn.retrieveValue(rs);
        if (arrayValue != null && arrayValue.trim().length() > 0) {
            final String[] value = StringAttributeMap.arrayFromSQLString(PersistenceManager.getInstance().getDefaultDatabase(), arrayValue);
            return new Migratable(){

                public void migrate() throws PersistenceManagerException, IOException {
                    for (int i = 0; i < value.length; ++i) {
                        ObjectID id = new ObjectID(value[i]);
                        if (ArrayColumnMigrator.this.mTargetArrayValueColumn != null) {
                            QueryBuilder.execute(ArrayColumnMigrator.this.mTargetTable.insert(QueryBuilder.cList(ArrayColumnMigrator.this.mTargetArrayValueColumn, (ColumnNode)ArrayColumnMigrator.this.mTargetColumn), QueryBuilder.vList(QueryBuilder.v(id), QueryBuilder.v(objectID))));
                            continue;
                        }
                        Table table = ArrayColumnMigrator.this.mTargetTable;
                        SetList setList = ArrayColumnMigrator.this.getUpdateList(objectID, i);
                        ArrayColumnMigrator.this.mTargetTable;
                        QueryBuilder.execute(table.update(setList, QueryBuilder.where(Table.equals(((ArrayColumnMigrator)ArrayColumnMigrator.this).mTargetTable.ID, id))));
                    }
                }
            };
        }
        return null;
    }

    protected SetList getUpdateList(ObjectID inObjectID, int index) {
        return ArrayColumnMigrator.uList(ArrayColumnMigrator.set(this.mTargetColumn, inObjectID));
    }
}

