/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.message;

import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.message.PortableMessage;
import java.util.Locale;

public class ROXMessage
extends PortableMessage
implements RPCSerializable {
    public static final int SYSTEM_ERROR = 3000;
    public static final int VALIDATION_ERROR = 2000;
    private int mMessageType = 3000;
    private Severity mSeverity = Severity.ERROR;

    public ROXMessage(String inTokenKey, Object[] inArguments, int inMessageType) {
        super(inTokenKey, inArguments);
        this.mMessageType = inMessageType;
    }

    public ROXMessage(String inTokenKey, Object[] inArguments, int inMessageType, Severity inSeverity) {
        super(inTokenKey, inArguments);
        this.mMessageType = inMessageType;
        this.mSeverity = inSeverity;
    }

    public ROXMessage(String inTokenKey, Object[] inArguments) {
        this(inTokenKey, inArguments, 3000);
    }

    public ROXMessage(String inTokenKey, Object[] inArguments, Severity inSeverity) {
        this(inTokenKey, inArguments);
        this.mSeverity = inSeverity;
    }

    public ROXMessage(String inTokenKey, int inMessageType) {
        super(inTokenKey);
        this.mMessageType = inMessageType;
    }

    public ROXMessage(String inTokenKey) {
        this(inTokenKey, 3000);
    }

    public ROXMessage(String inTokenKey, String arg1) {
        this(inTokenKey, new String[]{arg1});
    }

    public ROXMessage(String inTokenKey, String arg1, String arg2) {
        this(inTokenKey, new String[]{arg1, arg2});
    }

    public ROXMessage(String inTokenKey, String arg1, String arg2, String arg3) {
        this(inTokenKey, new String[]{arg1, arg2, arg3});
    }

    private ROXMessage() {
    }

    public int getMessageType() {
        return this.mMessageType;
    }

    public String getMessageString() {
        return this.getMessageString(null);
    }

    public Severity getSeverity() {
        return this.mSeverity;
    }

    public String getMessageString(Locale inLocale) {
        String outMessage = "";
        outMessage = inLocale == null ? ROXMessageManager.messageAsString(this) : ROXMessageManager.messageAsString(this, inLocale);
        return outMessage;
    }

    public String toString() {
        return this.getMessageString();
    }
}

