/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport.status;

import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCancelled;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompWasRedundant;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Cancelled;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Failed;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.InProgress;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Succeeded;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.WasRedundant;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;

public class CompStatus
implements RPCSerializable {
    private long mEndTime;

    CompStatus() {
    }

    public CompStatus(long endTime) {
        this.mEndTime = endTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public static CompStatus mapResourceStatus(CheckInStatus rsrcStatus, long time, Component comp) {
        if (rsrcStatus instanceof Failed) {
            return new CompError(time, ((Failed)rsrcStatus).getException());
        }
        if (rsrcStatus instanceof InProgress) {
            return new CompPending();
        }
        if (rsrcStatus instanceof Succeeded) {
            return new CompComplete(time, comp);
        }
        if (rsrcStatus instanceof Cancelled) {
            return new CompCancelled(time);
        }
        if (rsrcStatus instanceof WasRedundant) {
            return new CompWasRedundant(time);
        }
        return null;
    }
}

