/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInMonitor;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.SystemData;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SystemDataImpl
implements SystemData {
    private String mCompTypeName;
    private String mCompTypePlatform;
    private AccessControlContext mAccessControlContext;
    private HostID mHostID;
    private ComponentType mCompType = null;
    private BrowserInfo mBrowser = null;
    private com.sun.n1.util.vars.VariableSettingsSource mCompTypeVars = null;
    private com.sun.n1.util.vars.VariableSettingsSource mSysSrvcVars = null;
    private com.sun.n1.util.vars.VariableSettingsSource mTargetCompVars = null;
    private com.sun.n1.util.vars.VariableSettingsSource mHostVars = null;
    private String mServiceName;

    public SystemDataImpl(BrowserInfo browser, String compType, String serviceName, HostID hostID, AccessControlContext acCtx) throws ConfigGenException, PersistenceManagerException, RPCException {
        this.mAccessControlContext = acCtx;
        this.mCompTypeName = compType;
        this.mBrowser = browser;
        this.mHostID = hostID;
        if (compType != null) {
            this.mCompType = ComponentType.create(compType);
            Component comp = this.mCompType.getComponent();
            this.mCompTypePlatform = comp.getPlatform();
            this.mCompTypeVars = VarDecl.toVariableSettings(comp.getVarList(null));
        }
        this.mServiceName = serviceName;
        this.mSysSrvcVars = this.wrappedGetServiceVars(serviceName);
        this.mTargetCompVars = this.getTargetCompVars();
        this.mHostVars = this.getHostVars();
    }

    public BrowserInfo getBrowserInfo() {
        return this.mBrowser;
    }

    public com.sun.n1.util.vars.VariableSettingsSource getComponentTypeVars() {
        return this.mCompTypeVars;
    }

    public com.sun.n1.util.vars.VariableSettingsSource getSystemServiceVars() {
        return this.mSysSrvcVars;
    }

    public com.sun.n1.util.vars.VariableSettingsSource getPluginComponentVars() {
        return this.mTargetCompVars;
    }

    public com.sun.n1.util.vars.VariableSettingsSource getPluginHostVars() {
        return this.mHostVars;
    }

    public String getComponentTypeName() {
        return this.mCompTypeName;
    }

    public String getCompTypePlatform() {
        return this.mCompTypePlatform;
    }

    public boolean compTypeIsInstanceOf(final String compType) throws ComponentExportException {
        try {
            final boolean[] instance = new boolean[1];
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException {
                    instance[0] = SystemDataImpl.this.mCompType.isInstanceOf(ComponentType.create(compType));
                    return null;
                }
            }, this.mAccessControlContext);
            return instance[0];
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof NoResultsFoundException) {
                return false;
            }
            throw new ComponentExportException(CompCheckInMonitor.SDK_MSG, (Throwable)e.getException());
        }
    }

    public com.sun.n1.util.vars.VariableSettingsSource getSystemServiceVars(final String serviceName) throws ComponentExportException {
        try {
            return (com.sun.n1.util.vars.VariableSettingsSource)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException {
                    return SystemDataImpl.this.wrappedGetServiceVars(serviceName);
                }
            }, this.mAccessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw new ComponentExportException(CompCheckInMonitor.SDK_MSG, (Throwable)e.getException());
        }
    }

    SystemDataImpl updateCT(String ct, AccessControlContext acCtx) throws ConfigGenException, PersistenceManagerException, RPCException {
        return new SystemDataImpl(this.mBrowser, ct, this.mServiceName, this.mHostID, acCtx);
    }

    private com.sun.n1.util.vars.VariableSettingsSource wrappedGetServiceVars(String serviceName) throws ConfigGenException, PersistenceManagerException, RPCException {
        InstalledComponentBean[] checkSSBean;
        if (this.mHostID == null || serviceName == null) {
            return null;
        }
        PluginID pluginID = this.mCompType == null ? null : this.mCompType.getComponentTypeRef().getPluginID();
        SystemServiceRef ssRef = SingleSystemServiceRefQuery.byName(serviceName).select();
        PluginID ssPluginID = ssRef.getPluginID();
        CallSpec limitToPublicVars = CallSpec.PUBLIC;
        Boolean check = this.checkPluginCompatibility(pluginID, ssPluginID);
        if (check == null) {
            return null;
        }
        if (check.booleanValue()) {
            limitToPublicVars = null;
        }
        if ((checkSSBean = MultiInstalledComponentQuery.byCompRef(this.mHostID.getPhysicalHost().getID(), TargetType.CURRENT, ssRef.getInstalledComponentRef(), null).select()) == null || checkSSBean.length < 1) {
            return null;
        }
        return this.getVarSubset(checkSSBean[0], limitToPublicVars);
    }

    private com.sun.n1.util.vars.VariableSettingsSource getTargetCompVars() throws ConfigGenException, PersistenceManagerException, RPCException {
        if (this.mHostID == null) {
            return null;
        }
        InstalledComponentID targetCompID = this.mHostID.getByIDQuery().selectSummaryView().getInstalledComponentID();
        if (targetCompID == null) {
            return null;
        }
        PluginID pluginID = this.mCompType == null ? null : this.mCompType.getComponentTypeRef().getPluginID();
        Host host = this.mHostID.getByIDQuery().select();
        PluginID htPluginID = host.getHostType().getPluginID();
        CallSpec limitToPublicVars = CallSpec.PUBLIC;
        Boolean check = this.checkPluginCompatibility(pluginID, htPluginID);
        if (check == null) {
            return null;
        }
        if (check.booleanValue()) {
            limitToPublicVars = null;
        }
        return this.getVarSubset(new InstalledComponentBean(targetCompID), limitToPublicVars);
    }

    private com.sun.n1.util.vars.VariableSettingsSource getHostVars() throws ConfigGenException, PersistenceManagerException, RPCException {
        if (this.mHostID == null) {
            return null;
        }
        PluginID pluginID = this.mCompType == null ? null : this.mCompType.getComponentTypeRef().getPluginID();
        Host host = this.mHostID.getByIDQuery().select();
        PluginID htPluginID = host.getHostType().getPluginID();
        boolean limitToPublicVars = true;
        Boolean check = this.checkPluginCompatibility(pluginID, htPluginID);
        if (check == null) {
            return null;
        }
        if (check.booleanValue()) {
            limitToPublicVars = false;
        }
        VariableSettingsHolder holder = new VariableSettingsHolder();
        String[] vars = host.getVarNames();
        for (int i = 0; i < vars.length; ++i) {
            holder.setVarValue(vars[i], host.getVarValue(vars[i]));
        }
        Server server = (Server)Server.getApp();
        ConfigGenerator gen = server.getConfigGenSubsystem().getConfigGenerator().newSessionScope(server.getUserDBSubsystem().getLocalSessionManager(), limitToPublicVars).newUnresVarScope(holder);
        for (int i = 0; i < vars.length; ++i) {
            holder.setVarValue(vars[i], gen.generate(":[" + vars[i] + "]"));
        }
        return holder;
    }

    private Boolean checkPluginCompatibility(PluginID active, PluginID check) throws PersistenceManagerException, RPCException {
        if (active == null) {
            return check == null ? Boolean.TRUE : Boolean.FALSE;
        }
        if (check == null) {
            return null;
        }
        if (active.equals(check)) {
            return Boolean.TRUE;
        }
        PluginIDSet dependencies = active.getByIDQuery().select().getDependencies();
        if (dependencies.contains(check)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private com.sun.n1.util.vars.VariableSettingsSource getVarSubset(InstalledComponentBean bean, CallSpec spec) throws ConfigGenException, PersistenceManagerException, RPCException {
        VariableSettingsSource cfgVars = ComponentConfigManager.getComponentVars(bean.getGeneratedVariableSettings(), bean.getComponent());
        VariableSettingsHolder subset = new VariableSettingsHolder();
        VarDecl[] varList = bean.getComponent().getID().getByIDQuery().select().getVarList(spec);
        for (int i = 0; i < varList.length; ++i) {
            subset.setVarValue(varList[i].getName(), cfgVars.getVarValue(varList[i].getName()));
        }
        return subset;
    }
}

