/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.ObjectUtil;
import com.raplix.util.string.CSVUtil;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public class SourceInfo
implements VariableSettingsSource,
RPCSerializable {
    private HostID mHost;
    private String mBrowserType;
    private String mBrowseLocation;
    private String mResourceLocation;
    private Hashtable mData;
    private Vector mParameterNames;

    public SourceInfo(HostID host, String browserType, String browseLocation, String resourceLocation) {
        this.mHost = host;
        this.mBrowserType = browserType == null ? "" : browserType;
        this.mBrowseLocation = browseLocation == null ? "" : browseLocation;
        this.mResourceLocation = resourceLocation == null ? "" : resourceLocation;
        this.mData = new Hashtable();
        this.mParameterNames = new Vector();
    }

    private SourceInfo() {
    }

    public HostID getHost() {
        return this.mHost;
    }

    public String getBrowserType() {
        return this.mBrowserType;
    }

    void setBrowserType(String browserType) {
        this.mBrowserType = browserType == null ? "" : browserType;
    }

    public String getBrowseLocation() {
        return this.mBrowseLocation;
    }

    public String getResourceLocation() {
        return this.mResourceLocation;
    }

    public String getPersistString() {
        String[] names = this.getVarNames();
        String[] dataCSV = new String[names.length + 3];
        int i = 0;
        dataCSV[i++] = this.getBrowserType();
        dataCSV[i++] = this.getBrowseLocation();
        dataCSV[i++] = this.getResourceLocation();
        int j = 0;
        while (j < names.length) {
            dataCSV[i] = ((DataTuple)this.mData.get(names[j])).getCSVList();
            ++j;
            ++i;
        }
        return CSVUtil.composePSV(dataCSV);
    }

    public static SourceInfo reconstitute(HostID host, String persistString) {
        String resourceLocation;
        String browseLocation;
        String browserType;
        String[] data;
        int i = 0;
        if (StringUtil.isEmpty(persistString)) {
            data = new String[]{};
            browserType = null;
            browseLocation = null;
            resourceLocation = null;
        } else {
            data = CSVUtil.splitPSV(persistString);
            browserType = data[i++];
            browseLocation = data[i++];
            resourceLocation = data[i++];
        }
        SourceInfo si = new SourceInfo(host, browserType, browseLocation, resourceLocation);
        while (i < data.length) {
            si.addTuple(new DataTuple(data[i]));
            ++i;
        }
        return si;
    }

    public void addParameter(String name, String val, String desc) {
        this.addTuple(new DataTuple(name, val, desc));
    }

    private void addTuple(DataTuple tuple) {
        DataTuple existingTuple = (DataTuple)this.mData.get(tuple.getName());
        if (existingTuple == null) {
            this.mParameterNames.add(tuple.getName());
        }
        this.mData.put(tuple.getName(), tuple);
    }

    public void removeParameter(String name) {
        this.mData.remove(name);
        this.mParameterNames.remove(name);
    }

    public boolean containsVarValue(String varName) {
        return this.mData.containsKey(varName);
    }

    public String[] getVarNames() {
        return this.mParameterNames.toArray(new String[0]);
    }

    public String getVarValue(String varName) {
        DataTuple tuple = (DataTuple)this.mData.get(varName);
        if (tuple == null) {
            return null;
        }
        return tuple.getValue();
    }

    public String getVarDescription(String varName) {
        DataTuple tuple = (DataTuple)this.mData.get(varName);
        if (tuple == null) {
            return null;
        }
        return tuple.getDescription();
    }

    public String[] getVarDescriptions() {
        String[] names = this.getVarNames();
        String[] descriptions = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            descriptions[i] = this.getVarDescription(names[i]);
        }
        return descriptions;
    }

    public static boolean containsCheckinCurrentData(SourceInfo si) {
        return si != null && si.getHost() != null && !StringUtil.isEmpty(si.getResourceLocation());
    }

    public boolean equals(Object si) {
        if (this == si) {
            return true;
        }
        if (si == null || !(si instanceof SourceInfo)) {
            return false;
        }
        if (!ObjectUtil.equals(this.getHost(), ((SourceInfo)si).getHost())) {
            return false;
        }
        return this.getPersistString().equals(((SourceInfo)si).getPersistString());
    }

    public int hashCode() {
        return this.getHost().hashCode() + this.getPersistString().hashCode();
    }

    public String toString() {
        return "Host:" + this.getHost() + " PersistString:" + this.getPersistString();
    }

    public SourceInfo getDataClone() {
        return SourceInfo.reconstitute(this.getHost(), this.getPersistString());
    }

    private static class DataTuple
    implements RPCSerializable {
        private String mName;
        private String mVal;
        private String mDesc;

        public DataTuple(String name, String val, String desc) {
            if (StringUtil.isEmpty(name)) {
                throw new NullPointerException();
            }
            this.mName = name;
            this.mVal = val;
            if (this.mVal == null) {
                this.mVal = "";
            }
            this.mDesc = desc;
            if (this.mDesc == null) {
                this.mDesc = "";
            }
        }

        public DataTuple(String csvList) {
            String[] listVals = CSVUtil.splitCSV(csvList);
            if (StringUtil.isEmpty(listVals[0])) {
                throw new NullPointerException();
            }
            this.mName = listVals[0];
            this.mVal = listVals[1];
            this.mDesc = listVals[2];
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mVal;
        }

        public String getDescription() {
            return this.mDesc;
        }

        public String getCSVList() {
            return CSVUtil.composeCSV(new String[]{this.getName(), this.getValue(), this.getDescription()});
        }
    }
}

