/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.command.rpcinterfaces.FileOperationsInterface;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInMonitor;
import com.raplix.rolloutexpress.hierarchies.compexport.CompExportException;
import com.raplix.rolloutexpress.hierarchies.compexport.ExportContext;
import com.raplix.rolloutexpress.hierarchies.compexport.SDKResourceManifest;
import com.raplix.rolloutexpress.hierarchies.compexport.SystemDataImpl;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotDeletedQueryException;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.CheckInMode;
import com.raplix.rolloutexpress.resource.checkInJob.RedundancyCheckMode;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceTypeAndOptions;
import com.raplix.rolloutexpress.resource.checkInJob.StatusMonitor;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Cancelled;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Failed;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.InProgress;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.Succeeded;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.PermOptions;
import com.raplix.rolloutexpress.resource.packageformat.PosixPermOptions;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemService;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.CallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SystemServiceTargeter;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.threads.Context;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import com.sun.n1.sps.componentdb.InstallMode;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.ComponentExporter;
import com.sun.n1.sps.plugin.export.ResourceProcessor;
import com.sun.n1.sps.plugin.export.SimpleComponentMonitor;
import com.sun.n1.sps.resource.ResourceType;
import com.sun.n1.util.vars.VariableSettingsSource;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;

class SimpleMonitor
extends CompCheckInMonitor
implements SimpleComponentMonitor {
    private StatusMonitor mResourceMon;

    public SimpleMonitor(Component comp, boolean subComp, ExportContext expCtx, Context parentContext, String declName, InstallMode declMode, ComponentExporter exp, SystemDataImpl sysData, AccessControlContext acCtx, boolean isCheckInCurrent) throws PersistenceManagerException, RPCException {
        super(comp, subComp, expCtx, parentContext, declName, declMode, exp, sysData, acCtx, isCheckInCurrent);
    }

    protected CompStatus getJobStatus() {
        CompStatus cs = new CompComplete(System.currentTimeMillis(), this.getComponent());
        if (this.mResourceMon != null && (cs = CompStatus.mapResourceStatus(this.mResourceMon.getStatus(), System.currentTimeMillis(), this.getComponent())) == null) {
            return new CompError(System.currentTimeMillis(), CompExportException.invalidResourceStatus());
        }
        if (cs instanceof CompComplete && !this.getCompBuilt()) {
            return new CompPending();
        }
        return cs;
    }

    protected void saveJob() throws PersistenceManagerException, RPCException, CompExportException {
        Component comp = this.getComponent();
        if (!(this.getJobStatus() instanceof CompComplete) || this.mResourceMon == null) {
            throw CompExportException.resourceNotSaved(this.getComponent());
        }
        RsrcInfo rsrcInfo = ((Succeeded)this.mResourceMon.getStatus()).getRsrcInfo();
        comp.setLocalResource(rsrcInfo);
        comp.save(this.getCompSaveContext());
    }

    protected void cancelJob() throws PersistenceManagerException, RPCException {
        if (this.mResourceMon != null) {
            this.mResourceMon.cancel();
            try {
                if (this.getJobStatus() instanceof CompComplete) {
                    ((Succeeded)this.mResourceMon.getStatus()).getRsrcInfo().getObjectID().delete();
                }
            }
            catch (ObjectNotDeletedQueryException objectNotDeletedQueryException) {
                // empty catch block
            }
        }
    }

    public String createRemoteTempFile() throws ComponentExportException {
        try {
            this.externalTestFlow();
            String tempFileName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException {
                    return SimpleMonitor.this.wrappedCreateRemoteTempFile();
                }
            }, this.getAccessControlContext());
            this.externalTestFlow();
            return tempFileName;
        }
        catch (RaplixException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e.getException());
        }
    }

    private String wrappedCreateRemoteTempFile() throws RaplixException {
        if (this.getHostID() == null) {
            throw CompExportException.cannotCreateRemoteFileWithoutHost();
        }
        Host checkinHost = this.getHostID().getPhysicalHost().getID().getByIDQuery().select();
        RoxAddress raAddr = checkinHost.getRARoxAddress();
        FileOperationsInterface fileOps = (FileOperationsInterface)Server.getApp().getRPCInterface(raAddr, FileOperationsInterface.class);
        return fileOps.createTempFile("cem", null);
    }

    public void exportResource(final String exportControlName, final String exportServiceName, final VariableSettingsSource args) throws ComponentExportException {
        try {
            this.externalTestFlow();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException, InterruptedException {
                    SimpleMonitor.this.wrappedExportResource(exportControlName, exportServiceName, args);
                    return null;
                }
            }, this.getAccessControlContext());
            this.externalTestFlow();
        }
        catch (RaplixException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e.getException());
        }
    }

    private void wrappedExportResource(String exportControlName, String exportServiceName, VariableSettingsSource args) throws RaplixException, InterruptedException {
        if (this.getHostID() == null) {
            throw CompExportException.cannotExportResourceWithoutHost();
        }
        ArgList argList = new ArgList(args);
        argList.escapeVarValues();
        final HostID physicalHostID = this.getHostID().getPhysicalHost().getID();
        final ExecStep[] steps = new ExecStep[]{new CallStep(exportControlName, new SystemServiceTargeter(exportServiceName), argList)};
        SystemService service = new SystemService(exportServiceName);
        FolderPermission execPerm = FolderPermission.createExecutePermission(service.getComponent().getPath(), physicalHostID);
        Permissions execPerms = new Permissions();
        execPerms.add(execPerm);
        final Application app = Server.getApp();
        AccessControlContext privExecCtx = app.getUserDBSubsystem().getAccessControlManager().addToCurrent(execPerms);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException, InterruptedException {
                    app.getPlanSubsystem().execNonPlanSteps(steps, physicalHostID, SimpleMonitor.this, null, null);
                    return null;
                }
            }, privExecCtx);
        }
        catch (PrivilegedActionException e) {
            Exception nested = e.getException();
            if (nested instanceof InterruptedException) {
                throw (InterruptedException)nested;
            }
            if (nested instanceof RaplixException) {
                throw (RaplixException)nested;
            }
            throw new RaplixException(nested);
        }
    }

    public void setResource(ResourceType type, String location, boolean diff, boolean config, boolean followSymlinks, boolean captureUser, boolean captureGroup, com.sun.n1.sps.resource.CheckInMode checkinMode, ResourceProcessor rsrcProc) throws ComponentExportException {
        this.setResource(type, location, diff, config, followSymlinks, captureUser, captureGroup, checkinMode, rsrcProc, null);
    }

    public void setResource(final ResourceType type, final String location, final boolean diff, final boolean config, final boolean followSymlinks, final boolean captureUser, final boolean captureGroup, final com.sun.n1.sps.resource.CheckInMode checkinMode, final ResourceProcessor rsrcProc, final String descriptorPath) throws ComponentExportException {
        try {
            this.externalTestFlow();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException, InterruptedException {
                    SimpleMonitor.this.wrappedSetResource(type, location, diff, config, followSymlinks, captureUser, captureGroup, checkinMode, rsrcProc, descriptorPath);
                    return null;
                }
            }, this.getAccessControlContext());
            this.externalTestFlow();
        }
        catch (RaplixException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e.getException());
        }
    }

    private void wrappedSetResource(ResourceType type, String location, boolean diff, boolean config, boolean followSymlinks, boolean captureUser, boolean captureGroup, com.sun.n1.sps.resource.CheckInMode ciMode, final ResourceProcessor rsrcProc, String descriptorPath) throws RaplixException, InterruptedException {
        ConfigTemplate rsrcContent;
        HostID physicalHostID = this.getHostID() == null ? null : this.getHostID().getPhysicalHost().getID();
        String rsrcType = null;
        if (type != null) {
            if (ResourceType.FILE.equals(type)) {
                rsrcType = RsrcInfo.getFileTypeName();
            } else if (ResourceType.DIRECTORY.equals(type)) {
                rsrcType = RsrcInfo.getDirTypeName();
            }
        }
        if (rsrcType == null) {
            CompExportException.resourceTypeUnspecified(this.getComponentName());
        }
        PosixPermOptions permOptions = new PosixPermOptions(captureUser, captureGroup);
        if (descriptorPath != null) {
            permOptions.setResourceDescriptorPath(descriptorPath);
        }
        ResourceTypeAndOptions typeAndOptions = ResourceTypeAndOptions.makeCheckIn(rsrcType, location, physicalHostID, (PermOptions)permOptions, (CheckInMode)ciMode);
        ResourceSpec spec = new ResourceSpec(this.getComponent().getFullName());
        RedundancyCheckMode redunCheckMode = diff ? RedundancyCheckMode.DELTA_ONLY : RedundancyCheckMode.NO_REDUNDANCY_CHECK;
        this.internalTestFlow();
        this.mResourceMon = Server.getApp().getResourceSubsystem().beginCheckIn(typeAndOptions, null, config, spec, redunCheckMode, new VersionedSaveContext(), this.getPlatform(), followSymlinks);
        while (this.mResourceMon.getStatus() instanceof InProgress) {
            Thread.sleep(3000L);
            this.internalTestFlow();
        }
        CheckInStatus status = this.mResourceMon.getStatus();
        if (status instanceof Failed) {
            throw ((Failed)status).getException();
        }
        if (status instanceof Cancelled) {
            return;
        }
        final RsrcInfo rsrc = ((Succeeded)status).getRsrcInfo();
        if (config && (rsrcContent = SimpleMonitor.getConfigTemplate(rsrc)) != null) {
            Component comp = this.getComponent();
            HashSet vars = rsrcContent.getSimpleVarNames();
            Iterator iter = vars.iterator();
            while (iter.hasNext()) {
                String varName = (String)iter.next();
                if (comp.resolveVar(varName, null) != null || ComponentConfigManager.isPredefName(varName)) continue;
                comp.addLocalVar(new VarDecl(varName, ":[container:" + varName + "]"));
            }
        }
        this.internalTestFlow();
        if (rsrcProc != null) {
            new ResourceAccessor(Server.getApp().getResourceSubsystem()){

                public Object innerAccess() throws ResourceException {
                    SDKResourceManifest manifest = new SDKResourceManifest(this.getManifest(rsrc.getResourceID(), null));
                    try {
                        rsrcProc.processResource(manifest);
                    }
                    catch (ComponentExportException e) {
                        throw new ResourceException(e);
                    }
                    return null;
                }
            }.access();
        }
    }

    private static ConfigTemplate getConfigTemplate(final RsrcInfo rsrcInfo) throws ResourceException {
        return (ConfigTemplate)new ResourceAccessor(((Server)Server.getApp()).getResourceSubsystem()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object innerAccess() throws ResourceException {
                RsrcManifest manifest = this.getManifest(rsrcInfo.getResourceID(), null);
                InputStream istream = manifest.getInputStream(manifest.getEntryIterator().next());
                try {
                    UnicodeInputStreamReader reader = new UnicodeInputStreamReader(istream);
                    ConfigTemplate configTemplate = new ConfigParser().createTemplate(reader);
                    return configTemplate;
                }
                catch (ConfigGenException e) {
                    Object var4_6 = null;
                    return var4_6;
                }
                finally {
                    try {
                        istream.close();
                    }
                    catch (IOException e) {
                        throw new ResourceException(e);
                    }
                }
            }
        }.access();
    }
}

