/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import [Lcom.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInMonitor;
import com.raplix.rolloutexpress.hierarchies.compexport.CompExportException;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentTokenImpl;
import com.raplix.rolloutexpress.hierarchies.compexport.ExportContext;
import com.raplix.rolloutexpress.hierarchies.compexport.SystemDataImpl;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Mapper;
import com.raplix.util.collections.MapperBase;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Context;
import com.sun.n1.sps.componentdb.InstallMode;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.ComponentExporter;
import com.sun.n1.sps.plugin.export.ComponentToken;
import com.sun.n1.sps.plugin.export.CompositeComponentMonitor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Vector;

class CompositeMonitor
extends CompCheckInMonitor
implements CompositeComponentMonitor {
    private Vector mMonitorList;
    private Vector mDeclList;
    private Mapper DECL_MAPPER = new MapperBase(){

        public Object map(Object element) {
            if (element instanceof DeclDef) {
                return ((DeclDef)element).getDecl();
            }
            CompCheckInMonitor mon = (CompCheckInMonitor)element;
            Component c = mon.getComponent();
            return new ComponentRefDecl(Modifier.NONE, mon.getDeclName(), (com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode)mon.getDeclInstallMode(), c.getExtendsType(), null, c);
        }
    };

    public CompositeMonitor(Component comp, boolean subComp, ExportContext expCxt, Context parentContext, String declName, InstallMode declMode, ComponentExporter exp, SystemDataImpl sysData, AccessControlContext acCtx, boolean isCheckInCurrent) throws PersistenceManagerException, RPCException {
        super(comp, subComp, expCxt, parentContext, declName, declMode, exp, sysData, acCtx, isCheckInCurrent);
        this.mMonitorList = new Vector();
        this.mDeclList = new Vector();
    }

    public ComponentToken constructContainedComponent(final String type, final ComponentExporter exporter, final String suffix, final String declName, final InstallMode declMode, final boolean hidden) throws ComponentExportException {
        try {
            this.externalTestFlow();
            ComponentToken compToken = (ComponentToken)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RaplixException, ComponentExportException {
                    return CompositeMonitor.this.wrappedConstructContainedComponent(type, exporter, suffix, declName, declMode, hidden);
                }
            }, this.getAccessControlContext());
            this.externalTestFlow();
            return compToken;
        }
        catch (ComponentExportException e) {
            throw e;
        }
        catch (RaplixException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
        catch (PrivilegedActionException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e.getException());
        }
    }

    private ComponentToken wrappedConstructContainedComponent(String type, ComponentExporter exporter, String suffix, String declName, InstallMode declMode, boolean hidden) throws PersistenceManagerException, RPCException, ComponentExportException, CompExportException, ConfigGenException {
        ComponentRefDecl resolvedDecl;
        Component myComp = this.getComponent();
        ComponentType nestedType = ComponentType.create(type);
        String nestedName = myComp.getName() + suffix;
        Component nestedComp = this.getNestedComp(myComp.getPath(), nestedName, nestedType, hidden);
        ExportContext nestedContext = this.getContextClone();
        nestedContext.setComponentSaveContext(this.getNestedSaveContext(nestedComp, this.getCompSaveContext()));
        SystemDataImpl modSD = this.getSystemDataImpl().updateCT(type, this.getAccessControlContext());
        CompCheckInMonitor nestedMon = CompCheckInMonitor.generateMonitor(nestedComp, true, nestedContext, this, declName, declMode, exporter, modSD, this.getAccessControlContext(), this.isCheckInCurrent());
        this.addMonitor(nestedMon);
        this.mDeclList.add(nestedMon);
        nestedMon.setup();
        if (nestedContext.getComponentSaveContext().getHideLatest() && (resolvedDecl = myComp.resolveCompRef(declName, null)) != null && resolvedDecl.getComponent() != null && resolvedDecl.getComponent().getID().equals(nestedComp.getID()) && resolvedDecl.getDeclaringComponent() == myComp) {
            myComp.setUpdateCount(myComp.getUpdateCount() + 1);
        }
        return new ComponentTokenImpl(nestedComp);
    }

    public void addContainedComponent(ComponentToken compToken, String declName, InstallMode declMode) throws ComponentExportException {
        this.externalTestFlow();
        if (compToken == null || !(compToken instanceof ComponentTokenImpl)) {
            throw new ComponentExportException(SDK_MSG, (Throwable)CompExportException.invalidComponentToken(compToken));
        }
        ComponentRefDecl decl = new ComponentRefDecl(Modifier.NONE, declName, (com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode)declMode, null, null, null);
        this.mDeclList.add(new DeclDef(decl, ((ComponentTokenImpl)compToken).getComponent()));
    }

    protected CompStatus getJobStatus() {
        CompStatus returnStatus = null;
        Iterator iter = this.mMonitorList.iterator();
        while (iter.hasNext()) {
            CompStatus stat = ((CompCheckInMonitor)iter.next()).getJobStatus();
            if (stat instanceof CompError) {
                return stat;
            }
            if (!(stat instanceof CompPending)) continue;
            returnStatus = stat;
        }
        if (!this.getCompBuilt()) {
            return new CompPending();
        }
        if (returnStatus == null) {
            returnStatus = new CompComplete(System.currentTimeMillis(), this.getComponent());
        }
        return returnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveJob() throws PersistenceManagerException, RPCException, CompExportException {
        Vector vector = this.mMonitorList;
        synchronized (vector) {
            ComponentRefDecl[] compList;
            Iterator iter = this.mMonitorList.iterator();
            while (iter.hasNext()) {
                CompCheckInMonitor mon = (CompCheckInMonitor)iter.next();
                mon.save();
            }
            try {
                compList = (ComponentRefDecl[])CollectionUtil.mapClass(this.mDeclList, ComponentRefDecl;.class, this.DECL_MAPPER);
            }
            catch (Exception e) {
                throw CompExportException.failedToBuildComp(e);
            }
            this.getComponent().setLocalCompRefList(compList);
            this.getComponent().save(this.getCompSaveContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelJob() throws PersistenceManagerException, RPCException {
        Vector vector = this.mMonitorList;
        synchronized (vector) {
            Iterator iter = this.mMonitorList.iterator();
            while (iter.hasNext()) {
                CompCheckInMonitor mon = (CompCheckInMonitor)iter.next();
                try {
                    mon.cancelJob();
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error("Cancel failed for monitor of component " + mon.getComponentName(), e, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMonitor(CompCheckInMonitor monitor) {
        Vector vector = this.mMonitorList;
        synchronized (vector) {
            this.mMonitorList.add(monitor);
        }
    }

    private Component getNestedComp(FolderID path, String name, ComponentType compType, boolean hidden) throws RPCException, PersistenceManagerException {
        Component comp;
        SingleComponentQuery query = SingleComponentQuery.byName(path, name, null);
        if (query.selectExists()) {
            comp = query.select();
        } else {
            comp = new Component();
            comp.setExtendsType(compType);
            comp.setName(name);
            comp.setPath(path);
            comp.setLocalCompRefListType(comp.getCompRefListType());
        }
        if (hidden) {
            comp.setVisibility(Visibility.HIDDEN);
        }
        return comp;
    }

    private ComponentSaveContext getNestedSaveContext(Component comp, ComponentSaveContext parentCtx) {
        ComponentSaveContext context = new ComponentSaveContext();
        if (comp.getID() == null) {
            return context;
        }
        context.setLatestVersion(comp);
        context.setSaveAsNewMajor(parentCtx.getSaveAsNewMajor());
        context.setHideLatest(parentCtx.getHideLatest());
        return context;
    }

    private static class DeclDef {
        ComponentRefDecl mDecl;
        Component mComp;

        public DeclDef(ComponentRefDecl decl, Component comp) {
            this.mDecl = decl;
            this.mComp = comp;
        }

        public ComponentRefDecl getDecl() {
            return new ComponentRefDecl(this.mDecl.getModifier(), this.mDecl.getName(), this.mDecl.getInstallMode(), this.mComp.getExtendsType(), this.mDecl.getOverrideArgs(), this.mComp);
        }
    }
}

