/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserSubsystem;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInMonitor;
import com.raplix.rolloutexpress.hierarchies.compexport.CompExportException;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentExportServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ExportContext;
import com.raplix.rolloutexpress.hierarchies.compexport.ExporterLoader;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.SystemDataImpl;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.plugin.ExecJavaExecutor;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.Util;
import com.raplix.util.filecache.FileCache;
import com.raplix.util.logger.Logger;
import com.raplix.util.reflect.ConstructorUtil;
import com.raplix.util.string.StringUtil;
import com.raplix.util.threads.Context;
import com.sun.n1.sps.componentdb.InstallMode;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.ComponentExporter;
import com.sun.n1.sps.plugin.export.SystemData;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.LinkedList;

class ComponentExportManager
implements ComponentExportServices,
ExporterLoader {
    private static final Context COMP_EXPORT_THREAD_CONTEXT = new Context("compExportThreadContext");
    private static ComponentExportManager sInstance;

    private ComponentExportManager() {
        HierarchyBrowserSubsystem.registerExporterLoader(this);
    }

    public static ComponentExportManager getInstance() {
        if (sInstance == null) {
            sInstance = new ComponentExportManager();
        }
        return sInstance;
    }

    public BrowserInfo[] getAvailableBrowsers(String componentTypeName) throws RPCException, CompExportException {
        ComponentExporter exporter = this.loadExporter(componentTypeName);
        if (exporter == null) {
            return null;
        }
        return this.getAvailableBrowsers(componentTypeName, exporter);
    }

    private BrowserInfo[] getAvailableBrowsers(String compTypeName, ComponentExporter exporter) throws RPCException, CompExportException {
        try {
            BrowserInfo[] browserList = exporter.getAvailableBrowsers(this.getSystemData((BrowserInfo)null, compTypeName, null, null));
            return browserList == null ? new BrowserInfo[]{} : browserList;
        }
        catch (ConfigGenException e) {
            throw CompExportException.failedToGetBrowserList(compTypeName, e);
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToGetBrowserList(compTypeName, e);
        }
        catch (ComponentExportException e) {
            throw CompExportException.failedToGetBrowserList(compTypeName, e);
        }
    }

    public CompCheckInID checkIn(String componentTypeName, String browserType, FolderID componentFolder, String componentName, ExportContext passedContext) throws RPCException, CompExportException {
        this.checkPermissions(componentFolder, "write");
        ComponentExporter compExporter = this.loadExporter(componentTypeName);
        if (compExporter == null) {
            throw CompExportException.failedToLoadExporter(componentTypeName, null);
        }
        ExportContext context = passedContext.getDataClone();
        if (context.getSourceInfo() == null) {
            context.setSourceInfo(new SourceInfo(null, null, null, null));
        }
        context.getSourceInfo().setBrowserType(browserType);
        try {
            String expectedPlatformName = ComponentType.create(componentTypeName).getComponent().getPlatform();
            HostSetID expectedPlatform = expectedPlatformName == null ? null : SingleHostSetQuery.byName(expectedPlatformName).selectSummaryView().getID();
            HostSetID passedPlatform = context.getPlatform();
            if (expectedPlatform != null && !expectedPlatform.equals(SystemPluginConstants.getInstance().ALL_PLATFORMS_ID) && !expectedPlatform.isDescendant(passedPlatform)) {
                String passedPlatformName = passedPlatform == null ? "" : passedPlatform.getByIDQuery().selectSummaryView().getName();
                throw CompExportException.platformNotCompatbile(passedPlatformName, expectedPlatformName);
            }
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToLoadExporter(componentTypeName, e);
        }
        SummaryComponent previousComp = null;
        try {
            previousComp = SingleComponentQuery.byName(componentFolder, componentName, null).selectSummaryView();
            ComponentSaveContext csCtx = context.getComponentSaveContext();
            if (csCtx == null) {
                csCtx = new ComponentSaveContext();
                csCtx.setLatestVersion(previousComp);
                context.setComponentSaveContext(csCtx);
            } else if (csCtx.getLatestVersion() == null) {
                throw CompExportException.existingComponent();
            }
            csCtx.setImportSettings(true);
        }
        catch (NoResultsFoundException noResults) {
            previousComp = null;
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        SystemDataImpl sysData = null;
        try {
            sysData = this.getSystemData(compExporter, componentTypeName, browserType, context.getSourceInfo().getHost());
        }
        catch (ConfigGenException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        CompCheckInMonitor checkinMonitor = null;
        checkinMonitor = previousComp == null ? this.exportNew(componentTypeName, componentName, componentFolder, context, compExporter, sysData) : this.exportNewVersion(previousComp.getID(), context, compExporter, sysData, false);
        return checkinMonitor.getCheckInID();
    }

    public CompCheckInID checkInCurrent(ComponentID componentID) throws RPCException, CompExportException {
        Component previousComp = null;
        try {
            previousComp = componentID.getByIDQuery().select();
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        this.checkPermissions(previousComp.getPath(), "checkin");
        String compTypeName = previousComp.getExtendsTypeName();
        ComponentExporter compExporter = this.loadExporter(compTypeName);
        if (compExporter == null) {
            throw CompExportException.failedToLoadExporter(compTypeName, null);
        }
        SourceInfo si = previousComp.getSourceInfo();
        if (!SourceInfo.containsCheckinCurrentData(si)) {
            throw CompExportException.cannotCheckedInCurrent(previousComp.getFullName());
        }
        ExportContext context = new ExportContext();
        SummaryComponent latest = null;
        try {
            latest = SingleComponentQuery.byName(previousComp.getPath(), previousComp.getName(), null).selectSummaryView();
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        ComponentSaveContext compSaveContext = new ComponentSaveContext();
        compSaveContext.setLatestVersion(latest.getVersionNumber());
        compSaveContext.setImportSettings(true);
        compSaveContext.setSaveAsNewMajor(false);
        compSaveContext.setHideLatest(true);
        context.setComponentSaveContext(compSaveContext);
        context.setSourceInfo(si.getDataClone());
        try {
            context.setPlatform(SingleHostSetQuery.byName(previousComp.getPlatform()).selectSummaryView().getID());
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        context.setLabel(previousComp.getLabel());
        context.setDescription(previousComp.getDescription());
        SystemDataImpl sysData = null;
        try {
            sysData = this.getSystemData(compExporter, compTypeName, si.getBrowserType(), si.getHost());
        }
        catch (ConfigGenException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        CompCheckInMonitor checkinMonitor = this.exportNewVersion(componentID, context, compExporter, sysData, true);
        return checkinMonitor.getCheckInID();
    }

    private void checkPermissions(FolderID folderID, String action) throws CompExportException, RPCException {
        SummaryFolder folder;
        try {
            folder = folderID.getByIDQuery().selectSummaryView();
        }
        catch (PersistenceManagerException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        Plugin.checkWritePermissions(folder);
        FolderPermission perm = new FolderPermission(folderID, action);
        AccessController.checkPermission(perm);
    }

    public ComponentExporter loadExporter(String compTypeName) throws CompExportException {
        try {
            ComponentType compType = ComponentType.create(compTypeName);
            if (StringUtil.isEmpty(compType.getExporterClassName())) {
                return null;
            }
            PluginID pluginID = compType.getComponentTypeRef().getPluginID();
            String dir = Server.getApp().getDataDirAbsPath() + "/";
            LinkedList<String> loadPathList = new LinkedList<String>();
            if (pluginID != null) {
                Plugin plugin = pluginID.getByIDQuery().select();
                String pluginPath = plugin.getServerPluginJARPath();
                if (pluginPath != null) {
                    loadPathList.add(ResourceStringUtils.toNativePath(dir + pluginPath));
                }
                Plugin[] dependents = plugin.getDependencies().getByIDsQuery().select();
                for (int i = 0; i < dependents.length; ++i) {
                    pluginPath = dependents[i].getServerPluginJARPath();
                    if (pluginPath == null) continue;
                    loadPathList.add(ResourceStringUtils.toNativePath(dir + pluginPath));
                }
            }
            ComponentType extendsCompType = compType;
            Component comp = null;
            while (!(extendsCompType = (comp = SingleComponentQuery.byRef(extendsCompType.getComponentTypeRef().getComponentRef()).select()).getExtendsType()).isRoot()) {
                String pluginPath;
                pluginID = extendsCompType.getComponentTypeRef().getPluginID();
                if (pluginID == null || (pluginPath = pluginID.getByIDQuery().select().getServerPluginJARPath()) == null) continue;
                loadPathList.add(ResourceStringUtils.toNativePath(dir + pluginPath));
            }
            String loadPath = Util.getStringFromArray(loadPathList.toArray(new String[0]), ";");
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("loading exporter from cp:" + loadPath, this);
            }
            FileCache fileCache = ((Server)Server.getApp()).getFileCache();
            Class exporterClass = ExecJavaExecutor.loadClass(loadPath, compType.getExporterClassName(), true, fileCache);
            Constructor con = ConstructorUtil.findConstructor(exporterClass);
            return (ComponentExporter)ConstructorUtil.createObject(con);
        }
        catch (Exception e) {
            throw CompExportException.failedToLoadExporter(compTypeName, e);
        }
    }

    public SystemData getSystemData(BrowserInfo browser, HostID hostID) throws ConfigGenException, PersistenceManagerException, RPCException {
        return this.getSystemData(browser, browser.getComponentType(), browser.getServiceName(), hostID);
    }

    private SystemDataImpl getSystemData(BrowserInfo browser, String compType, String serviceName, HostID hostID) throws ConfigGenException, PersistenceManagerException, RPCException {
        return new SystemDataImpl(browser, compType, serviceName, hostID, AccessController.getContext());
    }

    private SystemDataImpl getSystemData(ComponentExporter exporter, String compType, String browserType, HostID hostID) throws CompExportException, ConfigGenException, PersistenceManagerException, RPCException {
        BrowserInfo[] browserList = this.getAvailableBrowsers(compType, exporter);
        BrowserInfo activeBrowser = null;
        if (!StringUtil.isEmpty(browserType)) {
            for (int i = 0; i < browserList.length; ++i) {
                if (!browserList[i].getBrowserType().equals(browserType)) continue;
                activeBrowser = browserList[i];
                break;
            }
            if (activeBrowser == null) {
                throw CompExportException.invalidBrowserTypeName(browserType, compType);
            }
        } else {
            if (browserList.length > 1) {
                throw CompExportException.compExportRequiresABrowserType(compType);
            }
            if (browserList.length > 0) {
                activeBrowser = browserList[0];
            }
        }
        String serviceName = activeBrowser != null ? activeBrowser.getServiceName() : null;
        return this.getSystemData(activeBrowser, compType, serviceName, hostID);
    }

    private CompCheckInMonitor exportNew(String compTypeName, String compName, FolderID folderID, ExportContext context, ComponentExporter exporter, SystemDataImpl sysData) throws CompExportException {
        try {
            Component comp = new Component();
            comp.setExtendsType(ComponentType.create(compTypeName));
            comp.setName(compName);
            comp.setPath(folderID);
            comp.setLocalCompRefListType(comp.getCompRefListType());
            comp.setPlatform(context.getPlatform() == null ? null : context.getPlatform().getByIDQuery().selectSummaryView().getName());
            CompCheckInMonitor mon = CompCheckInMonitor.generateMonitor(comp, false, context.getDataClone(), COMP_EXPORT_THREAD_CONTEXT, null, InstallMode.TOPLEVEL, exporter, sysData, AccessController.getContext(), false);
            this.launchMonitorThread(mon);
            return mon;
        }
        catch (CompExportException ce) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("exportNew Stack Trace:", ce, this);
            }
            throw ce;
        }
        catch (RaplixException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("exportNew Stack Trace:", e, this);
            }
            throw CompExportException.failedToBuildComp(e);
        }
    }

    private CompCheckInMonitor exportNewVersion(ComponentID compID, ExportContext context, ComponentExporter exporter, SystemDataImpl sysData, boolean isCheckInCurrent) throws CompExportException {
        try {
            Component comp = compID.getByIDQuery().select();
            HostSetID contextPlatform = context.getPlatform();
            if (contextPlatform != null) {
                String passedPlatformName = context.getPlatform().getByIDQuery().selectSummaryView().getName();
                comp.setPlatform(passedPlatformName);
            }
            CompCheckInMonitor mon = CompCheckInMonitor.generateMonitor(comp, false, context.getDataClone(), COMP_EXPORT_THREAD_CONTEXT, null, InstallMode.TOPLEVEL, exporter, sysData, AccessController.getContext(), isCheckInCurrent);
            this.launchMonitorThread(mon);
            return mon;
        }
        catch (CompExportException ce) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("exportNewVersion Stack Trace:", ce, this);
            }
            throw ce;
        }
        catch (RaplixException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("exportNewVersion Stack Trace:", e, this);
            }
            throw CompExportException.failedToBuildComp(e);
        }
    }

    private void launchMonitorThread(CompCheckInMonitor mon) throws CompExportException {
        try {
            HierarchyBrowserSubsystem.getInstance().startSubsystemTask(mon);
        }
        catch (RaplixException e) {
            throw CompExportException.failedToBuildComp(e);
        }
    }
}

