/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.hierarchies.compexport.Messages;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.resource.checkInJob.checkInStatus.CheckInStatus;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.util.logger.Logger;
import com.sun.n1.sps.plugin.export.ComponentToken;

public class CompExportException
extends CommandException
implements Messages {
    private boolean mNestedInterrupted = false;

    protected CompExportException() {
    }

    protected CompExportException(ROXMessage msg) {
        super(msg);
    }

    protected CompExportException(Throwable t) {
        super(t);
        this.checkInterrupted(t);
    }

    protected CompExportException(ROXMessage msg, Throwable t) {
        super(msg, t, 1);
        this.checkInterrupted(t);
    }

    public boolean getIsInterrupted() {
        return super.getIsInterrupted() || this.mNestedInterrupted;
    }

    private void checkInterrupted(Throwable t) {
        Throwable nested;
        Throwable throwable = nested = t == null ? null : t.getCause();
        if (nested != null && CompExportException.isInterruptedException(nested)) {
            this.mNestedInterrupted = true;
        }
    }

    static CompExportException resourceNotSaved(Component comp) {
        ROXMessage msg = new ROXMessage("compexport.RESOURCE_NOT_SAVED", new Object[]{comp.getName()});
        return new CompExportException(msg);
    }

    static CompExportException failedToLoadExporter(String compType, Exception e) {
        ROXMessage msg = new ROXMessage("compexport.FAILED_TO_LOAD_EXPORTER", new Object[]{compType});
        return new CompExportException(msg, (Throwable)e);
    }

    static CompExportException compExists(String name, Folder folder) {
        ROXMessage msg = new ROXMessage("compexport.COMP_EXISTS", new Object[]{name, folder.getName()});
        return new CompExportException(msg);
    }

    static CompExportException unknownStatus(CheckInStatus status) {
        ROXMessage msg = new ROXMessage("compexport.UNKNOWN_STATUS", new Object[]{status});
        return new CompExportException(msg);
    }

    static CompExportException failedToBuildComp(Exception e) {
        if (Logger.isDebugEnabled(CompExportException.class)) {
            Logger.debug("failedToBuildComp", e, CompExportException.class);
        }
        ROXMessage msg = new ROXMessage("compexport.FAILED_TO_BUILD_COMP");
        return new CompExportException(msg, (Throwable)e);
    }

    static CompExportException noSuchCompType(String name, Exception e) {
        ROXMessage msg = new ROXMessage("compexport.FAILED_TO_BUILD_COMP", new Object[]{name});
        return new CompExportException(msg, (Throwable)e);
    }

    static CompExportException invalidBrowserTypeName(String browserName, String compType) {
        ROXMessage msg = new ROXMessage("compexport.INVALID_BROWSER_TYPE_NAME", new Object[]{browserName, compType});
        return new CompExportException(msg);
    }

    static CompExportException compExportRequiresABrowserType(String compType) {
        ROXMessage msg = new ROXMessage("compexport.COMP_EXPORT_REQUIRES_A_BROWSER_TYPE", new Object[]{compType});
        return new CompExportException(msg);
    }

    static CompExportException cannotCheckedInCurrent(String componentName) {
        ROXMessage msg = new ROXMessage("compexport.COMP_CANNOT_CHECK_IN_CURRENT", new Object[]{componentName});
        return new CompExportException(msg);
    }

    static CompExportException platformNotCompatbile(String passedPlaform, String expectedPlatform) {
        ROXMessage msg = new ROXMessage("compexport.PLATFORM_NOT_COMPATIBLE", new Object[]{passedPlaform, expectedPlatform});
        return new CompExportException(msg);
    }

    static CompExportException hostDoesNotHaveRequiredSystemService(String serviceName) {
        ROXMessage msg = new ROXMessage("compexport.HOST_DOES_NOT_HAVE_REQUIRED_SYSTEM_SERVICE", new Object[]{serviceName});
        return new CompExportException(msg);
    }

    static CompExportException dynamicExportRequiresHostID(String inTypeName) {
        ROXMessage msg = new ROXMessage("compexport.DYNAMIC_EXPORT_REQUIRES_HOSTID", new Object[]{inTypeName});
        return new CompExportException(msg);
    }

    static CompExportException invalidResourceStatus() {
        ROXMessage msg = new ROXMessage("compexport.INVALID_RESOURCE_STATUS");
        return new CompExportException(msg);
    }

    static CompExportException cannotCreateRemoteFileWithoutHost() {
        ROXMessage msg = new ROXMessage("compexport.CREATE_REMOTE_FILE_NO_HOST");
        return new CompExportException(msg);
    }

    static CompExportException cannotExportResourceWithoutHost() {
        ROXMessage msg = new ROXMessage("compexport.EXPORT_RESOURCE_NO_HOST");
        return new CompExportException(msg);
    }

    static CompExportException resourceTypeUnspecified(String compName) {
        ROXMessage msg = new ROXMessage("compexport.NO_RESOURCE_TYPE", new Object[]{compName});
        return new CompExportException(msg);
    }

    static CompExportException failedToGetBrowserList(String compTypeName, Exception e) {
        ROXMessage msg = new ROXMessage("compexport.FAILED_TO_GET_BROWSERS", new Object[]{compTypeName});
        return new CompExportException(msg, (Throwable)e);
    }

    static CompExportException invalidComponentToken(ComponentToken token) {
        Class<?> tokenClass = token == null ? null : token.getClass();
        ROXMessage msg = new ROXMessage("compexport.INVALID_COMP_TOKEN", new Object[]{tokenClass});
        return new CompExportException(msg);
    }

    static CompExportException existingComponent() {
        return new CompExportException(new ROXMessage("compexport.EXISTING_COMPONENT"));
    }
}

