/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserSubsystem;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInManager;
import com.raplix.rolloutexpress.hierarchies.compexport.CompExportException;
import com.raplix.rolloutexpress.hierarchies.compexport.CompositeMonitor;
import com.raplix.rolloutexpress.hierarchies.compexport.ExportContext;
import com.raplix.rolloutexpress.hierarchies.compexport.Messages;
import com.raplix.rolloutexpress.hierarchies.compexport.SimpleMonitor;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.SystemDataImpl;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCancelled;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.userdb.AccessControlManager;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.rwlock.RWLock;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.RunnableContext;
import com.sun.n1.sps.componentdb.InstallMode;
import com.sun.n1.sps.plugin.PluginMessage;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.ComponentExporter;
import com.sun.n1.sps.plugin.export.ComponentMonitor;
import com.sun.n1.sps.plugin.export.SystemData;
import com.sun.n1.util.vars.VariableSettingsSource;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

abstract class CompCheckInMonitor
extends RunnableContext
implements ComponentMonitor,
Messages {
    protected static final PluginMessage SDK_MSG = new PluginMessage("compexport.INFRASTRUCTURE_ERROR"){

        public String getMessageValue(Locale inLocale) {
            return MessageManager.messageAsString(this.getKey(), inLocale);
        }
    };
    private static final int SLEEP_PERIOD = 1000;
    private static final char FACET_VALID_CHAR = '_';
    private InstallMode mDeclInstallMode;
    private String mDeclName;
    private Component mComponent;
    private String mComponentName;
    private String mComponentType;
    private String mSourceHostName;
    private boolean mSubComp;
    private CompCheckInID mCheckInID;
    private ExportContext mExportContext;
    private CompStatus mFinalStatus = new CompPending();
    private boolean mCompBuilt = false;
    private ComponentExporter mExporter = null;
    private SystemDataImpl mSystemData;
    private AccessControlContext mAccessControlContext;
    private boolean mCheckInCurrent;
    private final AcquireReadLockTransaction SAVE_TRANSACTION = new AcquireReadLockTransaction(){

        public Object execute() throws PersistenceManagerException {
            try {
                CompCheckInMonitor.this.saveWithPerms();
            }
            catch (CompExportException cee) {
                throw new PersistenceManagerException(cee);
            }
            catch (RPCException rpc) {
                throw new PersistenceManagerException(rpc);
            }
            return null;
        }

        public ROXMessage getLockDescription() {
            return new ROXMessage("cdb.SAVING_COMPONENT", CompCheckInMonitor.this.mComponent.getFullName());
        }
    };

    public CompCheckInMonitor(Component comp, boolean subComp, ExportContext expCtx, Context parentContext, String declName, InstallMode declInstallMode, ComponentExporter exp, SystemDataImpl sysData, AccessControlContext acCtx, boolean isCheckInCurrent) throws PersistenceManagerException, RPCException {
        super(CompCheckInID.generateCompCheckInID().toString(), parentContext);
        this.mExporter = exp;
        this.mComponent = comp;
        this.mSubComp = subComp;
        this.mExportContext = expCtx;
        this.mDeclName = declName;
        this.mDeclInstallMode = declInstallMode;
        this.mComponentName = comp.getFullName();
        this.mComponentType = comp.getExtendsTypeName();
        SourceInfo si = expCtx.getSourceInfo();
        if (si != null && si.getHost() != null) {
            this.setHostName(si.getHost().getPhysicalHost().getName());
        }
        this.mSystemData = sysData;
        if (!this.mSubComp) {
            this.mCheckInID = new CompCheckInID(this.getName());
            CompCheckInManager.getInstance().attach(this);
        }
        this.setComponentDescription(expCtx.getDescription());
        this.setComponentLabel(expCtx.getLabel());
        this.mComponent.setSourceInfo(expCtx.getSourceInfo());
        this.mAccessControlContext = acCtx;
        this.mCheckInCurrent = isCheckInCurrent;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getHostName() {
        return this.mSourceHostName;
    }

    protected void setHostName(String name) {
        this.mSourceHostName = name;
    }

    public InstallMode getDeclInstallMode() {
        return this.mDeclInstallMode;
    }

    public String getDeclName() {
        return this.mDeclName;
    }

    public CompCheckInID getCheckInID() {
        return this.mCheckInID;
    }

    public synchronized CompStatus getStatus() {
        return this.mFinalStatus;
    }

    public void release() throws Exception {
        if (!this.mSubComp) {
            HierarchyBrowserSubsystem.getInstance().subsystemTaskComplete(this.getName());
            Thread.interrupted();
            CompCheckInManager.getInstance().update(this.getCheckInID());
            if (!(this.getStatus() instanceof CompComplete)) {
                this.cancelJob();
            }
        }
        super.release();
    }

    public synchronized boolean cancel() throws PersistenceManagerException, RPCException {
        HierarchyBrowserSubsystem.checkTaskPermission(this.getTaskOwner());
        boolean weCancelled = this.setStatus(new CompCancelled(System.currentTimeMillis()));
        if (weCancelled) {
            HierarchyBrowserSubsystem.getInstance().stopSubsystemTask(this.getName());
        }
        return weCancelled;
    }

    protected AccessControlContext getAccessControlContext() {
        return this.mAccessControlContext;
    }

    protected boolean isCheckInCurrent() {
        return this.mCheckInCurrent;
    }

    protected abstract CompStatus getJobStatus();

    protected abstract void cancelJob() throws PersistenceManagerException, RPCException;

    protected abstract void saveJob() throws PersistenceManagerException, RPCException, CompExportException;

    static CompCheckInMonitor generateMonitor(Component comp, boolean subComp, ExportContext context, Context parent, String compRefName, InstallMode installMode, ComponentExporter exporter, SystemDataImpl sysData, AccessControlContext acCtx, boolean isCheckInCurrent) throws CompExportException {
        try {
            if (comp.isSimpleComponent()) {
                return new SimpleMonitor(comp, subComp, context, parent, compRefName, installMode, exporter, sysData, acCtx, isCheckInCurrent);
            }
            return new CompositeMonitor(comp, subComp, context, parent, compRefName, installMode, exporter, sysData, acCtx, isCheckInCurrent);
        }
        catch (RaplixException e) {
            throw CompExportException.failedToBuildComp(e);
        }
    }

    protected void safeRun() throws Exception {
        try {
            RWLock lock = PersistenceManager.getInstance().getSystemLockObject();
            LockContext lockContext = new LockContext(){

                public Object execute() throws Exception {
                    CompCheckInMonitor.this.doExportAndSave();
                    return null;
                }
            };
            lock.readLock(new ROXMessage("compexport.EXPORTING_COMPONENT", this.mComponent.getFullName()).getMessageString(), lockContext);
        }
        catch (Throwable t) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Exception during CompCheckin:", t, this);
            }
            this.setErrorStatus(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExportAndSave() throws Exception {
        this.setup();
        CompStatus stat = this.getJobStatus();
        while (stat instanceof CompPending) {
            this.testFlow();
            Thread.sleep(1000L);
            stat = this.getJobStatus();
        }
        CompCheckInMonitor compCheckInMonitor = this;
        synchronized (compCheckInMonitor) {
            this.testFlow();
            if (stat instanceof CompComplete) {
                try {
                    PersistenceManager.getInstance().getTransactionManager().transact(this.SAVE_TRANSACTION);
                }
                catch (Throwable t) {
                    this.setErrorStatus(t);
                }
                this.setStatus(new CompComplete(stat.getEndTime(), this.getComponent()));
            } else {
                this.setStatus(stat);
            }
        }
    }

    private void setErrorStatus(Throwable t) {
        if (t instanceof Exception) {
            this.setStatus(new CompError(System.currentTimeMillis(), (Exception)t));
        } else {
            this.setStatus(new CompError(System.currentTimeMillis(), new CompExportException(t)));
        }
    }

    private void saveWithPerms() throws PersistenceManagerException, RPCException, CompExportException {
        AccessControlManager acm;
        if (!this.mCheckInCurrent) {
            this.save();
            return;
        }
        try {
            acm = Server.getApp().getUserDBSubsystem().getAccessControlManager();
        }
        catch (UnsupportedSubsystemException e) {
            throw CompExportException.failedToBuildComp(e);
        }
        Permissions perms = new Permissions();
        perms.add(new FolderPermission(this.getComponent().getPath(), "write"));
        AccessControlContext acc = acm.addToCurrent(perms);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException, RPCException, CompExportException {
                    CompCheckInMonitor.this.save();
                    return null;
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            Exception nested = e.getException();
            if (nested instanceof PersistenceManagerException) {
                throw (PersistenceManagerException)nested;
            }
            if (nested instanceof RPCException) {
                throw (RPCException)nested;
            }
            if (nested instanceof CompExportException) {
                throw (CompExportException)nested;
            }
            throw CompExportException.failedToBuildComp(nested);
        }
    }

    protected synchronized void save() throws PersistenceManagerException, RPCException, CompExportException {
        this.saveJob();
    }

    protected void setup() throws CompExportException {
        try {
            this.internalTestFlow();
            this.mExporter.constructComponent(this);
            this.internalTestFlow();
        }
        catch (ComponentExportException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("setup Stack Trace:", e, this);
            }
            throw CompExportException.failedToBuildComp(e);
        }
        this.setCompBuilt();
    }

    protected ComponentSaveContext getCompSaveContext() {
        return this.mExportContext.getComponentSaveContext();
    }

    protected HostSetID getPlatform() {
        return this.mExportContext.getPlatform();
    }

    protected ExportContext getContextClone() {
        return this.mExportContext.getDataClone();
    }

    protected synchronized boolean setStatus(CompStatus cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        if (this.mFinalStatus instanceof CompPending) {
            this.mFinalStatus = cs;
            return true;
        }
        return false;
    }

    protected boolean getCompBuilt() {
        return this.mCompBuilt;
    }

    protected void setCompBuilt() {
        this.mCompBuilt = true;
    }

    protected Component getComponent() {
        return this.mComponent;
    }

    protected HostID getHostID() {
        return this.mExportContext.getSourceInfo().getHost();
    }

    protected void internalTestFlow() throws CompExportException {
        try {
            this.testFlow();
        }
        catch (InterruptedException e) {
            throw CompExportException.failedToBuildComp(e);
        }
    }

    protected void externalTestFlow() throws ComponentExportException {
        try {
            this.testFlow();
        }
        catch (InterruptedException e) {
            throw new ComponentExportException(SDK_MSG, (Throwable)e);
        }
    }

    protected SystemDataImpl getSystemDataImpl() {
        return this.mSystemData;
    }

    public SystemData getSystemData() {
        return this.mSystemData;
    }

    public void setComponentDescription(String description) {
        this.mComponent.setDescription(description);
    }

    public void setComponentLabel(String label) {
        this.mComponent.setLabel(label);
    }

    public void addComponentVar(String name, String value, String prompt) {
        this.mComponent.addLocalVar(new VarDecl(AccessMode.PUBLIC, Modifier.NONE, name, value, prompt));
    }

    public String getLocation() {
        return this.mExportContext.getTmpFileLocation() != null ? this.mExportContext.getTmpFileLocation() : this.mExportContext.getSourceInfo().getResourceLocation();
    }

    public void addSourceInfoParam(String name, String val, String desc) {
        SourceInfo si = this.mComponent.getSourceInfo();
        si.addParameter(name, val, desc);
        this.mComponent.setSourceInfo(si);
    }

    public void removeSourceInfoParam(String name) {
        SourceInfo si = this.mComponent.getSourceInfo();
        si.removeParameter(name);
        this.mComponent.setSourceInfo(si);
    }

    public String getSourceInfoParam(String name) {
        return this.mComponent.getSourceInfo().getVarValue(name);
    }

    public VariableSettingsSource getBrowserParams() {
        return this.mExportContext.getAttributes();
    }

    public String convertToValidIdentifier(String invalid) {
        if (invalid == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(invalid);
        int len = buffer.length();
        for (int i = 0; i < len; ++i) {
            try {
                XMLUtil.validateIdentifier(buffer.substring(0, i + 1));
                continue;
            }
            catch (InvalidDatatypeValueException e) {
                buffer.setCharAt(i, '_');
                continue;
            }
            catch (SystemModelParseException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer.toString();
    }

    UserID getTaskOwner() {
        return HierarchyBrowserSubsystem.getInstance().getTaskOwner(this.getName());
    }
}

