/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies.compexport;

import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInException;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInMonitor;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInServices;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

class CompCheckInManager
implements CompCheckInServices {
    private static final int MAX_COMPLETE = 20;
    private static CompCheckInManager ourInstance;
    private HashMap mCompCheckIns = new HashMap();
    private static final Comparator INFO_COMPARATOR;
    private static final Comparator TIME_COMPARATOR;

    public static synchronized CompCheckInManager getInstance() {
        if (ourInstance == null) {
            ourInstance = new CompCheckInManager();
        }
        return ourInstance;
    }

    private CompCheckInManager() {
    }

    public CompStatus getStatus(CompCheckInID id) throws RPCException {
        CompCheckInMonitor mon = this.getMonitor(id);
        if (mon == null) {
            return null;
        }
        return mon.getStatus();
    }

    public CompCheckInInfo getCompCheckInInfo(CompCheckInID id) throws CompCheckInException, RPCException {
        CompCheckInMonitor mon = this.getMonitor(id);
        if (mon == null) {
            throw CompCheckInException.idNotFound(id);
        }
        return new CompCheckInInfo(mon);
    }

    public CompCheckInInfo[] getCompCheckInInfo(CompCheckInID[] ids) throws RPCException {
        Vector<CompCheckInInfo> v = new Vector<CompCheckInInfo>();
        for (int i = 0; i < ids.length; ++i) {
            CompCheckInMonitor mon = this.getMonitor(ids[i]);
            if (mon == null) continue;
            v.add(new CompCheckInInfo(mon));
        }
        return v.toArray(new CompCheckInInfo[0]);
    }

    public CompCheckInInfo cancel(CompCheckInID id) throws CompCheckInException, PersistenceManagerException, RPCException {
        CompCheckInMonitor mon = this.getMonitor(id);
        if (mon == null) {
            throw CompCheckInException.idNotFound(id);
        }
        mon.cancel();
        return new CompCheckInInfo(mon);
    }

    public CompCheckInInfo[] cancel(CompCheckInID[] ids) throws RPCException {
        Vector<CompCheckInInfo> v = new Vector<CompCheckInInfo>();
        for (int i = 0; i < ids.length; ++i) {
            try {
                v.add(this.cancel(ids[i]));
                continue;
            }
            catch (PersistenceManagerException e) {
                continue;
            }
            catch (CompCheckInException e) {
                // empty catch block
            }
        }
        return v.toArray(new CompCheckInInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompCheckInMonitor getMonitor(CompCheckInID id) {
        HashMap hashMap = this.mCompCheckIns;
        synchronized (hashMap) {
            return (CompCheckInMonitor)this.mCompCheckIns.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(CompCheckInMonitor monitor) {
        CompCheckInID id = monitor.getCheckInID();
        HashMap hashMap = this.mCompCheckIns;
        synchronized (hashMap) {
            this.mCompCheckIns.put(id, monitor);
        }
    }

    public void update(CompCheckInID id) {
        this.maintainCheckIns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompCheckInInfo[] getRecentCheckIns() throws RPCException {
        TreeSet<CompCheckInInfo> theSet = new TreeSet<CompCheckInInfo>(INFO_COMPARATOR);
        HashMap hashMap = this.mCompCheckIns;
        synchronized (hashMap) {
            Map.Entry[] mapEntries = this.mCompCheckIns.entrySet().toArray(new Map.Entry[0]);
            for (int i = 0; i < mapEntries.length; ++i) {
                CompCheckInMonitor monitor = (CompCheckInMonitor)mapEntries[i].getValue();
                theSet.add(new CompCheckInInfo(monitor));
            }
        }
        return theSet.toArray(new CompCheckInInfo[0]);
    }

    public CompCheckInInfo[] getRecentCheckIns(CompCheckInID[] ids) throws RPCException {
        TreeSet<CompCheckInInfo> theSet = new TreeSet<CompCheckInInfo>(INFO_COMPARATOR);
        for (int i = 0; i < ids.length; ++i) {
            CompCheckInMonitor monitor = this.getMonitor(ids[i]);
            if (monitor == null) continue;
            theSet.add(new CompCheckInInfo(monitor));
        }
        return theSet.toArray(new CompCheckInInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainCheckIns() {
        HashMap hashMap = this.mCompCheckIns;
        synchronized (hashMap) {
            int maxRemove = this.mCompCheckIns.size() - 20;
            if (maxRemove > 0) {
                TreeSet<CompCheckInMonitor> completed = new TreeSet<CompCheckInMonitor>(TIME_COMPARATOR);
                Iterator iter = this.mCompCheckIns.entrySet().iterator();
                while (iter.hasNext()) {
                    CompCheckInMonitor mon = (CompCheckInMonitor)iter.next().getValue();
                    if (mon.getStatus().getEndTime() == 0L) continue;
                    completed.add(mon);
                }
                int numRemove = completed.size() - 20;
                Iterator compIter = completed.iterator();
                while (numRemove-- > 0) {
                    CompCheckInMonitor remMonitor = (CompCheckInMonitor)compIter.next();
                    this.mCompCheckIns.remove(remMonitor.getCheckInID());
                }
            }
        }
    }

    static {
        INFO_COMPARATOR = new Comparator(){

            public int compare(Object a, Object b) {
                CompCheckInInfo ia = (CompCheckInInfo)a;
                CompCheckInInfo ib = (CompCheckInInfo)b;
                int cmp = ResourceStringUtils.dictionaryCompare(this.useHost(ia), this.useHost(ib));
                if (cmp != 0) {
                    return cmp;
                }
                cmp = ResourceStringUtils.dictionaryCompare(ia.getComponentName(), ib.getComponentName());
                return cmp != 0 ? cmp : 1;
            }

            private String useHost(CompCheckInInfo info) {
                String host = info.getHostName();
                if (host == null) {
                    return String.valueOf('\uffff');
                }
                return host;
            }
        };
        TIME_COMPARATOR = new Comparator(){

            public int compare(Object a, Object b) {
                long bEnd;
                long aEnd = ((CompCheckInMonitor)a).getStatus().getEndTime();
                return aEnd <= (bEnd = ((CompCheckInMonitor)b).getStatus().getEndTime()) ? -1 : 1;
            }
        };
    }
}

