/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies;

import com.raplix.rolloutexpress.hierarchies.Messages;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;

public class HierarchyException
extends CommandException
implements Messages {
    protected HierarchyException() {
    }

    protected HierarchyException(ROXMessage msg) {
        super(msg);
    }

    protected HierarchyException(Throwable t) {
        super(t);
    }

    protected HierarchyException(ROXMessage msg, Throwable t) {
        super(msg, t, 1);
    }

    static HierarchyException noSuchNode(String path) {
        ROXMessage msg = new ROXMessage("hierarchies.NO_SUCH_NODE", new Object[]{path});
        return new HierarchyException(msg);
    }

    static HierarchyException requestChildrenForTerminalNode(String node) {
        ROXMessage msg = new ROXMessage("hierarchies.TERMINAL_NODE_CHILDREN_REQUEST", new Object[]{node});
        return new HierarchyException(msg);
    }

    static HierarchyException failedToLoadBrowser(String browser, String path, Exception e) {
        ROXMessage msg = new ROXMessage("hierarchies.FAILED_TO_LOAD_BROWSER", new Object[]{browser, path});
        return new HierarchyException(msg, (Throwable)e);
    }

    static HierarchyException failedToLoadBrowser(String browser, String path) {
        ROXMessage msg = new ROXMessage("hierarchies.FAILED_TO_LOAD_BROWSER", new Object[]{browser, path});
        return new HierarchyException(msg);
    }

    static HierarchyException hostUnprepared(Host host) {
        ROXMessage msg = new ROXMessage("hierarchies.HOST_UNPREPARED", new Object[]{host.getName()});
        return new HierarchyException(msg);
    }

    static HierarchyException sessionDataExpired() {
        ROXMessage msg = new ROXMessage("hierarchies.BROWSE_SESSION_DATA_MISSING");
        return new HierarchyException(msg);
    }

    static HierarchyException noSuchSystemService(String name, Exception e) {
        ROXMessage msg = new ROXMessage("hierarchies.NO_SUCH_SYSTEM_SERVICE", new Object[]{name});
        return new HierarchyException(msg, (Throwable)e);
    }

    static HierarchyException noBrowserClassNameVar(SystemServiceRef ref) {
        ROXMessage msg = new ROXMessage("hierarchies.NO_BROWSER_CLASS_NAME", new Object[]{ref.getName()});
        return new HierarchyException(msg);
    }

    static HierarchyException browserNotSupportedOnHost(SystemServiceRef ref, Host host) {
        ROXMessage msg = new ROXMessage("hierarchies.BROWSER_UNSUPPORTED_ON_HOST", new Object[]{ref.getName(), host.getName()});
        return new HierarchyException(msg);
    }

    static HierarchyException noSSBrowserVar(String service, String var) {
        ROXMessage msg = new ROXMessage("hierarchies.NO_SS_VAR", new Object[]{var, service});
        return new HierarchyException(msg);
    }

    static HierarchyException exporterLoaderUndefined() {
        ROXMessage msg = new ROXMessage("hierarchies.NO_EXPORTER_LOADER");
        return new HierarchyException(msg);
    }

    static HierarchyException failedToLoadContext(String cType, String bType, Exception e) {
        ROXMessage msg = new ROXMessage("hierarchies.FAILED_TO_LOAD_CONTEXT", new Object[]{cType, bType});
        return new HierarchyException(msg, (Throwable)e);
    }
}

