/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.executor.HostsUnpreparedException;
import com.raplix.rolloutexpress.hierarchies.BrowserIncompatibleWithHostException;
import com.raplix.rolloutexpress.hierarchies.BrowserNode;
import com.raplix.rolloutexpress.hierarchies.BrowserState;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserLoader;
import com.raplix.rolloutexpress.hierarchies.HierarchyException;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInServices;
import com.raplix.rolloutexpress.hierarchies.compexport.CompExportException;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentExportServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ExporterLoader;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.util.string.StringUtil;
import com.sun.n1.sps.plugin.browse.BrowserContext;
import com.sun.n1.sps.plugin.browse.BrowserException;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import com.sun.n1.sps.plugin.export.ComponentExportException;
import com.sun.n1.sps.plugin.export.ComponentExporter;
import com.sun.n1.sps.plugin.export.SystemData;
import com.sun.n1.util.vars.VariableSettingsSource;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

public class HierarchyBrowserSubsystem
extends Subsystem {
    private static HierarchyBrowserSubsystem sInstance;
    private static ExporterLoader sExporterLoader;

    private HierarchyBrowserSubsystem() {
    }

    public HierarchyBrowserSubsystem(Application app) throws ConfigurationException {
        super(app);
        sInstance = this;
    }

    public static HierarchyBrowserSubsystem getInstance() {
        return sInstance;
    }

    public void registerRPCInterfaces(RPCManager rpc) throws RPCException {
        rpc.registerService(ComponentExportServices.class, ComponentExportServices.INSTANCE);
        rpc.registerService(CompCheckInServices.class, CompCheckInServices.INSTANCE);
    }

    public BrowserNode getBrowser(BrowserInfo browser, HostID hostID, String location) throws HierarchyException, HostDBException, RPCException, PersistenceManagerException, HostsUnpreparedException, NoResultsFoundException, CompExportException, ConfigGenException {
        String browserClass;
        Host physical = hostID.getPhysicalHost().getID().getByIDQuery().select();
        this.verifyHost(hostID, physical, browser);
        if (sExporterLoader == null) {
            throw HierarchyException.exporterLoaderUndefined();
        }
        String compType = browser.getComponentType();
        SystemData sysData = sExporterLoader.getSystemData(browser, hostID);
        VariableSettingsSource ssVars = sysData.getSystemServiceVars();
        String string = browserClass = ssVars == null ? null : ssVars.getVarValue(browser.getBrowserClassNameVar());
        if (StringUtil.isEmpty(browserClass)) {
            throw HierarchyException.noSSBrowserVar(browser.getServiceName(), browser.getBrowserClassNameVar());
        }
        String browserClassPath = null;
        try {
            browserClassPath = browser.getBrowserClassPath(sysData);
        }
        catch (BrowserException e) {
            throw new HierarchyException(e);
        }
        ComponentExporter exporter = sExporterLoader.loadExporter(compType);
        BrowserContext ctx = null;
        try {
            ctx = exporter.getBrowserContext(sysData);
        }
        catch (ComponentExportException e) {
            throw HierarchyException.failedToLoadContext(compType, browser.getBrowserType(), e);
        }
        if (ctx == null) {
            ctx = new BrowserContext();
        }
        HierarchyBrowserLoader loader = (HierarchyBrowserLoader)Server.getApp().getRPCInterface(physical.getRARoxAddress(), HierarchyBrowserLoader.class);
        BrowserState state = loader.loadBrowser(browserClass, browserClassPath, ctx);
        return new BrowserNode(loader, state, hostID, compType, browser.getBrowserType(), location);
    }

    public static void registerExporterLoader(ExporterLoader loader) {
        if (sExporterLoader == null) {
            sExporterLoader = loader;
        }
    }

    private void verifyHost(HostID hostID, Host physical, BrowserInfo browser) throws HierarchyException, RPCException, PersistenceManagerException, HostsUnpreparedException, NoResultsFoundException {
        HostSetID limitToHostSetID;
        final HostID physicalID = physical.getID();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException, RPCException {
                    physicalID.refreshMachineInfo();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof RPCException) {
                throw (RPCException)e;
            }
            if (e instanceof PersistenceManagerException) {
                throw (PersistenceManagerException)e;
            }
            throw new HierarchyException(e);
        }
        if (!physical.isPrepared()) {
            Vector<HostID> set = new Vector<HostID>(1);
            set.add(physicalID);
            throw new HostsUnpreparedException(new HostIDSet(set));
        }
        String platform = browser.getPlatform();
        HostSetID platformHostSetID = platform == null ? null : SingleHostSetQuery.byName(platform).selectSummaryView().getID();
        String limitTo = browser.getLimitToHostSet();
        HostSetID hostSetID = limitToHostSetID = limitTo == null ? null : SingleHostSetQuery.byName(limitTo).selectSummaryView().getID();
        if (platform != null && !platformHostSetID.contains(physicalID) || limitTo != null && !limitToHostSetID.contains(hostID)) {
            throw BrowserIncompatibleWithHostException.browserIncompatibleWithHost(browser.getBrowserType(), browser.getComponentType(), hostID.getByIDQuery().selectSummaryView().getName());
        }
    }

    static {
        sExporterLoader = null;
    }
}

