/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies;

import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.SubsystemID;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ItemID;
import com.raplix.rolloutexpress.command.stickydata.Table;
import com.raplix.rolloutexpress.hierarchies.BrowserState;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserLoader;
import com.raplix.rolloutexpress.hierarchies.HierarchyException;
import com.raplix.rolloutexpress.hierarchies.PluginHierarchyException;
import com.raplix.rolloutexpress.hierarchies.RPCFilter;
import com.raplix.rolloutexpress.hierarchies.RPCReadNode;
import com.raplix.rolloutexpress.plugin.ExecJavaExecutor;
import com.raplix.rolloutexpress.plugin.LocalAgentContext;
import com.raplix.rolloutexpress.plugin.PluginMessageHelper;
import com.raplix.util.string.StringUtil;
import com.sun.n1.sps.plugin.browse.Browser;
import com.sun.n1.sps.plugin.browse.BrowserContext;
import com.sun.n1.sps.plugin.browse.BrowserDisplay;
import com.sun.n1.sps.plugin.browse.BrowserException;
import com.sun.n1.sps.plugin.browse.BrowserFactory;
import com.sun.n1.sps.plugin.browse.BrowserFilter;
import com.sun.n1.sps.plugin.browse.BrowserNode;
import com.sun.n1.util.vars.VariableSettingsHolder;
import java.util.Date;
import java.util.LinkedList;

class HierarchyBrowserLoaderImpl
implements HierarchyBrowserLoader {
    private static final SubsystemID CLASS_SUBSYSTEM_ID = new SubsystemID(HierarchyBrowserLoaderImpl.class.getName());
    private static final long STICKY_TIMEOUT = 1200000L;
    private Table mStickyData;
    private Agent mAgent;

    public HierarchyBrowserLoaderImpl(Agent agent) {
        this.mAgent = agent;
        this.mStickyData = agent.getStickySubsystem().getTable(CLASS_SUBSYSTEM_ID);
    }

    public BrowserState loadBrowser(String className, String loadPath, BrowserContext context) throws HierarchyException {
        try {
            if (StringUtil.isEmpty(className)) {
                throw HierarchyException.failedToLoadBrowser(className, loadPath);
            }
            Class factoryClass = ExecJavaExecutor.loadClass(loadPath, className, false, this.mAgent.getExecJavaFileCache());
            BrowserFactory browserFactory = (BrowserFactory)factoryClass.newInstance();
            PluginMessageHelper.getInstance().init(factoryClass.getClassLoader());
            LocalAgentContext agentContext = new LocalAgentContext(factoryClass.getClassLoader());
            Browser browser = browserFactory.getBrowser(context, agentContext);
            BrowserDisplay display = browser.getDisplay();
            BagID browserBag = BagID.generateBagID();
            ItemID browserKey = this.mStickyData.addItem(browser, browserBag, this.stickyExpiration());
            ItemID displayKey = this.mStickyData.addItem(display, browserBag, this.stickyExpiration());
            return new BrowserState(browserBag, browserKey, displayKey);
        }
        catch (HierarchyException e) {
            throw e;
        }
        catch (Exception e) {
            throw HierarchyException.failedToLoadBrowser(className, loadPath, e);
        }
    }

    public RPCReadNode[] getNode(BrowserState state, String location) throws HierarchyException {
        try {
            BrowserNode node;
            this.checkSessionData(state);
            Browser browser = this.getBrowserFromSession(state);
            BrowserDisplay display = (BrowserDisplay)this.mStickyData.getItem(state.getDisplayKey());
            BagID browserBag = state.getBagKey();
            if (node == null) {
                throw PluginHierarchyException.noSuchNode(location);
            }
            LinkedList<BrowserNode> ancestry = new LinkedList<BrowserNode>();
            for (node = browser.getNode(location); node != null; node = node.getParent()) {
                ancestry.addFirst(node);
            }
            RPCReadNode[] rpcAncestry = new RPCReadNode[ancestry.size()];
            rpcAncestry[0] = this.convertAndStore((BrowserNode)ancestry.getFirst(), null, display, null, browserBag);
            for (int i = 1; i < rpcAncestry.length; ++i) {
                rpcAncestry[i] = this.convertAndStore((BrowserNode)ancestry.get(i), (BrowserNode)ancestry.get(i - 1), display, rpcAncestry[i - 1], browserBag);
            }
            return rpcAncestry;
        }
        catch (BrowserException e) {
            throw new HierarchyException(e);
        }
    }

    public RPCFilter[] getAvailableFilters(BrowserState state) throws HierarchyException {
        this.checkSessionData(state);
        Browser browser = this.getBrowserFromSession(state);
        BrowserFilter[] filters = browser.getAvailableFilters();
        if (filters == null) {
            return new RPCFilter[0];
        }
        RPCFilter[] rpcFilters = new RPCFilter[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            rpcFilters[i] = new RPCFilter(filters[i]);
        }
        return rpcFilters;
    }

    public RPCReadNode[] getChildren(BrowserState state, RPCReadNode node) throws HierarchyException {
        try {
            this.checkSessionData(state);
            Browser browser = this.getBrowserFromSession(state);
            BagID browserBag = state.getBagKey();
            BrowserDisplay display = (BrowserDisplay)this.mStickyData.getItem(state.getDisplayKey());
            if (!node.isContainer()) {
                throw PluginHierarchyException.requestChildrenForTerminalNode(node.getFullName());
            }
            BrowserNode parent = (BrowserNode)this.mStickyData.getItem(node.getGUID());
            BrowserNode[] children = parent.getChildren();
            RPCReadNode[] rpcChildren = new RPCReadNode[children.length];
            for (int i = 0; i < children.length; ++i) {
                rpcChildren[i] = this.convertAndStore(children[i], parent, display, node, browserBag);
            }
            return rpcChildren;
        }
        catch (BrowserException e) {
            throw new HierarchyException(e);
        }
    }

    public void setFilterName(BrowserState state, String name) throws HierarchyException {
        try {
            this.checkSessionData(state);
            Browser browser = this.getBrowserFromSession(state);
            browser.setFilterName(name);
        }
        catch (BrowserException e) {
            throw new HierarchyException(e);
        }
    }

    public void closeSession(BrowserState state) {
        this.mStickyData.removeInsideBag(state.getBagKey());
    }

    private Browser getBrowserFromSession(BrowserState state) {
        Browser browser = (Browser)this.mStickyData.getItem(state.getBrowserKey());
        ClassLoader bcl = browser.getClass().getClassLoader();
        PluginMessageHelper.getInstance().init(bcl);
        Thread.currentThread().setContextClassLoader(bcl);
        return browser;
    }

    private RPCReadNode convertAndStore(BrowserNode node, BrowserNode nodeParent, BrowserDisplay display, RPCReadNode rpcParent, BagID bag) throws HierarchyException, BrowserException {
        String resourceName;
        String localName = node.getLocalName();
        String fullName = localName + display.getDelimiter(node, null);
        if (rpcParent != null) {
            String parentName = nodeParent.getLocalName();
            String full = rpcParent.getFullName();
            fullName = full.substring(0, full.lastIndexOf(parentName)) + parentName + display.getDelimiter(nodeParent, node) + fullName;
        }
        if ((resourceName = node.getResourceFetchString()) == null) {
            resourceName = fullName;
        }
        VariableSettingsHolder atts = new VariableSettingsHolder();
        String[] attNames = node.getAttributeNames();
        for (int i = 0; i < attNames.length; ++i) {
            atts.setVarValue(attNames[i], node.getAttribute(attNames[i]));
        }
        String displayName = localName + display.getDesignator(node);
        return new RPCReadNode(this.mStickyData.addItem(node, bag, this.stickyExpiration()), localName, displayName, fullName, node.isInterior(), display.isExportable(node), rpcParent, resourceName, atts);
    }

    private Date stickyExpiration() {
        return new Date(System.currentTimeMillis() + 1200000L);
    }

    private void checkSessionData(BrowserState state) throws HierarchyException {
        if (!this.mStickyData.hasItem(state.getBrowserKey()) || !this.mStickyData.hasItem(state.getDisplayKey())) {
            this.closeSession(state);
            throw HierarchyException.sessionDataExpired();
        }
    }
}

