/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.hierarchies;

import com.raplix.rolloutexpress.hierarchies.BrowserState;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserLoader;
import com.raplix.rolloutexpress.hierarchies.HierarchyException;
import com.raplix.rolloutexpress.hierarchies.RPCReadNode;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.sun.n1.sps.plugin.browse.BrowserFilter;
import com.sun.n1.util.vars.VariableSettingsSource;

public class BrowserNode {
    private RPCReadNode mNode;
    private HierarchyBrowserLoader mLoader;
    private BrowserState mState;
    private HostID mHostID;
    private String mCompType;
    private String mBrowserType;
    private String mFilterName;
    private BrowserNode mParent;
    private BrowserFilter[] mAvailableFilters;

    BrowserNode(HierarchyBrowserLoader loader, BrowserState state, HostID hostID, String compType, String browserType, String location) throws HierarchyException, RPCException {
        RPCReadNode[] nodes = loader.getNode(state, location);
        BrowserNode bNode = new BrowserNode(nodes[0], loader, state, hostID, compType, browserType);
        for (int i = 1; i < nodes.length; ++i) {
            bNode = new BrowserNode(nodes[i], bNode);
        }
        this.mNode = bNode.mNode;
        this.mLoader = bNode.mLoader;
        this.mState = bNode.mState;
        this.mHostID = bNode.mHostID;
        this.mCompType = bNode.mCompType;
        this.mBrowserType = bNode.mBrowserType;
        this.mFilterName = bNode.mFilterName;
        this.mAvailableFilters = bNode.mAvailableFilters;
        this.mParent = bNode.mParent;
    }

    private BrowserNode(RPCReadNode node, HierarchyBrowserLoader loader, BrowserState state, HostID hostID, String compType, String browserType) throws HierarchyException, RPCException {
        this.mNode = node;
        this.mLoader = loader;
        this.mState = state;
        this.mHostID = hostID;
        this.mCompType = compType;
        this.mBrowserType = browserType;
        this.mAvailableFilters = loader.getAvailableFilters(state);
        if (this.mAvailableFilters.length > 0) {
            this.setFilterName(this.mAvailableFilters[0].getName());
        }
        this.mParent = null;
    }

    private BrowserNode(RPCReadNode node, BrowserNode parent) {
        this.mNode = node;
        this.mLoader = parent.mLoader;
        this.mState = parent.mState;
        this.mHostID = parent.mHostID;
        this.mCompType = parent.mCompType;
        this.mBrowserType = parent.mBrowserType;
        this.mFilterName = parent.mFilterName;
        this.mAvailableFilters = parent.mAvailableFilters;
        this.mParent = parent;
    }

    public String getLocalName() {
        return this.mNode.getLocalName();
    }

    public String getDisplayName() {
        return this.mNode.getDisplayName();
    }

    public String getFullName() {
        return this.mNode.getFullName();
    }

    public String getResourceName() {
        return this.mNode.getResourceName();
    }

    public String getComponentTypeName() {
        return this.mCompType;
    }

    public String getBrowserType() {
        return this.mBrowserType;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public String getFilterName() {
        return this.mFilterName;
    }

    public VariableSettingsSource getAttributes() {
        return this.mNode.getAttributes();
    }

    public boolean isContainer() {
        return this.mNode.isContainer();
    }

    public boolean isExportable() {
        return this.mNode.isExportable();
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public BrowserNode getParent() {
        return this.mParent;
    }

    public void setFilterName(String name) throws HierarchyException, RPCException {
        this.mLoader.setFilterName(this.mState, name);
        this.mFilterName = name;
    }

    public BrowserNode[] getChildren() throws HierarchyException, RPCException {
        if (!this.isContainer()) {
            throw HierarchyException.requestChildrenForTerminalNode(this.getFullName());
        }
        RPCReadNode[] nodes = this.mLoader.getChildren(this.mState, this.mNode);
        BrowserNode[] children = new BrowserNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            children[i] = new BrowserNode(nodes[i], this);
        }
        return children;
    }

    public BrowserFilter[] getAvailableFilters() {
        return this.mAvailableFilters;
    }

    public SourceInfo getSourceInfo() {
        return new SourceInfo(this.mHostID, this.mBrowserType, this.getFullName(), this.getResourceName());
    }

    public void closeSession() throws RPCException {
        this.mLoader.closeSession(this.mState);
    }
}

