/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.virtual;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.exceptions.ConnectivityException;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.PlanDeadlockException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanPermissionException;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.SubplanInvoker;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.query.SingleAutoGeneratedPlanQuery;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.virtual.RealAgent;
import com.raplix.rolloutexpress.executor.virtual.VACreationData;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentCreationException;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentFactory;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.locks.DeadlockCycle;
import com.raplix.util.locks.DeadlockException;
import com.raplix.util.locks.QueuedLocker;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.Platform;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.QueueLocker;
import com.raplix.util.threads.ResourceID;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class VirtualAgentManager
implements PlanExecutorMessages {
    private Hashtable mKnownVAs = new Hashtable();

    public VirtualAgent checkout(RunLevel inRunLevel, VACreationData inVAData, String inPlanName, ExecutionState inState, Context inContext, boolean inSuppressAccessChecks) throws PlanExecutionException {
        this.lockNecessaryHosts(true, inVAData.getTarget(), inContext, inState.getTaskInfo());
        VirtualAgent result = (VirtualAgent)this.mKnownVAs.get(inVAData.getTarget().getPhysicalHostID());
        if (result != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Found host, locking " + result.getHostData().getHostName(), this);
            }
            result.setTarget(inVAData.getTarget());
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Didn't find host, creating new one and locking for " + inVAData.getTarget().getCurrentHost().getName(), this);
            }
            result = this.createVirtualAgentAndCheckConnectivity(inVAData, inRunLevel, inState.getTaskInfo(), inState.getApp());
            this.mKnownVAs.put(inVAData.getTarget().getPhysicalHostID(), result);
            if (!inSuppressAccessChecks) {
                this.checkTargetHasPermissions(inVAData, inState);
            }
        }
        return result;
    }

    public void release(VirtualAgent inVA, Context inContext, TaskInfo inTaskInfo) throws PlanExecutionException {
        this.lockNecessaryHosts(false, inVA.getTarget(), inContext, inTaskInfo);
    }

    public void reset() {
        Iterator iterator = this.mKnownVAs.values().iterator();
        while (iterator.hasNext()) {
            VirtualAgent agent = (VirtualAgent)iterator.next();
            agent.cleanup();
        }
        this.mKnownVAs.clear();
    }

    protected void checkTargetHasPermissions(VACreationData inVAData, ExecutionState inState) throws PlanExecutionException {
        Target curTarget = inVAData.getTarget();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Checking permissions for current host " + curTarget.getCurrentHost().getName() + "(" + curTarget.getCurrentHost().getID() + ") for plan " + inState.getCompiledSubplan().getExecutionPlan().getName() + "(" + inState.getCompiledSubplan().getExecutionPlan().getID() + ")", this);
        }
        this.checkOneHostPermission(curTarget.getCurrentHost(), inState);
        if (curTarget.getCurrentHost().getID().equals(curTarget.getPhysicalHost().getID())) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Physical and current hosts are identical, so skipping permissions check for physical host", this);
            }
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Checking permissions for physical host " + curTarget.getPhysicalHost().getName() + "(" + curTarget.getPhysicalHost().getID() + ") for plan " + inState.getCompiledSubplan().getExecutionPlan().getName() + "(" + inState.getCompiledSubplan().getExecutionPlan().getID() + ")", this);
            }
            this.checkOneHostPermission(curTarget.getPhysicalHost(), inState);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("PER has access for current host " + curTarget.getCurrentHost().getName() + " and physical host " + curTarget.getPhysicalHost().getName(), this);
        }
    }

    private void checkOneHostPermission(Host inHost, ExecutionState inState) throws PlanExecutionException {
        ExecutionPlanID thePlanID = inState.getTaskInfo().getPlanID();
        if (null != thePlanID) {
            ExecutionPlan currentPlan = inState.getCompiledSubplan().getExecutionPlan();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Examining exe permissions for plan " + currentPlan.getName() + "(" + currentPlan.getID() + ")", this);
            }
            try {
                this.checkOnePlanForPermission(currentPlan, inHost);
                Stack planChain = inState.getCompiledSubplan().getCallingChain();
                if (planChain.isEmpty()) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Plan " + currentPlan.getName() + " is a simple plan", this);
                    }
                } else {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Plan " + currentPlan.getName() + " is part of a complex plan", this);
                    }
                    while (!planChain.isEmpty()) {
                        SubplanInvoker currentInvoker = (SubplanInvoker)planChain.pop();
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Examining ancestor of " + currentPlan.getName() + " - " + currentInvoker, this);
                        }
                        this.checkOnePlanForPermission(currentInvoker.getSubplanPlanID().getByIDQuery().selectSummaryView(), inHost);
                    }
                }
            }
            catch (RPCException e) {
                throw new PlanExecutionException(e);
            }
            catch (PersistenceManagerException e) {
                throw new PlanExecutionException(e);
            }
        }
    }

    private void checkOnePlanForPermission(SummaryExecutionPlan inPlan, Host inHost) throws RPCException, PersistenceManagerException, PlanPermissionException {
        block11: {
            FolderID theFolderID = inPlan.getPath();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Checking for exe permissions on folder " + theFolderID + " on host " + inHost.getName() + "(" + inHost.getID() + ") for plan " + inPlan.getName(), this);
            }
            if (!this.checkPermission(FolderPermission.createExecutePermission(theFolderID, inHost.getID()))) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("failed!", this);
                }
                this.noExecutePermission(inHost, inPlan.getName());
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("passed", this);
            }
            try {
                AutoGeneratedPlan agPlan = SingleAutoGeneratedPlanQuery.byExecutionPlanID(inPlan.getID()).select();
                SummaryComponent theComponent = agPlan.getComponentID().getByIDQuery().selectSummaryView();
                theFolderID = theComponent.getPath();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Plan " + inPlan.getName() + "(" + inPlan.getID() + ") is autogenerated", this);
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Checking for autorun permissions on folder " + theFolderID + " on host " + inHost.getName() + "(" + inHost.getID() + ")", this);
                }
                if (!this.checkPermission(new FolderPermission(theFolderID, "autorun"))) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("failed!", this);
                    }
                    this.noExecutePermission(theComponent, agPlan.getProcedureName());
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("passed", this);
                }
            }
            catch (NoResultsFoundException e) {
                if (!Logger.isDebugEnabled(this)) break block11;
                Logger.debug("Plan " + inPlan.getName() + "(" + inPlan.getID() + ") is not autogenerated", this);
            }
        }
    }

    private boolean checkPermission(FolderPermission inFolderPermission) {
        try {
            AccessController.checkPermission(inFolderPermission);
        }
        catch (AccessControlException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("deniedPerm:" + e, this);
            }
            return false;
        }
        return true;
    }

    private void noExecutePermission(Host inHost, String inPlanName) throws PlanPermissionException {
        if (Logger.isErrorEnabled(this)) {
            Logger.error(ROXMessageManager.messageAsString("pe.ERR_ACCESS_FOR_HOST", new Object[]{inHost.getName()}), this);
        }
        throw new PlanPermissionException(inHost.getID(), inHost.getName(), inPlanName);
    }

    private void noExecutePermission(SummaryComponent inComponent, String inProcedureName) throws PlanPermissionException {
        if (Logger.isErrorEnabled(this)) {
            Logger.error(ROXMessageManager.messageAsString("pe.EX_AUTOGENPLAN_ACCESS", new Object[]{inComponent.getName(), inProcedureName}), this);
        }
        throw new PlanPermissionException(inComponent, inProcedureName);
    }

    private void lockNecessaryHosts(boolean infLockAction, Target inTarget, Context inContext, TaskInfo inTaskInfo) throws PlanDeadlockException, PlanExecutionException {
        if (!inTaskInfo.getSkipPhysicalHostLocking()) {
            this.lockOneHost(infLockAction, "physical", inTarget.getPhysicalHost(), inContext, inTaskInfo);
        } else if (Logger.isDebugEnabled(this)) {
            Logger.debug("skipping locking of physical host " + inTarget.getPhysicalHost().getName(), this);
        }
        this.lockOneHost(infLockAction, "current", inTarget.getCurrentHost(), inContext, inTaskInfo);
    }

    private void lockOneHost(boolean infLockAction, String inHostType, Host inHost, Context inContext, TaskInfo inTaskInfo) throws PlanDeadlockException, PlanExecutionException {
        ResourceID hostLockID = inTaskInfo.getHostLockMapping(inHost);
        if (hostLockID == null) {
            return;
        }
        try {
            if (infLockAction) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Locking " + inHostType + " host " + inHost.getName(), this);
                }
                inContext.acquireNested(hostLockID);
            } else {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Unlocking " + inHostType + " host " + inHost.getName(), this);
                }
                inContext.releaseNested(hostLockID);
            }
        }
        catch (Exception ex) {
            if (ex instanceof DeadlockException) {
                DeadlockException deadex = (DeadlockException)ex;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Errored while locking host " + inHost.getName(), deadex, this);
                }
                throw this.createPlanDeadlockEx(inContext, inHost, deadex.getCycles());
            }
            throw new PlanExecutionException(ex);
        }
    }

    protected PlanDeadlockException createPlanDeadlockEx(Context inCtx, Host inHost, DeadlockCycle[] inCycles) {
        int shortestCycle = 0;
        for (int i = 1; i < inCycles.length; ++i) {
            if (inCycles[shortestCycle].getLockers().length <= inCycles[i].getLockers().length) continue;
            shortestCycle = i;
        }
        QueuedLocker[] lockers = inCycles[shortestCycle].getLockers();
        int startingLockerPos = 0;
        for (int i = 0; i < lockers.length; ++i) {
            QueueLocker locker = (QueueLocker)lockers[i].getLocker();
            if (!locker.getThread().getName().equals(inCtx.getName())) continue;
            startingLockerPos = i;
            break;
        }
        QueueLocker startingLocker = (QueueLocker)lockers[startingLockerPos].getLocker();
        String startingLockerName = startingLocker.getThread().getName();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Deadlock at pos " + startingLockerPos + ":" + startingLockerName + "-->" + inHost.getName(), this);
        }
        String curOwnedBy = startingLockerName;
        StringBuffer middleMsg = new StringBuffer();
        int start = (lockers.length + startingLockerPos - 1) % lockers.length;
        String firstOwner = ((QueueLocker)lockers[start].getLocker()).getThread().getName();
        int i = start;
        do {
            QueueLocker theLocker = (QueueLocker)lockers[i].getLocker();
            String nextInCycleName = theLocker.getThread().getName();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("in cycle position " + i + ", looking at " + nextInCycleName, this);
            }
            middleMsg.append(new ROXMessage("pe.DEADLOCK_MIDDLE", curOwnedBy, nextInCycleName));
            curOwnedBy = nextInCycleName;
        } while ((i = (i - 1 + lockers.length) % lockers.length) != start);
        ROXMessage msg = new ROXMessage("pe.DEADLOCK_INTRO", new String[]{inCtx.getName(), inHost.getName(), firstOwner, middleMsg.toString()});
        return new PlanDeadlockException(msg);
    }

    protected VirtualAgent createVirtualAgentAndCheckConnectivity(VACreationData inVAData, RunLevel inRunLevel, TaskInfo inTaskInfo, Application inApp) throws PlanExecutionException {
        VirtualAgent outAgent;
        block10: {
            outAgent = null;
            try {
                HostData hostData = inTaskInfo.getHostData(inVAData.getTarget().getCurrentHostID());
                if (hostData == null) {
                    throw new VirtualAgentCreationException("pe.NO_HOST_DATA_FOR_HOST", (Object)inVAData.getTarget().getCurrentHost().getName());
                }
                if (inRunLevel.equals(RunLevel.PREFLIGHT)) {
                    outAgent = this.createPreflightAgent(inVAData.getTarget(), hostData, inVAData.getBagID(), inTaskInfo, inApp);
                    break block10;
                }
                if (inRunLevel.equals(RunLevel.ACTUAL)) {
                    outAgent = new RealAgent(inApp, hostData, inVAData.getTarget(), inVAData.getBagID());
                    break block10;
                }
                throw new VirtualAgentCreationException("pe.ILLEGAL_RUN_LEVEL", (Object)inRunLevel.toString());
            }
            catch (VirtualAgentCreationException ex) {
                ConnectivityException cex = new ConnectivityException(inVAData.getTarget().getPhysicalHost().getName(), (Throwable)ex);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Error while creating PERunner for target: " + inVAData.getTarget().getID(), ex, this);
                }
                PlanExecutionException pex = new PlanExecutionException("pe.PE_CREATION_FAIL", (Throwable)cex, (Object[])new String[]{"VirtualAgent", inVAData.getTarget().getCurrentHost().getName()});
                throw pex;
            }
            catch (PlanExecutionException pex) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("CPE.createVA", pex, this);
                }
                throw pex;
            }
            catch (CommandException cex) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("CPE.createVA", cex, this);
                }
                throw new PlanExecutionException(cex);
            }
        }
        return outAgent;
    }

    protected VirtualAgent createPreflightAgent(Target inTarget, HostData inHostData, BagID inBagID, TaskInfo inTaskInfo, Application inApp) throws PlanExecutionException, VirtualAgentCreationException {
        Platform platform;
        MachineInfo newMI;
        block13: {
            MachineInfo oldMI = inTarget.getPhysicalHost().getMachineInfo();
            newMI = this.refreshMachineInfo(inTarget, inTarget.getPhysicalHost().getName());
            if (!newMI.equals(oldMI)) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("MI changed for host " + inHostData.getHostName() + ", reloading the hostResolver", this);
                }
                inTaskInfo.getHostResolver().reloadHost(inTarget.getPhysicalHostID());
                if (inTaskInfo.getShouldVerifySystemServicesInstalled()) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("doing prepCheck on " + inHostData.getHostName(), this);
                    }
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("host " + inTarget.getPhysicalHost().getName() + " MI is different", this);
                    }
                    try {
                        if (!inTarget.getPhysicalHost().isPrepared()) {
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("host " + inTarget.getPhysicalHost().getName() + " unprepared", this);
                            }
                            throw new PlanExecutionException(new ROXMessage("pe.THIS_HOST_UNPREPARED", inTarget.getPhysicalHost().getName(), inTarget.getCurrentHost().getName()));
                        }
                        break block13;
                    }
                    catch (CommandException rex) {
                        throw new PlanExecutionException(rex);
                    }
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("skipping prepCheck on host " + inHostData.getHostName() + " b/c prepCheck is disabled", this);
                }
            } else if (Logger.isDebugEnabled(this)) {
                Logger.debug("MI not changed, skipping prepCheck on host " + inHostData.getHostName(), this);
            }
        }
        if ((platform = newMI.getRAPlatform()) == null) {
            throw new VirtualAgentCreationException("pe.UNKNOWN_PLATFORM_FOR_HOST", new Object[]{inHostData.getHostName(), platform.toString()});
        }
        return VirtualAgentFactory.createPreflightAgent(platform, inApp, inHostData, inTarget, inBagID, inTaskInfo.getDetailedPreflight());
    }

    protected MachineInfo refreshMachineInfo(final Target inTarget, String inHostName) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("refreshing machineInfo for " + inTarget.getPhysicalHost().getName(), this);
        }
        try {
            return (MachineInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException, RPCException {
                    return inTarget.getPhysicalHostID().refreshMachineInfo();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            RaplixException raex = (RaplixException)pae.getException();
            ROXMessage msg = raex.getROXMessage();
            String key = msg.getKey();
            if (key.equals(NetMessageCode.RPC_SERV_INVOKE_RR_ERROR.getCode())) {
                throw new PlanExecutionException(new ConnectivityException(inHostName, (Throwable)pae));
            }
            throw new PlanExecutionException(new ROXMessage("pe.FAILED_MACHINE_INFO_REFRESH", inTarget.getPhysicalHost().getName()), (Throwable)raex);
        }
    }
}

