/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.virtual;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.virtual.FastPreflightAgent;
import com.raplix.rolloutexpress.executor.virtual.UnixPreflightAgent;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentCreationException;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.Platform;

public class VirtualAgentFactory {
    private static final String LOGGER_CAT = VirtualAgentFactory.class.getName();

    private VirtualAgentFactory() {
    }

    public static VirtualAgent createPreflightAgent(Platform platform, Application inApp, HostData inHostData, Target inTarget, BagID inCurrentBagID, boolean inDetailedPreflight) throws VirtualAgentCreationException {
        if (platform == null || platform.isPOSIX()) {
            if (inDetailedPreflight) {
                if (Logger.isDebugEnabled(LOGGER_CAT)) {
                    Logger.debug("creating UnixPreflightAgent", LOGGER_CAT);
                }
                return new UnixPreflightAgent(inApp, inHostData, inTarget, inCurrentBagID);
            }
            if (Logger.isDebugEnabled(LOGGER_CAT)) {
                Logger.debug("creating FastPreflightAgent", LOGGER_CAT);
            }
            return new FastPreflightAgent(inApp, inHostData, inTarget, inCurrentBagID);
        }
        if (Logger.isDebugEnabled(LOGGER_CAT)) {
            Logger.debug("creating FastPreflightAgent", LOGGER_CAT);
        }
        return new FastPreflightAgent(inApp, inHostData, inTarget, inCurrentBagID);
    }

    public static VirtualAgent createPreflightAgentForCurrentPlatform(Application inApp, HostData inHostData, Target inTarget, BagID inCurrentBagID, boolean inDetailedPreflight) throws VirtualAgentCreationException {
        return VirtualAgentFactory.createPreflightAgent(Platform.LOCAL, inApp, inHostData, inTarget, inCurrentBagID, inDetailedPreflight);
    }
}

