/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.virtual;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.exceptions.ConnectivityException;
import com.raplix.rolloutexpress.command.rpcinterfaces.FileOperationsInterface;
import com.raplix.rolloutexpress.command.rpcinterfaces.NativePlatformIntegrationInterface;
import com.raplix.rolloutexpress.command.rpcinterfaces.SnapshotServices;
import com.raplix.rolloutexpress.command.rpcinterfaces.ToolsInterface;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.config.ConfigGenManager;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionPreflightWarning;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanRecorder;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentCreationException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcGroup;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcPush;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.util.logger.Logger;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import com.raplix.util.unicode.UnicodeOutputStreamWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class VirtualAgentBase
implements VirtualAgent,
PlanExecutorMessages {
    protected HostData mHostData;
    private ThreadLocal mTargetLocal = new ThreadLocal();
    protected Application mApp;
    protected ConfigGenManager mConfigGenMgr;
    protected NativePlatformIntegrationInterface mNativeInterface;
    protected SnapshotServices mSnapshotServices;
    protected ToolsInterface mToolsInterface;
    protected FileOperationsInterface mFileOpsInterface;
    protected ResourceSubsystem mRsrcMgr;
    protected NotificationManager mNotificationMgr;
    protected RoxAddress mHostRAAddress;
    protected InstallDBManager mInstallDB;
    protected PlanSubsystem mPlanSubsystem;

    public VirtualAgentBase(Application inApp, HostData inHostData, Target inTarget, BagID inCurrentBagID) throws VirtualAgentCreationException {
        try {
            this.mApp = inApp;
            this.mRsrcMgr = inApp.getResourceSubsystem();
            this.mNotificationMgr = inApp.getNotificationManager();
            this.mConfigGenMgr = inApp.getConfigGenSubsystem();
            this.mInstallDB = inApp.getInstallDBSubsystem();
            this.mPlanSubsystem = inApp.getPlanSubsystem();
            this.mHostData = inHostData;
            this.initRemoteInterfaces(inTarget, inCurrentBagID);
        }
        catch (RaplixException ex) {
            if (Logger.isErrorEnabled(this)) {
                String message = ROXMessageManager.messageAsString("pe.ERR_CREATE_VIRTUAL_AGENT", new Object[]{inHostData.getHostName()});
                Logger.error(message, ex, this);
            }
            throw new VirtualAgentCreationException(ex, inHostData.getHostName());
        }
    }

    public void cleanup() {
    }

    protected void initRemoteInterfaces(Target inTarget, BagID inCurrentBagID) throws RaplixException {
        this.setTarget(inTarget);
        this.mHostRAAddress = inTarget.getPhysicalHost().getRARoxAddress();
        this.mNativeInterface = (NativePlatformIntegrationInterface)this.mApp.getRPCInterface(this.mHostRAAddress, NativePlatformIntegrationInterface.class);
        this.mToolsInterface = (ToolsInterface)this.mApp.getRPCInterface(this.mHostRAAddress, ToolsInterface.class);
        this.mFileOpsInterface = (FileOperationsInterface)this.mApp.getRPCInterface(this.mHostRAAddress, FileOperationsInterface.class);
        this.mSnapshotServices = (SnapshotServices)this.mApp.getRPCInterface(this.mHostRAAddress, SnapshotServices.class);
    }

    private void assertTargetNotSelf() throws PlanExecutionException {
        InetAddress[] local;
        int address = this.mHostRAAddress.getIPAddress();
        if (address == 2130706433) {
            throw new PlanExecutionException("pe.ERR_RA_ON_MS");
        }
        try {
            local = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_REBOOT", (Throwable)ex);
        }
        for (int i = 0; i < local.length; ++i) {
            byte[] b = local[i].getAddress();
            int localAddress = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
            if (address != localAddress) continue;
            throw new PlanExecutionException("pe.ERR_RA_ON_MS");
        }
    }

    protected abstract void doReboot() throws PlanExecutionException;

    public void reboot() throws PlanExecutionException {
        this.assertTargetNotSelf();
        this.doReboot();
    }

    protected abstract boolean doIsRebootPending() throws PlanExecutionException;

    public boolean isRebootPending() throws PlanExecutionException {
        this.assertTargetNotSelf();
        return this.doIsRebootPending();
    }

    public boolean checkConnectivity(RoxAddress inTargetAddr) throws ConnectivityException, RPCException {
        return this.mToolsInterface.checkConnectivity(inTargetAddr);
    }

    public void sendCustomUserEvent(ExecutionState inState, StepInfo inStepInfo, String inMessage) {
    }

    public void sendControlServiceEvent(PlanRecorder inRecorder, InstalledComponentID inInstalledCompID, String inControlServiceName) {
    }

    public boolean checkComponentInstalled(InstalledComponentRef inCompRef, ExecutionState inState, TargetType inType) throws PlanExecutionPreflightWarning, PlanExecutionException {
        InstalledComponent theComp = this.getInstalledComponent(inCompRef, inState, inType);
        return theComp != null;
    }

    public void markComponentInstalled(InstalledComponent inInstalledComponent, InstalledComponentRef inInstalledCompRef, Caller inCaller, ExecutionState inState) throws PlanExecutionException {
        InstallDBContext theContext = inState.getTaskInfo().getInstallDBContext();
        try {
            theContext.installComponent(inInstalledComponent, inState.getCurrPlanTargetedCtx(), inCaller, this.mNotificationMgr);
        }
        catch (RaplixException e) {
            throw new PlanExecutionException(e);
        }
    }

    public void markComponentUninstalled(InstalledComponent inInstalledComponent, Caller inCaller, ExecutionState inState) throws PlanExecutionException {
        InstallDBContext theContext = inState.getTaskInfo().getInstallDBContext();
        try {
            theContext.uninstallComponent(inInstalledComponent, inState.getCurrPlanTargetedCtx(), inCaller, this.mNotificationMgr);
        }
        catch (RaplixException e) {
            throw new PlanExecutionException(e);
        }
    }

    public final TargetID getTargetID() {
        return this.getTarget().getID();
    }

    public final RoxAddress getHostRAAddress() {
        return this.mHostRAAddress;
    }

    public Target getTarget() {
        Target theTarget = (Target)this.mTargetLocal.get();
        return theTarget;
    }

    public void setTarget(Target inTarget) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Resetting target to new " + inTarget, this);
        }
        this.mTargetLocal.set(inTarget);
    }

    public final HostData getHostData() {
        return this.mHostData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceID checkCustomFileIntoRepo(final RsrcInfo inRsrcInfo, byte[] inData) throws Exception {
        ByteArrayInputStream instream = null;
        try {
            ResourceID theID;
            final ByteArrayInputStream theStreamToUse = instream = new ByteArrayInputStream(inData);
            ResourceSpec template = inRsrcInfo.getResourceSpec();
            final ResourceSpec customSpec = template.makeCustomSpec(inRsrcInfo.getResourceID());
            ResourceID resourceID = theID = (ResourceID)new ResourceAccessor(this.mRsrcMgr){

                public Object innerAccess() throws ResourceException {
                    RsrcManifest theManifest = this.getManifest(inRsrcInfo.getResourceID(), null);
                    ResourceEntryIterator theIter = theManifest.getEntryIterator();
                    if (!theIter.hasNext()) {
                        throw new ResourceException("pe.NO_ENTRY_FOR_RESOURCE", (Object[])new String[]{customSpec.getName()});
                    }
                    ResourceEntry theEntry = theIter.next();
                    try {
                        RsrcInfo info = VirtualAgentBase.this.mRsrcMgr.checkInStreamAsConfig(theStreamToUse, customSpec, "customized config file", theEntry.getPerms(), null);
                        return info.getResourceID();
                    }
                    catch (RPCException ex) {
                        throw new ResourceException(ex);
                    }
                }
            }.access();
            return resourceID;
        }
        finally {
            if (instream != null) {
                ((InputStream)instream).close();
            }
        }
    }

    public RsrcPush createPush(RsrcGroup inGroup, HostID inHostID, ResourceSubsystem inRsrcMgr) throws ResourceException {
        return new RsrcPush(inGroup, inHostID, inRsrcMgr, TaskExecutor.isPreflightRunLevel(this.getRunLevel()));
    }

    public void pushFilesToAgent(RsrcPush inPush) throws CommandException, InterruptedException {
        inPush.activateNow(true);
    }

    public void disposeOfPush(RsrcPush inPush) throws CommandException {
        inPush.dispose();
    }

    public byte[] generateCustomizedFile(final RsrcInfo inRsrcInfo, final ConfigGenerator inGenerator, ComponentID inCompID) throws PlanExecutionException {
        final ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        try {
            new ResourceAccessor(this.mRsrcMgr){

                public Object innerAccess() throws ResourceException {
                    RsrcManifest theManifest = this.getManifest(inRsrcInfo.getResourceID(), null);
                    InputStream istream = theManifest.getInputStream(theManifest.getEntryIterator().next());
                    try {
                        UnicodeInputStreamReader reader = new UnicodeInputStreamReader(istream);
                        BufferedWriter writer = new BufferedWriter(new UnicodeOutputStreamWriter((OutputStream)ostream, reader));
                        inGenerator.generate(reader, (Writer)writer);
                        writer.flush();
                    }
                    catch (IOException ex) {
                        String rsrcName = inRsrcInfo.getResourceSpec().getName();
                        if (Logger.isErrorEnabled(this)) {
                            String message = ROXMessageManager.messageAsString("pe.ERR_CUSTOMIZING_FILE", new Object[]{rsrcName, VirtualAgentBase.this.mHostData.getHostName()});
                            Logger.error(message, ex, this);
                        }
                        throw new ResourceException(new PlanExecutionException("pe.ERR_CG_HOST", (Throwable)ex, new Object[]{rsrcName, VirtualAgentBase.this.mHostData.getHostName()}));
                    }
                    catch (RaplixException ex) {
                        throw new ResourceException(ex);
                    }
                    finally {
                        try {
                            istream.close();
                        }
                        catch (IOException e) {}
                    }
                    return null;
                }
            }.access();
        }
        catch (ResourceException e) {
            throw new PlanExecutionException(e);
        }
        return ostream.toByteArray();
    }

    public final InstalledComponent createInstalledComponent(ExecutionState inState, ComponentInstallData inCID, String inBlockName, ComponentRefDecl inCompDecl) throws PlanExecutionException {
        InstalledComponent ic = null;
        InstallDBContext ctx = inState.getTaskInfo().getInstallDBContext();
        try {
            InstalledComponent parentIC = inState.getCurrInstalledComponent();
            if (parentIC != null && inCompDecl != null && inCompDecl.getInstallMode().equals(InstallMode.NESTED)) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("creating nested installComponent: " + inCompDecl.getName(), this);
                }
                ic = ctx.createInstalledComponent(inCID.getComponent().getID(), inCID.getInstallPath(), parentIC, inCompDecl.getName(), this.getTargetID(), inCID.getGeneratedVarSettingsID(), inState.getTaskID(), inState.getCompiledSubplan().getSubplanPlanID(), inBlockName, inState.getCurrPlanTargetedCtx(), inState.getCaller());
            } else {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Creating top-level iComp: " + inCID.getComponent().getName(), this);
                }
                ic = ctx.createInstalledComponent(inCID.getComponent().getID(), inCID.getInstallPath(), this.getTargetID(), inCID.getGeneratedVarSettingsID(), inState.getTaskID(), inState.getCompiledSubplan().getSubplanPlanID(), inBlockName, inState.getCurrPlanTargetedCtx(), inState.getCaller());
            }
        }
        catch (RaplixException e) {
            throw new PlanExecutionException(e);
        }
        return ic;
    }

    public InstalledComponent getInstalledComponent(InstalledComponentRef inComponentRef, ExecutionState inState, TargetType inLookupType) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Looking up component for: " + inComponentRef.toString(), this);
        }
        InstalledComponent theInstalledComponent = null;
        try {
            InstallDBContext theContext = inState.getTaskInfo().getInstallDBContext();
            theInstalledComponent = theContext.getInstalledComponent(this.getTarget().getHostID(inLookupType), inComponentRef, inLookupType);
            if (theInstalledComponent != null) {
                return theInstalledComponent;
            }
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("installed component lookup returned Results: " + theInstalledComponent, this);
        }
        return theInstalledComponent;
    }
}

