/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.virtual;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.InvalidUserGroupException;
import com.raplix.rolloutexpress.command.exceptions.RANoRootPrivilegesException;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.rolloutexpress.command.rpcinterfaces.MEMIXInterface;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ItemID;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionPreflightWarning;
import com.raplix.rolloutexpress.executor.ResourceEventData;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.ExecNativeStepDescriptor;
import com.raplix.rolloutexpress.executor.virtual.PreflightAgentBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentCreationException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.util.threads.SafeThread;

public class UnixPreflightAgent
extends PreflightAgentBase {
    protected MEMIXInterface mMEMIXInterface;
    protected ItemID mMEMIXHandle;

    public UnixPreflightAgent(Application inApp, HostData inHostData, Target inTarget, BagID inCurrentBagID) throws VirtualAgentCreationException {
        super(inApp, inHostData, inTarget, inCurrentBagID);
    }

    public void cleanup() {
        this.cleanup(false);
    }

    protected void cleanup(boolean inSync) {
        SafeThread t = new SafeThread(new Runnable(){

            public void run() {
                try {
                    UnixPreflightAgent.this.mMEMIXInterface.deleteSimulator(UnixPreflightAgent.this.mMEMIXHandle);
                }
                catch (RPCException rPCException) {
                    // empty catch block
                }
            }
        }, "memixSimulatorCleaner");
        if (inSync) {
            t.run();
        } else {
            t.start();
        }
    }

    protected void initRemoteInterfaces(Target inTarget, BagID inCurrentBagID) throws RaplixException {
        super.initRemoteInterfaces(inTarget, inCurrentBagID);
        this.mMEMIXInterface = (MEMIXInterface)this.mApp.getRPCInterface(this.mHostRAAddress, MEMIXInterface.class);
        this.mMEMIXHandle = this.mMEMIXInterface.createSimulator(inCurrentBagID);
    }

    protected void doReboot() throws PlanExecutionException {
        throw new PlanExecutionException("pe.ERR_REBOOT_UNSUPPORTED", this.mHostData.getHost().getMachineInfo().getOSName());
    }

    public void installDeployedResources(ResourceEventData inEventData, ResourceDefinition[] inAllRsrc, InstalledResource[] inInstalledResources, PushID inPushID) throws PlanExecutionException {
        try {
            this.mMEMIXInterface.installDeployedResources(this.mMEMIXHandle, inEventData, inAllRsrc, inInstalledResources, inPushID);
        }
        catch (InvalidUserGroupException ex) {
            throw new PlanExecutionPreflightWarning(ex);
        }
        catch (RANoRootPrivilegesException ex) {
            throw new PlanExecutionPreflightWarning(ex);
        }
        catch (CommandExecutionErrorException ex) {
            throw new PlanExecutionPreflightWarning(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public void uninstallDeployedFiles(String[][] inPathsToDelete) throws PlanExecutionException {
        try {
            this.mMEMIXInterface.uninstallDeployedFiles(this.mMEMIXHandle, inPathsToDelete);
        }
        catch (CommandExecutionErrorException cee) {
            throw new PlanExecutionPreflightWarning(cee);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
    }

    public void deleteFiles(String[] inPathsToDelete) throws PlanExecutionException {
        try {
            this.mMEMIXInterface.deleteFiles(this.mMEMIXHandle, inPathsToDelete);
        }
        catch (CommandExecutionErrorException cee) {
            throw new PlanExecutionPreflightWarning(cee);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
    }

    public ExecNativeOutput execNative(ExecNativeStepDescriptor inDescriptor) throws PlanExecutionException {
        try {
            this.mMEMIXInterface.execNative(this.mMEMIXHandle, inDescriptor);
            return null;
        }
        catch (CommandExecutionErrorException cee) {
            throw new PlanExecutionPreflightWarning(cee);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException("pe.ERR_EXEC_NATIVE_CMD", (Throwable)rpce, inDescriptor.getCommandStringForErrMsg());
        }
    }

    public void transformFile(Transformation inTransformation) throws PlanExecutionException {
        try {
            this.mMEMIXInterface.transformFile(this.mMEMIXHandle, inTransformation, this.mApp.getPlanSubsystem().getConfigArchiveSuffixes());
        }
        catch (UnsupportedSubsystemException ce) {
            throw new PlanExecutionPreflightWarning(ce);
        }
        catch (ConfigurationException ce) {
            throw new PlanExecutionPreflightWarning(ce);
        }
        catch (CommandExecutionErrorException ce) {
            throw new PlanExecutionPreflightWarning(ce);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
    }

    public boolean shouldSpecifyUserToRunAs(String inUser) throws PlanExecutionException {
        try {
            return this.mToolsInterface.shouldSpecifyUserToRunAs(inUser);
        }
        catch (InvalidUserGroupException ex) {
            throw new PlanExecutionPreflightWarning(ex);
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
    }
}

