/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.virtual;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.PatternMismatchException;
import com.raplix.rolloutexpress.command.exceptions.URLAccessException;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.rolloutexpress.command.rpcinterfaces.ExecJavaStepDescriptor;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.event.ROXResourceEvent;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.PlanExecutionDeploymentWarning;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanRecorder;
import com.raplix.rolloutexpress.executor.ResourceEventData;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotPurgeData;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotSet;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.ExecNativeStepDescriptor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentCreationException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.plugin.ExecutionException;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotStatus;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.util.logger.Logger;

public class RealAgent
extends VirtualAgentBase {
    public RealAgent(Application inApp, HostData inHostData, Target inTarget, BagID inCurrentBagID) throws VirtualAgentCreationException {
        super(inApp, inHostData, inTarget, inCurrentBagID);
    }

    public void handlePause(long inDelayMillis) throws InterruptedException {
        Thread.currentThread();
        Thread.sleep(inDelayMillis);
    }

    public RunLevel getRunLevel() {
        return RunLevel.ACTUAL;
    }

    public ExecNativeOutput execNative(ExecNativeStepDescriptor inDescriptor) throws PlanExecutionException {
        try {
            if (inDescriptor.getBackground() && this.getHostData().getHostID().getPhysicalHost().getMachineInfo().getRAPlatform().isWin32()) {
                throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_BKG_WIN_UNSUPPORTED", inDescriptor.getCommandStringForErrMsg()));
            }
            return (ExecNativeOutput)this.mNativeInterface.execNative(inDescriptor);
        }
        catch (PersistenceManagerException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(ex);
        }
        catch (CommandExecutionErrorException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_EXEC_NATIVE_CMD", (Throwable)ex, inDescriptor.getCommandStringForErrMsg());
        }
    }

    public void checkProcess(String inProcName, String inUserName, int inDelaySecs, int inTimeoutSecs) throws PlanExecutionException {
        try {
            boolean success = this.mNativeInterface.checkProcess(inProcName, inUserName, inDelaySecs, inTimeoutSecs);
            if (!success) {
                throw new PlanExecutionException("pe.ERR_NO_PROCS_FOUND", inProcName);
            }
        }
        catch (CommandExecutionErrorException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_LISTING_PROCS", (Throwable)ex, inProcName);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_LISTING_PROCS", (Throwable)ex, inProcName);
        }
    }

    public void sendCustomUserEvent(ExecutionState inState, StepInfo inStepInfo, String inMessage) {
        inState.getPlanRecorder().sendEvent(inState.getPlanRecorder().createCustomEvent(inMessage, inStepInfo, inState.getCompiledSubplan().getSubplanIndex()));
    }

    public void sendControlServiceEvent(PlanRecorder inRecorder, InstalledComponentID inInstalledCompID, String inControlServiceName) {
        inRecorder.sendEvent(inRecorder.createCCSE(inInstalledCompID, inControlServiceName, false));
    }

    public void checkURL(String inURL, String inSafeURL, String inPattern, int inDelaySecs, int inTimeoutSecs) throws PatternMismatchException, URLAccessException, RPCException {
        this.mToolsInterface.checkURL(inURL, inSafeURL, inPattern, inDelaySecs, inTimeoutSecs);
    }

    public void transformFile(Transformation inTransformation) throws PlanExecutionException {
        try {
            this.mFileOpsInterface.transformFile(inTransformation);
        }
        catch (CommandExecutionErrorException ce) {
            throw new PlanExecutionException(ce);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
    }

    public void markComponentUninstalled(InstalledComponent inInstalledComponent, Caller inCaller, ExecutionState inState) throws PlanExecutionException {
        this.sendUninstallEvents(inInstalledComponent);
        super.markComponentUninstalled(inInstalledComponent, inCaller, inState);
    }

    public SnapshotID createSnapshotObject(ExecutionState inState, InstalledComponentID inID, String inBlockName) throws PersistenceManagerException, RPCException {
        String creatorExtendsTypeName = inState.getCaller().getDeclaredComponent().getExtendsTypeName();
        Snapshot snapshot = new Snapshot(inID, inBlockName, inState.getSnapshotInstallOrder(), creatorExtendsTypeName);
        snapshot.save();
        return snapshot.getID();
    }

    public void setSnapshotInstalled(SnapshotID inSnapshotID) throws PlanExecutionException, RPCException {
        try {
            Snapshot snp = inSnapshotID.getByIDQuery().select();
            snp.setStatus(SnapshotStatus.INSTALLED);
            snp.save();
        }
        catch (PersistenceManagerException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), e, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_CREATE_SNAPSHOT"), (Throwable)e);
        }
    }

    public InstalledResource createInstalledResource(ExecutionState inState, InstalledComponentID inInstalledCompID, ResourceID inRsrcID, String inPath) throws InstallDBException {
        return inState.getInstallDB().createInstalledResource(inInstalledCompID, inRsrcID, inPath);
    }

    protected void doReboot() throws PlanExecutionException {
        try {
            this.mNativeInterface.reboot();
        }
        catch (CommandExecutionErrorException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_REBOOT", (Throwable)ex);
        }
    }

    protected boolean doIsRebootPending() throws PlanExecutionException {
        try {
            return this.mNativeInterface.isRebootPending();
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_REBOOT_PENDING", (Throwable)ex);
        }
    }

    public void installDeployedResources(ResourceEventData inEventData, ResourceDefinition[] inAllRsrc, InstalledResource[] inInstalledResources, PushID inPushID) throws PlanExecutionException {
        try {
            if (inAllRsrc.length > 1) {
                throw new PlanExecutionException("pe.MULTIPLE_DEPLOYED_RESOURCES_TO_INSTALL");
            }
            if (inAllRsrc.length == 1) {
                this.mFileOpsInterface.installDeployedResources(inEventData, inAllRsrc, inInstalledResources, inPushID);
                this.mNotificationMgr.notify(ROXResourceEvent.install(inInstalledResources[0], false), true);
            }
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public void uninstallDeployedFiles(String[][] inPathsToDelete) throws PlanExecutionException {
        try {
            this.mFileOpsInterface.uninstallDeployedFiles(inPathsToDelete);
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public void deleteFiles(String[] inPathsToDelete) throws PlanExecutionException {
        try {
            this.mFileOpsInterface.deleteFiles(inPathsToDelete);
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public void doSnapshot(SnapshotSet inSnapshotSet) throws PlanExecutionException {
        try {
            SnapshotPurgeData purgeData = this.mApp.getPlanSubsystem().createSnapshotPurgeDataForHost(this.getTarget().getPhysicalHostID());
            this.mSnapshotServices.snapshot(purgeData, inSnapshotSet);
            inSnapshotSet.getSnapshotID().addVisitedHostMS(this.getTarget().getPhysicalHostID());
        }
        catch (CommandExecutionErrorException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_CREATE_SNAPSHOT"), (Throwable)ex);
        }
        catch (UnsupportedSubsystemException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), e, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_CREATE_SNAPSHOT"), (Throwable)e);
        }
        catch (PersistenceManagerException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), e, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_CREATE_SNAPSHOT"), (Throwable)e);
        }
    }

    public void purgeSnapshots() throws PlanExecutionException {
        try {
            SnapshotPurgeData purgeData = this.mApp.getPlanSubsystem().createSnapshotPurgeDataForHost(this.getTarget().getPhysicalHostID());
            this.mSnapshotServices.purgeSnapshots(purgeData);
        }
        catch (CommandExecutionErrorException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), ex, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_REMOVE_SNAPSHOT"), (Throwable)ex);
        }
        catch (UnsupportedSubsystemException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), e, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_REMOVE_SNAPSHOT"), (Throwable)e);
        }
        catch (PersistenceManagerException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_MISC"), e, this);
            }
            throw new PlanExecutionException(new ROXMessage("pe.ERR_REMOVE_SNAPSHOT"), (Throwable)e);
        }
    }

    public boolean shouldSpecifyUserToRunAs(String inUser) throws PlanExecutionException {
        try {
            return this.mToolsInterface.shouldSpecifyUserToRunAs(inUser);
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    private void sendUninstallEvents(InstalledComponent inInstalledComp) throws PlanExecutionException {
        InstalledResource[] theInstalledResources = null;
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Sending unisntall events for " + inInstalledComp.getComponentID().getByIDQuery().selectSummaryView().getName(), this);
            }
            theInstalledResources = this.mInstallDB.queryResourcesInstalledBy(inInstalledComp.getID());
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
        for (int i = 0; i < theInstalledResources.length; ++i) {
            this.mNotificationMgr.notify(ROXResourceEvent.uninstall(theInstalledResources[i], false));
        }
    }

    public ExecNativeOutput execJava(ExecutionState inState, ExecJavaStepDescriptor inJavaDescriptor) throws PlanExecutionException {
        inJavaDescriptor.setRunLevel(this.getRunLevel());
        ExecNativeOutput output = null;
        try {
            output = this.mToolsInterface.execJava(inJavaDescriptor);
            if (output != null) {
                inState.getPlanRecorder().saveExecNativeOutput(output);
                if (output.getStepFailed() != null) {
                    output.getStepFailed().fillInStackTrace();
                    throw output.getStepFailed();
                }
            }
        }
        catch (ExecutionException ee) {
            if (Severity.ERROR.equals(ee.getSeverity())) {
                throw new PlanExecutionException(ee);
            }
            if (Severity.WARN.equals(ee.getSeverity())) {
                throw new PlanExecutionDeploymentWarning(ee);
            }
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("pe.NON_ERROR_PLUGIN_EXCEPTION"), ee, this);
            }
        }
        catch (CommandExecutionErrorException ce) {
            throw new PlanExecutionException(ce);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
        catch (PersistenceManagerException pme) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("pe.ERR_SAVE_OUTPUT", new Object[]{output}), pme, this);
            }
            throw new PlanExecutionException(pme);
        }
        return output;
    }
}

