/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.virtual;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.CommandUtil;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.exceptions.PatternMismatchException;
import com.raplix.rolloutexpress.command.exceptions.URLAccessException;
import com.raplix.rolloutexpress.command.rpcinterfaces.ExecJavaStepDescriptor;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.StickyInterface;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionPreflightWarning;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotSet;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentCreationException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.plugin.ClassLoadingException;
import com.raplix.rolloutexpress.plugin.ExecutionException;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.util.logger.Logger;
import java.net.URL;

public abstract class PreflightAgentBase
extends VirtualAgentBase {
    public PreflightAgentBase(Application inApp, HostData inHostData, Target inTarget, BagID inCurrentBagID) throws VirtualAgentCreationException {
        super(inApp, inHostData, inTarget, inCurrentBagID);
    }

    public final RunLevel getRunLevel() {
        return RunLevel.PREFLIGHT;
    }

    public final void handlePause(long inDelayMillis) throws InterruptedException {
        if (this.mPlanSubsystem.getPauseDuringPreflight()) {
            Thread.currentThread();
            Thread.sleep(inDelayMillis);
        }
    }

    public final void checkProcess(String inProcName, String inUserName, int inDelaySecs, int inTimeoutSecs) throws PlanExecutionException {
        if (inProcName == null || inProcName.length() == 0) {
            throw new PlanExecutionException("pe.ERR_CHK_EMPTY_PROC");
        }
        try {
            CommandUtil.createRegEx(inProcName);
            CommandUtil.createRegEx(inUserName);
        }
        catch (PatternMismatchException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public final void checkURL(String inURL, String inSafeURL, String inPattern, int inDelaySecs, int inTimeoutSecs) throws PatternMismatchException, URLAccessException {
        if (inURL == null || inPattern == null) {
            throw new PatternMismatchException("pe.ERR_INVALID_URL_STEP_PARAMS");
        }
        try {
            new URL(inURL);
        }
        catch (Exception e) {
            throw new URLAccessException(inSafeURL);
        }
        CommandUtil.createRegEx(inPattern);
    }

    protected void initRemoteInterfaces(Target inTarget, BagID inCurrentBagID) throws RaplixException {
        super.initRemoteInterfaces(inTarget, inCurrentBagID);
        StickyInterface stickyInterface = (StickyInterface)this.mApp.getRPCInterface(this.mHostRAAddress, StickyInterface.class);
        this.mPlanSubsystem.removeStaleResources(stickyInterface);
    }

    protected void doReboot() throws PlanExecutionException {
    }

    protected boolean doIsRebootPending() throws PlanExecutionException {
        return false;
    }

    public final SnapshotID createSnapshotObject(ExecutionState inState, InstalledComponentID inID, String inBlockName) {
        return SnapshotID.generateID();
    }

    public final void setSnapshotInstalled(SnapshotID inSnapshotID) {
    }

    public final InstalledResource createInstalledResource(ExecutionState inState, InstalledComponentID inInstalledCompID, ResourceID inRsrcID, String inPath) {
        return inState.getInstallDB().createTempInstalledResource(inInstalledCompID, inRsrcID, inPath);
    }

    public final void purgeSnapshots() {
    }

    public final ExecNativeOutput execJava(ExecutionState inState, ExecJavaStepDescriptor inJavaDescriptor) throws PlanExecutionException {
        ExecNativeOutput eno = null;
        try {
            inJavaDescriptor.setRunLevel(this.getRunLevel());
            eno = this.mToolsInterface.execJava(inJavaDescriptor);
        }
        catch (ExecutionException ee) {
            if (Severity.ERROR.equals(ee.getSeverity())) {
                throw new PlanExecutionException(ee);
            }
            if (Severity.WARN.equals(ee.getSeverity())) {
                throw new PlanExecutionPreflightWarning(ee);
            }
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(ROXMessageManager.messageAsString("pe.NON_ERROR_EXCEPTION"), ee, this);
            }
        }
        catch (ClassLoadingException cle) {
            throw new PlanExecutionPreflightWarning(cle);
        }
        catch (CommandExecutionErrorException ce) {
            throw new PlanExecutionException(ce);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
        return eno;
    }

    public void doSnapshot(SnapshotSet inSnapshotSet) throws PlanExecutionException {
    }
}

