/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanExecutionDeploymentWarning;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.RemoveSnapshotStep;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.UninstallBlock;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.rolloutexpress.systemmodel.plandb.UninstallStep;
import com.raplix.util.logger.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class UninstallTaskExecutor
extends RetargetingTaskExecutorBase {
    private String mCompName;
    private String mBlockName;
    private boolean mIsInternalTarget;

    public UninstallTaskExecutor(Application inApp, UninstallStep inStep) {
        super(inApp, inStep);
        this.mCompName = ((Object)this.getInstalledCompTargeter(inStep)).toString();
        this.mBlockName = inStep.getBlockName();
    }

    protected InstalledComponentTargeter getInstalledCompTargeter(ExecStep inStep) {
        UninstallStep theStep = (UninstallStep)inStep;
        return theStep.getTargeter();
    }

    protected RepoTarget[] getRepoComponentTargets(ExecStep inGeneratedStep, ExecutionState inState) throws RPCException, PlanExecutionException {
        List<RepoTarget> targets = Arrays.asList(super.getRepoComponentTargets(inGeneratedStep, inState));
        Collections.reverse(targets);
        return targets.toArray(new RepoTarget[targets.size()]);
    }

    protected void doRetargetedAction(RepoTarget inTarget, VirtualAgent inVirtualAgent, ExecutionState inState, ExecStep inGeneratedStep, StepInfo inCurrentStep) throws PlanExecutionException, InterruptedException, RPCException {
        UninstallStep theStepToUse = (UninstallStep)inGeneratedStep;
        InstalledTarget theTarget = (InstalledTarget)inTarget;
        this.mIsInternalTarget = theStepToUse.getTargeter().isInternalTarget();
        InstalledComponent theInstalledComp = theTarget.getInstalledComponent();
        RemoveSnapshotStep[] removeSnapshotData = null;
        if (!this.mIsInternalTarget) {
            this.verifyCompTarget(theInstalledComp, inVirtualAgent, "pe.ERR_COMP_UNINST_DIFF_TARGET");
            removeSnapshotData = this.collectRemoveSnapshotData(inState, this, theInstalledComp);
        }
        Component theComponent = this.getComponentByComponentID(theInstalledComp.getComponentID());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Uninstalling comp " + theComponent.getName(), this);
        }
        UninstallBlock uninstallBlock = theComponent.resolveUninstallBlock(this.mBlockName, theTarget.getCallSpec());
        if (theStepToUse.getAssignTo() != null && !uninstallBlock.getReturns()) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_UNINSTALL_DOES_NOT_RETURN_VALUE", this.mBlockName, theComponent.getName()));
        }
        if (uninstallBlock == null) {
            throw new PlanExecutionException(new ROXMessage("pe.NAMED_BLOCK_DNE", this.mBlockName, ExecStep.getStepTypeStringRepresentation(this.getStepType()), theComponent.getName()));
        }
        Caller nextCaller = theTarget.getCallerForMember(uninstallBlock);
        ConfigGenerator newCG = UninstallTaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, theStepToUse.getArgs(), uninstallBlock, theInstalledComp, TargetType.CURRENT, false, nextCaller);
        ConfigGenerator passwdSafeCG = null;
        if (inState.getCurrPasswdSafeConfigGenerator() != null) {
            passwdSafeCG = UninstallTaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, ((UninstallStep)this.generateStepPasswdSafe(inState)).getArgs(), uninstallBlock, theInstalledComp, TargetType.CURRENT, true, nextCaller);
        }
        this.verifyUninstallDependencies(theInstalledComp, inState, uninstallBlock, inCurrentStep, inVirtualAgent, newCG, passwdSafeCG, nextCaller);
        ExecStep[] ownUninstallSteps = uninstallBlock.getExecSteps();
        ReturnStep returnStep = MultiStepExecutor.execMultiStepsInCurrentComponent(inCurrentStep, ownUninstallSteps, inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null), theInstalledComp, newCG, passwdSafeCG, nextCaller);
        this.processReturnStep(theStepToUse, returnStep, inState);
        if (!this.mIsInternalTarget) {
            inVirtualAgent.markComponentUninstalled(theInstalledComp, inState.getCaller(), inState);
            try {
                if (theInstalledComp.getID() != null && removeSnapshotData != null) {
                    this.removeSnapshot(inCurrentStep, inState, 0, inVirtualAgent, theInstalledComp, removeSnapshotData);
                }
            }
            catch (PersistenceManagerException pme) {
                throw new PlanExecutionDeploymentWarning(new ROXMessage("pe.ERR_REMOVE_SNAPSHOT"), (Throwable)pme);
            }
        }
    }

    private void verifyUninstallDependencies(InstalledComponent inInstalledComp, ExecutionState inState, UninstallBlock inUninstallBlock, StepInfo inCurInfo, VirtualAgent inVA, ConfigGenerator inCG, ConfigGenerator inPasswdCG, Caller inNewCaller) throws PlanExecutionException, RPCException, InterruptedException {
        ExecStep[] dependantCleanupSteps = inUninstallBlock.getDependantCleanupSteps();
        MultiStepExecutor.execMultiStepsInCurrentComponent(inCurInfo, dependantCleanupSteps, inState, 0, inVA, this.getTaskExecutorFactory(null), inInstalledComp, inCG, inPasswdCG, inNewCaller);
        if (!this.mIsInternalTarget) {
            try {
                inState.getTaskInfo().getInstallDBContext().canUninstallComponent(inInstalledComp, inState.getCurrPlanTargetedCtx(), inState.getCaller());
            }
            catch (PersistenceManagerException ex) {
                throw new PlanExecutionException(ex);
            }
            catch (InstallDBException ex) {
                throw new PlanExecutionException(ex);
            }
        }
    }

    public String toString() {
        return new ROXMessage("pe.step.UNINSTALL", this.mCompName, this.mBlockName).toString();
    }
}

