/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionPreflightWarning;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.ResourceTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.ResourceParser;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.UndeployResourceStep;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import java.util.Vector;

public class UndeployAllResourcesTaskExecutor
extends ResourceTaskExecutorBase {
    public UndeployAllResourcesTaskExecutor(Application inApp, UndeployResourceStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, RPCException, InterruptedException {
        try {
            InstalledComponent theInstalledComp = inState.getCurrInstalledComponent();
            if (theInstalledComp == null) {
                throw new PlanExecutionException("pe.NO_COMP_TO_UNDEPLOY");
            }
            Component theComponent = this.getComponentByComponentID(theInstalledComp.getComponentID());
            ComponentConfigManager theConfigManager = inState.getConfigGenMgr().getConfigGenerator().newComponentManager(theInstalledComp.getVariableSettingsID());
            RsrcInfo[] allRsrcInfos = this.getComponentRsrcInfos(theComponent);
            int nRsrc = allRsrcInfos.length;
            ResourceDefinition[] theResourceDefs = new ResourceDefinition[]{theComponent.getResourceInstallSpec()};
            this.configGenResourceDefs(theResourceDefs, theConfigManager, theComponent, inVirtualAgent, inState);
            Vector<String[]> pathsToDelete = new Vector<String[]>();
            for (int i = nRsrc - 1; i >= 0; --i) {
                if (allRsrcInfos[i].getHierarchical()) {
                    if (theResourceDefs[i].getDeployMode().equals(DeployMode.ADD_TO)) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("starting ADD_TO for " + allRsrcInfos[i].getName(), this);
                        }
                        this.extractAddedResourcePaths(theResourceDefs[i], allRsrcInfos[i], pathsToDelete, inState.getResourceSubsystem());
                        continue;
                    }
                    pathsToDelete.add(new String[]{theResourceDefs[i].getRAFullTargetPath(), ""});
                    continue;
                }
                pathsToDelete.add(new String[]{theResourceDefs[i].getRAFullTargetPath(), ""});
            }
            if (pathsToDelete.size() > 0) {
                String[][] allPathsToDelete = (String[][])pathsToDelete.toArray((T[])new String[pathsToDelete.size()][2]);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("deleting directories: " + Util.getStringFromArray(allPathsToDelete[0], ","), this);
                }
                inVirtualAgent.uninstallDeployedFiles(allPathsToDelete);
            }
        }
        catch (PlanExecutionPreflightWarning pew) {
            throw pew;
        }
        catch (PlanExecutionException pex) {
            throw pex;
        }
        catch (RaplixException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ex.getMessage(), ex, this);
            }
            throw new PlanExecutionException(ex);
        }
    }

    public String toString() {
        return new ROXMessage("pe.step.UNDEPLOY_RSRC", this.mCompName).toString();
    }

    protected void extractAddedResourcePaths(final ResourceDefinition inRsrcDef, final RsrcInfo inInfo, final Vector inPathsToDelete, ResourceSubsystem inRsrcMgr) throws ResourceException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("examining " + inInfo.getName() + " with RAFullTargetPath: " + inRsrcDef.getRAFullTargetPath(), this);
        }
        new ResourceAccessor(inRsrcMgr){

            public Object innerAccess() throws ResourceException {
                RsrcManifest theManifest = this.getManifest(inInfo.getResourceID(), null);
                ResourceEntryIterator theIter = theManifest.getEntryIterator();
                while (theIter.hasNext()) {
                    ResourceEntry theEntry = theIter.next();
                    if (!theEntry.getType().equals(SubnodeType.FILE)) continue;
                    String theRelPath = theEntry.getRelPathWFwdSlashes();
                    theRelPath = ResourceParser.stripRoot(theRelPath);
                    inPathsToDelete.add(new String[]{inRsrcDef.getRAFullTargetPath(), theRelPath});
                    if (!Logger.isDebugEnabled(this)) continue;
                    Logger.debug("adding inner file: {" + inRsrcDef.getRAFullTargetPath() + "," + theRelPath + "}", this);
                }
                return null;
            }
        }.access();
    }
}

