/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.exceptions.PatternMismatchException;
import com.raplix.rolloutexpress.command.exceptions.URLAccessException;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.URLTestStep;
import com.raplix.util.logger.Logger;

public class URLTestTaskExecutor
extends TaskExecutor {
    public URLTestTaskExecutor(Application inApp, URLTestStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, RPCException {
        URLTestStep theStepToUse = (URLTestStep)inGeneratedStep;
        URLTestStep theSafeStep = (URLTestStep)this.generateStepPasswdSafe(inState);
        String url = theStepToUse.getURL();
        String safeURL = theSafeStep.getURL();
        int delaySeconds = theStepToUse.getDelaySecs();
        int timeout = theStepToUse.getTimeoutSecs();
        String pattern = theStepToUse.getPattern();
        try {
            inVirtualAgent.checkURL(url, safeURL, pattern, delaySeconds, timeout);
        }
        catch (PatternMismatchException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("No pattern " + pattern + " found at url " + safeURL, ex, this);
            }
            throw new PlanExecutionException("pe.ERR_URL_PATTERN_MATCH", (Throwable)ex, new Object[]{pattern, safeURL});
        }
        catch (URLAccessException ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error accessing url " + safeURL, ex, this);
            }
            throw new PlanExecutionException("pe.ERR_URL_ACCESS", (Throwable)ex, safeURL);
        }
    }

    public String toString() {
        URLTestStep theStepToUse = (URLTestStep)this.getOriginalStep();
        ROXMessage msg = new ROXMessage("pe.step.URL_TEST", new String[]{theStepToUse.getURL()});
        return msg.toString();
    }
}

