/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanAbortException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanRecorder;
import com.raplix.rolloutexpress.executor.PlanTimeoutException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.DynamicContainerStep;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.task.TryCatchRecorder;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TryStep;

public class TryTaskExecutor
extends TaskExecutor {
    private PlanRecorder mTryCatchRecorder;
    private PlanRecorder mOrigRecorder;

    public TryTaskExecutor(Application inApp, TryStep inStep) {
        super(inApp, inStep);
    }

    private void exec(StepInfo inCurrentStep, ExecStep[] children, ROXMessage message, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        if (children == null) {
            return;
        }
        this.setReturnStep(MultiStepExecutor.execMultiSteps(inCurrentStep, new ExecStep[]{new DynamicContainerStep(children, message)}, inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        TryStep step = (TryStep)inGeneratedStep;
        boolean runFinally = true;
        try {
            try {
                this.substituteRecorder(inState);
                try {
                    this.exec(inCurrentStep, step.getTrySteps(), new ROXMessage("pe.step.TRY_STEPS"), inState, inVirtualAgent);
                }
                finally {
                    this.resetRecorder(inState);
                }
                this.sendQueuedEvents();
            }
            catch (PlanAbortException pae) {
                runFinally = false;
                throw pae;
            }
            catch (PlanTimeoutException pte) {
                runFinally = false;
                throw pte;
            }
            catch (InterruptedException iex) {
                runFinally = false;
                throw iex;
            }
            catch (PlanExecutionException pex) {
                ExecStep[] children = step.getCatchSteps();
                if (children == null) {
                    this.setHandledBitOnFailedEvents(false);
                    throw pex;
                }
                this.setHandledBitOnFailedEvents(true);
                try {
                    this.exec(inCurrentStep, children, new ROXMessage("pe.step.TRY_CATCH"), inState, inVirtualAgent);
                }
                catch (PlanAbortException pae) {
                    runFinally = false;
                    throw pae;
                }
                catch (PlanTimeoutException pte) {
                    runFinally = false;
                    throw pte;
                }
                catch (InterruptedException iex) {
                    runFinally = false;
                    throw iex;
                }
                Object var11_13 = null;
                if (!runFinally) return;
                this.exec(inCurrentStep, step.getFinallySteps(), new ROXMessage("pe.step.TRY_FINALLY"), inState, inVirtualAgent);
                return;
            }
            Object var11_12 = null;
            if (!runFinally) return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!runFinally) throw throwable;
            this.exec(inCurrentStep, step.getFinallySteps(), new ROXMessage("pe.step.TRY_FINALLY"), inState, inVirtualAgent);
            throw throwable;
        }
        this.exec(inCurrentStep, step.getFinallySteps(), new ROXMessage("pe.step.TRY_FINALLY"), inState, inVirtualAgent);
    }

    private void substituteRecorder(ExecutionState inState) {
        this.mOrigRecorder = inState.getPlanRecorder();
        this.mTryCatchRecorder = inState.getTaskInfo().getIsNonPlanTaskInfo() ? this.mOrigRecorder : new TryCatchRecorder(inState, inState.getTaskInfo());
        inState.setPlanRecorder(this.mTryCatchRecorder);
    }

    private void resetRecorder(ExecutionState inState) {
        inState.setPlanRecorder(this.mOrigRecorder);
    }

    private void setHandledBitOnFailedEvents(boolean inFlag) {
        if (this.mTryCatchRecorder instanceof TryCatchRecorder) {
            ((TryCatchRecorder)this.mTryCatchRecorder).setHandledBitOnQueuedEvents(inFlag);
        }
        this.sendQueuedEvents();
    }

    private void sendQueuedEvents() {
        if (this.mTryCatchRecorder instanceof TryCatchRecorder) {
            ((TryCatchRecorder)this.mTryCatchRecorder).sendQueuedEvents();
        }
    }

    public String toString() {
        return new ROXMessage("pe.step.TRY").toString();
    }
}

