/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.executor.BasicPlanRecorder;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.util.logger.Logger;
import java.util.Iterator;
import java.util.Vector;

public class TryCatchRecorder
extends BasicPlanRecorder {
    private Vector mEvents = new Vector();

    public TryCatchRecorder(ExecutionState inState, TaskInfo inTaskInfo) {
        super(inState, inTaskInfo);
    }

    public void sendEvent(ROXEvent inEvent, boolean inSynchronous) {
        if (inEvent instanceof ROXStepFailedEvent || inEvent instanceof ROXStepCompleteEvent) {
            this.mEvents.add(inEvent);
        } else {
            super.sendEvent(inEvent, inSynchronous);
        }
    }

    public void setHandledBitOnQueuedEvents(boolean inHandledBit) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Setting the handled bit to " + inHandledBit + " on nEvents: " + this.mEvents.size(), this);
        }
        Iterator iter = this.mEvents.iterator();
        while (iter.hasNext()) {
            ROXEvent event = (ROXEvent)iter.next();
            if (!(event instanceof ROXStepFailedEvent)) continue;
            ROXStepFailedEvent failed = (ROXStepFailedEvent)event;
            if (!inHandledBit) continue;
            failed.setHandled(inHandledBit);
        }
    }

    public void sendQueuedEvents() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Resending " + this.mEvents.size() + " events", this);
        }
        Iterator iter = this.mEvents.iterator();
        while (iter.hasNext()) {
            ROXEvent e = (ROXEvent)iter.next();
            super.sendEvent(e, false);
        }
        this.mEvents.clear();
    }
}

