/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.impl.Transformation;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TransformStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TransformType;

public class TransformTaskExecutor
extends TaskExecutor
implements PlanExecutorMessages {
    public TransformTaskExecutor(Application inApplication, TransformStep inStep) {
        super(inApplication, inStep);
    }

    protected void doTask(StepInfo currentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws RPCException, PlanExecutionException {
        this.executeTransform((TransformStep)inGeneratedStep, inVirtualAgent);
    }

    private void executeTransform(TransformStep step, VirtualAgent inVirtualAgent) throws PlanExecutionException {
        Transformation transform = null;
        String inputFile = step.getInputFile();
        String outputFile = step.getOutputFile();
        if (inputFile == null) {
            inputFile = outputFile;
        }
        if (step.getTransformType().equals(TransformType.PERL)) {
            transform = step.getSourceFile() == null ? Transformation.perlTransform(step.getPerlTransforms(), inputFile, outputFile) : Transformation.perlTransform(step.getSourceFile(), inputFile, outputFile);
        } else if (step.getTransformType().equals(TransformType.XSLT)) {
            transform = step.getSourceFile() == null ? Transformation.xslTransform(step.getXSLTTransform(), inputFile, outputFile) : Transformation.xslFileTransform(step.getSourceFile(), inputFile, outputFile);
        } else if (step.getTransformType().equals(TransformType.COPY)) {
            transform = Transformation.copyTransform(inputFile, outputFile);
        } else {
            throw new PlanExecutionException(new ROXMessage("pe.TRANSFORM_UNKNOWN", step.getTransformType().toString()));
        }
        inVirtualAgent.transformFile(transform);
    }

    public String toString() {
        String fileName = ((TransformStep)this.getOriginalStep()).getInputFile();
        if (fileName == null) {
            fileName = ((TransformStep)this.getOriginalStep()).getOutputFile();
        }
        return ROXMessageManager.messageAsString("pe.step.TRANSFORM", new String[]{fileName});
    }
}

