/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepAbortEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanAbortException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionWarning;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanTimeoutException;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.HostResolver;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.RegularFactory;
import com.raplix.rolloutexpress.executor.task.RemoveSnapshotStep;
import com.raplix.rolloutexpress.executor.task.TaskExecutorFactory;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallScopeBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.plandb.AssigningStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.IOException;

public abstract class TaskExecutor
implements PlanExecutorMessages {
    protected Application mApp;
    protected ExecStep mOrigStep;
    private ReturnStep mReturnStep;

    protected TaskExecutor(Application inApp, ExecStep inOrigStep) {
        this.mApp = inApp;
        this.mOrigStep = inOrigStep;
    }

    public final void execute(ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException {
        this.execute(inState, inVirtualAgent, null, null);
    }

    public final void execute(ExecutionState inState, VirtualAgent inVirtualAgent, StepInfo inParentStep, StepInfo inCurrentStep) throws PlanExecutionException {
        block32: {
            this.initInternalData(inState);
            StepInfo currentStep = this.createStepInfoIfNeeded(inCurrentStep, inParentStep, inState, inVirtualAgent);
            this.sendStepStartEvent(inState, currentStep);
            PlanExecutionException e = null;
            boolean isWarning = false;
            try {
                block31: {
                    try {
                        if (!this.beforeTask()) break block31;
                        inState.getPER().performTestflow();
                        this.doTask(currentStep, this.generateStep(inState), inState, inVirtualAgent);
                        if (currentStep.getChildSeverity() == 3) {
                            this.sendStepFailedEvent(inState, currentStep, currentStep.getChildException(), currentStep.getChildSeverity() == 3);
                        }
                        if (null != inParentStep && !currentStep.getMappable()) {
                            inParentStep.setChildSeverity(currentStep.getChildSeverity(), currentStep.getChildException());
                        }
                        this.afterTask();
                    }
                    catch (PlanExecutionWarning pew) {
                        if (pew.getIsInterrupted()) {
                            e = inState.getTaskInfo().getTaskWasAborted() ? new PlanAbortException(pew) : new PlanTimeoutException(this.getTimeoutMessage(), (Throwable)pew);
                            isWarning = false;
                            throw e;
                        }
                        e = pew;
                        isWarning = true;
                        if (null != inParentStep && !currentStep.getMappable()) {
                            inParentStep.setChildSeverity(3, pew);
                        }
                        Object var11_9 = null;
                        if (null != e && !inState.getTaskInfo().getTaskWasAborted()) {
                            this.sendStepFailedEvent(inState, currentStep, e, isWarning);
                        }
                        if (inState.getTaskInfo().getTaskWasAborted()) {
                            this.sendStepAbortEvent(inState, currentStep);
                        } else {
                            this.sendStepCompleteEvent(inState, currentStep);
                        }
                        break block32;
                    }
                    catch (PlanAbortException pax) {
                        e = pax;
                        isWarning = false;
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(pax.getMessage(), pax, this);
                        }
                        throw pax;
                    }
                    catch (PlanTimeoutException ptx) {
                        e = ptx;
                        isWarning = false;
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(ptx.getMessage(), ptx, this);
                        }
                        throw ptx;
                    }
                    catch (InterruptedException iex) {
                        e = inState.getTaskInfo().getTaskWasAborted() ? new PlanAbortException(iex) : new PlanTimeoutException(this.getTimeoutMessage(), (Throwable)iex);
                        isWarning = false;
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(e.getMessage(), e, this);
                        }
                        throw e;
                    }
                    catch (PlanExecutionException pex) {
                        isWarning = false;
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(pex.getMessage(), pex, this);
                        }
                        if (pex.getIsInterrupted()) {
                            e = inState.getTaskInfo().getTaskWasAborted() ? new PlanAbortException(pex) : new PlanTimeoutException(this.getTimeoutMessage(), (Throwable)pex);
                        } else {
                            e = pex;
                            if (null != inParentStep && !currentStep.getMappable()) {
                                inParentStep.setChildSeverity(4, pex);
                            }
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error: ", t, this);
                        }
                        PlanExecutionException pex = new PlanExecutionException(t);
                        if (null != inParentStep && !currentStep.getMappable()) {
                            inParentStep.setChildSeverity(4, pex);
                        }
                        e = pex;
                        isWarning = false;
                        throw pex;
                    }
                }
                Object var11_8 = null;
                if (null != e && !inState.getTaskInfo().getTaskWasAborted()) {
                    this.sendStepFailedEvent(inState, currentStep, e, isWarning);
                }
                if (inState.getTaskInfo().getTaskWasAborted()) {
                    this.sendStepAbortEvent(inState, currentStep);
                } else {
                    this.sendStepCompleteEvent(inState, currentStep);
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (null != e && !inState.getTaskInfo().getTaskWasAborted()) {
                    this.sendStepFailedEvent(inState, currentStep, e, isWarning);
                }
                if (inState.getTaskInfo().getTaskWasAborted()) {
                    this.sendStepAbortEvent(inState, currentStep);
                } else {
                    this.sendStepCompleteEvent(inState, currentStep);
                }
                throw throwable;
            }
        }
    }

    protected abstract void doTask(StepInfo var1, ExecStep var2, ExecutionState var3, VirtualAgent var4) throws PlanExecutionException, InterruptedException, RPCException;

    protected int getStepType() {
        return this.getOriginalStep().getStepType();
    }

    public TaskExecutorFactory getTaskExecutorFactory(TaskExecutorFactory inFactory) {
        return new RegularFactory();
    }

    public abstract String toString();

    public ExecStep getOriginalStep() {
        return this.mOrigStep;
    }

    protected void initInternalData(ExecutionState inState) {
    }

    public static boolean isPreflightRunLevel(RunLevel inRunLevel) {
        return inRunLevel.equals(RunLevel.PREFLIGHT);
    }

    protected void sendNotification(ExecutionState inState, ROXEvent inEvent) {
        inState.getPlanRecorder().sendEvent(inEvent);
    }

    protected Component getComponentFromRef(ComponentRef inRef) throws PlanExecutionException {
        Component component = null;
        try {
            component = SingleComponentQuery.byRef(inRef).select();
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException("pe.COMPONENT_VERS_NOT_FOUND_DB", (Throwable)ex, new Object[]{inRef.getComponentName(), inRef.getComponentName()});
        }
        catch (RPCException ex) {
            throw new PlanExecutionException("pe.COMPONENT_VERS_NOT_FOUND_DB", (Throwable)ex, new Object[]{inRef.getComponentName(), inRef.getComponentName()});
        }
        return component;
    }

    protected String getComponentNameByID(ComponentID inCompID) throws PlanExecutionException {
        String theName = null;
        try {
            theName = inCompID.getByIDQuery().selectSummaryView().getFullName();
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException("pe.COMPONENT_NOT_FOUND_DB", (Throwable)ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException("pe.COMPONENT_NOT_FOUND_DB", (Throwable)ex);
        }
        return theName;
    }

    protected Component getComponentByComponentID(ComponentID inCompID) throws PlanExecutionException {
        Component component = null;
        try {
            component = inCompID.getByIDQuery().select();
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException("pe.COMPONENT_NOT_FOUND_DB", (Throwable)ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException("pe.COMPONENT_NOT_FOUND_DB", (Throwable)ex);
        }
        return component;
    }

    protected RsrcInfo[] getComponentRsrcInfos(Component inComp) throws PlanExecutionException {
        RsrcInfo rsrc = inComp.getResource();
        if (rsrc == null) {
            return new RsrcInfo[0];
        }
        return new RsrcInfo[]{rsrc};
    }

    protected RemoveSnapshotStep[] collectRemoveSnapshotData(ExecutionState inState, TaskExecutor inTE, InstalledComponent inInstComp) throws RPCException, PlanExecutionException {
        if (inInstComp == null) {
            return null;
        }
        Snapshot[] snapshots = null;
        try {
            snapshots = inInstComp.getID().getSnapshotsQuery().select();
            if (snapshots == null || snapshots.length == 0) {
                return null;
            }
            RemoveSnapshotStep[] data = new RemoveSnapshotStep[snapshots.length];
            for (int i = 0; i < snapshots.length; ++i) {
                data[i] = new RemoveSnapshotStep(snapshots[i]);
            }
            return data;
        }
        catch (PersistenceManagerException e) {
            throw new PlanExecutionException(e);
        }
    }

    protected void removeSnapshot(StepInfo inStepInfo, ExecutionState inExecState, int inStepPointer, VirtualAgent inVirtualAgent, InstalledComponent inInstalledComponent, RemoveSnapshotStep[] removeSnapshotData) throws RPCException, PersistenceManagerException, PlanExecutionException, InterruptedException {
        inStepInfo.setChildrenMappable(false);
        for (int i = 0; i < removeSnapshotData.length; ++i) {
            RemoveSnapshotStep removeSnapshotStep = removeSnapshotData[i];
            String declarer = removeSnapshotStep.getSnapshot().getCreatorExtendsTypeName();
            Component actual = inInstalledComponent.getComponentID().getByIDQuery().select();
            Caller caller = declarer == null ? new Caller(inInstalledComponent, actual, actual) : new Caller(inInstalledComponent, actual, ComponentType.create(declarer).getComponent());
            MultiStepExecutor.execMultiStepsInCurrentComponent(inStepInfo, new ExecStep[]{removeSnapshotStep}, inExecState, inStepPointer, inVirtualAgent, this.getTaskExecutorFactory(null), inInstalledComponent, inExecState.getCurrConfigGenerator(), inExecState.getCurrPasswdSafeConfigGenerator(), caller);
        }
    }

    public static ConfigGenerator createCGForGivenInstalledComp(VirtualAgent inVA, ExecutionState inState, VariableSettingsSource inArgs, CallScopeBlock inBlock, InstalledComponent inInstalledComp, TargetType inLookupType, boolean hideSecureSessionVars, Caller caller) throws PlanExecutionException {
        try {
            HostID targetedHostID = inLookupType.equals(TargetType.CURRENT) ? inVA.getTarget().getCurrentHostID() : TaskExecutor.getRootHostID(inVA.getTarget().getCurrentHost(), inState.getTaskInfo().getHostResolver());
            ConfigGenerator baseConfigGen = hideSecureSessionVars ? inState.getTopLevelPassSafeSessionConfigGen() : inState.getTopLevelSessionConfigGen();
            ComponentConfigManager configMgr = TaskExecutor.createManagerForGivenInstalledComp(baseConfigGen, targetedHostID, inState, inInstalledComp);
            return TaskExecutor.createBlockCallerCG(configMgr, inBlock, inArgs, caller);
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    protected static ComponentConfigManager createManagerForGivenInstalledComp(ConfigGenerator baseConfigGen, HostID targetedHostID, ExecutionState inState, InstalledComponent inInstalledComp) throws ConfigGenException, RPCException {
        if (!targetedHostID.equals(inState.getCurrPlanTargetedCtx().getTargetHost().getID())) {
            throw new IllegalArgumentException();
        }
        return baseConfigGen.newTargetScope(inState.getCurrPlanTargetedCtx(), inState.getTaskInfo().getInstallDBContext()).newComponentManager(inInstalledComp.getVariableSettingsID());
    }

    protected static ConfigGenerator createBlockCallerCG(ComponentConfigManager baseConfigMgr, CallScopeBlock inBlock, VariableSettingsSource inArgs, Caller caller) throws ConfigGenException {
        return baseConfigMgr.newCallerScope(caller).newCallScope(inBlock.getParams(), inArgs).newUnresVarScope(inBlock.getLocalVars());
    }

    public static HostID getRootHostID(Host inChildHost, HostResolver inResolver) throws PlanExecutionException {
        Host curHost = inChildHost;
        try {
            while (curHost.getParentHostID() != null) {
                curHost = inResolver.getHost(curHost.getParentHostID());
            }
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
        return curHost.getID();
    }

    public void throwComponentLookupFailedException(InstalledComponentRef inCompRef, String inHostName) throws PlanExecutionException {
        String path = StringUtil.isEmpty(inCompRef.getInstallPath()) ? PlanExecutorMessages.ARG_NOT_AVAILABLE : inCompRef.getInstallPath();
        String vers = StringUtil.isEmpty(inCompRef.getComponentVersion()) ? PlanExecutorMessages.ARG_NOT_AVAILABLE : inCompRef.getComponentVersion();
        throw new PlanExecutionException(new ROXMessage("pe.COMPONENT_LOOKUP_FAILED", new String[]{inCompRef.getComponentName(), vers, path, inHostName}));
    }

    private void sendStepStartEvent(ExecutionState inState, StepInfo inStep) {
        ROXStepStartEvent theStepStartEvent = inState.getPlanRecorder().createSSE(inStep, inState.getCompiledSubplan().getSubplanIndex());
        inState.getPlanRecorder().setEventMessage(theStepStartEvent, this.toString());
        this.sendNotification(inState, theStepStartEvent);
    }

    private void sendStepCompleteEvent(ExecutionState inState, StepInfo inStep) {
        ROXStepCompleteEvent completeEvent = inState.getPlanRecorder().createSCE(inStep, inState.getCompiledSubplan().getSubplanIndex());
        inState.getPlanRecorder().setEventMessage(completeEvent, this.toString());
        this.sendNotification(inState, completeEvent);
    }

    private void sendStepAbortEvent(ExecutionState inState, StepInfo inStep) {
        ROXStepAbortEvent abortEvent = inState.getPlanRecorder().createSAE(inStep, inState.getCompiledSubplan().getSubplanIndex());
        inState.getPlanRecorder().setEventMessage(abortEvent, this.toString());
        this.sendNotification(inState, abortEvent);
    }

    private void sendStepFailedEvent(ExecutionState inState, StepInfo inStepInfo, CommandException ex, boolean isWarning) {
        ROXStepFailedEvent failedEvent = inState.getPlanRecorder().createSFE(inStepInfo, inState.getCompiledSubplan().getSubplanIndex(), isWarning ? 3 : 4, ex);
        this.sendNotification(inState, failedEvent);
    }

    private ExecStep generateStep(ExecutionState inState) throws PlanExecutionException {
        ExecStep stepToUse = this.getOriginalStep();
        try {
            stepToUse = stepToUse.generate(inState.getCurrConfigGenerator());
        }
        catch (ConfigGenException ex) {
            throw new PlanExecutionException(ex);
        }
        return stepToUse;
    }

    protected ExecStep generateStepPasswdSafe(ExecutionState inState) throws PlanExecutionException {
        ExecStep stepToUse = this.getOriginalStep();
        try {
            stepToUse = stepToUse.generate(inState.getCurrPasswdSafeConfigGenerator());
        }
        catch (ConfigGenException ex) {
            throw new PlanExecutionException(ex);
        }
        return stepToUse;
    }

    protected void verifyCompTarget(InstalledComponent inComp, VirtualAgent inAgent, String msgKey) throws PlanExecutionException {
        try {
            Target componentTarget = null;
            if (inComp != null && inComp.getTargetID() != null && inComp.getTargetID() != inAgent.getTargetID() && !(componentTarget = inComp.getTargetID().getByIDQuery().select()).getPhysicalHostID().equals(inAgent.getTarget().getPhysicalHostID())) {
                String virtualHost = inAgent.getTarget().getCurrentHost().getName();
                String actualOriginalHost = componentTarget.getPhysicalHost().getName();
                String compName = inComp.getComponentID().getByIDQuery().selectSummaryView().getName();
                String actualCurrentHost = inAgent.getTarget().getPhysicalHost().getName();
                throw new PlanExecutionException(new ROXMessage(msgKey, new String[]{compName, virtualHost, actualOriginalHost, actualCurrentHost}));
            }
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(rpce);
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(pme);
        }
    }

    protected ROXMessage getTimeoutMessage() {
        return new ROXMessage("pe.PLAN_TIMED_OUT_HOST");
    }

    protected boolean beforeTask() throws InterruptedException, PlanExecutionException {
        return true;
    }

    protected void afterTask() {
    }

    private StepInfo createStepInfoIfNeeded(StepInfo inCurrentStep, StepInfo inParentStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException {
        StepInfo theStep = inCurrentStep;
        if (null == theStep) {
            try {
                theStep = null == inParentStep ? inState.getPlanRecorder().createStep(inVirtualAgent.getTargetID(), inVirtualAgent.getRunLevel(), this.getOriginalStep()) : inState.getPlanRecorder().createStep(this.getOriginalStep(), inParentStep, inVirtualAgent.getTargetID());
            }
            catch (PersistenceManagerException pme) {
                throw new PlanExecutionException(pme);
            }
        }
        return theStep;
    }

    public ReturnStep getReturnStep() {
        return this.mReturnStep;
    }

    protected void setReturnStep(ReturnStep inReturnStep) {
        if (inReturnStep != null) {
            this.mReturnStep = inReturnStep;
        }
    }

    protected void processReturnStep(AssigningStep inStep, ReturnStep inReturnStep, ExecutionState inState) throws PlanExecutionException {
        if (inStep != null && inReturnStep != null) {
            this.assignNewValue(inStep.getAssignTo(), inReturnStep.getValue(), inState);
        }
    }

    protected void assignNewValue(String inVar, String inValue, ExecutionState inState) throws PlanExecutionException {
        if (inVar == null || inValue == null) {
            return;
        }
        try {
            ConfigGenerator cg = inState.getCurrConfigGenerator();
            ConfigGenerator pwcg = inState.getCurrPasswdSafeConfigGenerator();
            String value = cg.generate(inValue);
            cg.setVarValue(inVar, value);
            pwcg.setVarValue(inVar, value);
            inState.setCurrConfigGenerator(cg);
            inState.setCurrPasswdSafeConfigGenerator(pwcg);
        }
        catch (IOException e) {
            throw new PlanExecutionException(e);
        }
        catch (ConfigGenException e) {
            throw new PlanExecutionException(e);
        }
    }

    protected void verifyVarCanBeAssigned(ExecutionState inState, String inVarname) throws PlanExecutionException {
        StringBuffer var = new StringBuffer();
        var.append(":[").append(inVarname).append("]");
        try {
            ConfigGenerator cg = inState.getCurrConfigGenerator();
            ConfigGenerator pwcg = inState.getCurrPasswdSafeConfigGenerator();
            if (inVarname != null) {
                String currentValue = cg.generate(var.toString());
                cg.setVarValue(inVarname, currentValue);
                currentValue = pwcg.generate(inVarname);
                pwcg.setVarValue(inVarname, currentValue);
            }
        }
        catch (ConfigGenException e) {
            throw new PlanExecutionException(e);
        }
        catch (IOException e) {
            throw new PlanExecutionException(e);
        }
    }
}

