/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.exceptions.PathDoesNotExistException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotItemGatherer;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureFileStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureSnapshotStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.ThisTargeter;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import java.math.BigInteger;

public class SnapshotUtil {
    public static String TMP_FILE_PREFIX = "u_";
    public static String ARG_UNIQUE_FILE_PREFIX = "uniqueFilePrefix";
    private static String LOGGER_NAME = SnapshotUtil.class.getName();

    public static void doSnapshotTraversal(ExecutionState inState, Component inComp, VirtualAgent inAgent, TaskExecutor inTE, String inSnapBlockName, SnapshotItemGatherer inGatherer) throws PlanExecutionException {
        SnapshotUtil.doSnapshotTraversal(inState, inComp, inAgent.getTarget(), inTE, inSnapBlockName, inGatherer);
    }

    public static void doSnapshotTraversal(ExecutionState inState, Component inComp, Target inTarget, TaskExecutor inTE, String inSnapBlockName, SnapshotItemGatherer inGatherer) throws PlanExecutionException {
        TaskInfo taskInfo = inState.getTaskInfo();
        PlanTargetedConfigContext ctx = inState.getCurrPlanTargetedCtx();
        ConfigGenerator topCG = inState.getTopLevelSessionConfigGen();
        InstalledComponent ic = inState.getCurrInstalledComponent();
        Caller caller = inState.getCaller();
        try {
            if (Logger.isDebugEnabled(LOGGER_NAME)) {
                Logger.debug("Traversing " + inComp.getName() + " component for " + inGatherer.getName(), LOGGER_NAME);
            }
            InstalledTarget theInstalledTarget = new ThisTargeter().getInstalledTarget(ctx, caller, taskInfo.getInstallDBContext());
            SnapshotUtil.traverseSnapshotBlock(inState, taskInfo, ctx, topCG, new VariableSettingsHolder(), inComp, ic, inTarget, inTE, inSnapBlockName, inGatherer, theInstalledTarget, new TmpFileNameGenerator(ic));
        }
        catch (InstallDBException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseSnapshotBlock(ExecutionState inState, TaskInfo inTaskInfo, PlanTargetedConfigContext inTargetContext, ConfigGenerator inTopLevelSessionConfigGen, VariableSettingsSource inStepArgs, Component inComp, InstalledComponent inInstalledComp, Target inTarget, TaskExecutor inTE, String inSnapBlockName, SnapshotItemGatherer inGatherer, InstalledTarget inInstalledRetarget, TmpFileNameGenerator inTmpFileNameGen) throws ResourceException, PlanExecutionException, InstallDBException, RPCException, ConfigGenException, PersistenceManagerException {
        if (Logger.isDebugEnabled(LOGGER_NAME)) {
            Logger.debug("Gathering steps for " + inComp.getName() + ", snap: " + inSnapBlockName + " with incoming args: " + Util.getStringFromArray(inStepArgs.getVarNames(), ","), LOGGER_NAME);
        }
        SnapshotBlock snapshot = SnapshotUtil.findSnapshotBlock(inComp, inSnapBlockName, inInstalledRetarget.getCallSpec());
        if (Logger.isDebugEnabled(SnapshotUtil.class.getName())) {
            Logger.debug("Got snap with declaring comp: " + snapshot.getDeclaringComponent().getName(), SnapshotUtil.class.getName());
        }
        HostID hostID = inTarget.getCurrentHostID();
        ComponentConfigManager configMgr = TaskExecutor.createManagerForGivenInstalledComp(inTopLevelSessionConfigGen, hostID, inState, inInstalledComp);
        ConfigGenerator configGen = TaskExecutor.createBlockCallerCG(configMgr, snapshot, inStepArgs, inInstalledRetarget.getCallerForMember(snapshot));
        inGatherer.startSnapshot(snapshot, inStepArgs, inInstalledComp, inInstalledRetarget);
        try {
            ResourceDefinition rDef = inComp.getResourceInstallSpec();
            RsrcInfo rInfo = inComp.getResource();
            ExecStep[] captures = snapshot.getCaptureSteps();
            block10: for (int i = 0; i < captures.length; ++i) {
                try {
                    captures[i] = captures[i].generate(configGen);
                }
                catch (ConfigGenException ex) {
                    throw new PlanExecutionException(ex);
                }
                switch (captures[i].getStepType()) {
                    case 118: {
                        if (!inGatherer.handleCaptures()) continue block10;
                        inGatherer.handleFile((CaptureFileStep)captures[i], inTaskInfo.getHostResolver().getHost(inTarget.getPhysicalHostID()).getMachineInfo());
                        continue block10;
                    }
                    case 119: {
                        if (!inGatherer.handleCaptures()) continue block10;
                        CaptureResourceStep rsrcStep = (CaptureResourceStep)captures[i];
                        if (rInfo == null) {
                            if (Logger.isDebugEnabled(LOGGER_NAME)) {
                                Logger.debug(" didn't find resourceInfo in component", LOGGER_NAME);
                            }
                            throw new PlanExecutionException(new ROXMessage("pe.ERR_SNAPSHOT_RESOURCE_NOT_FOUND", inComp.getName(), inTarget.getCurrentHost().getName()));
                        }
                        SnapshotUtil.handleOneResourceStep(inTaskInfo, rsrcStep, configMgr, inComp, rDef, rInfo, inTarget, inGatherer);
                        continue block10;
                    }
                    case 122: {
                        CaptureSnapshotStep csStep = (CaptureSnapshotStep)captures[i];
                        InstalledComponentTargeter targeter = csStep.getTargeter();
                        Caller nextCaller = inInstalledRetarget.getCallerForMember(snapshot, inInstalledComp);
                        if (Logger.isDebugEnabled((class$com$raplix$rolloutexpress$executor$task$SnapshotUtil == null ? SnapshotUtil.class$("com.raplix.rolloutexpress.executor.task.SnapshotUtil") : class$com$raplix$rolloutexpress$executor$task$SnapshotUtil).getName())) {
                            Logger.debug("captureSnapshotStep target resolution using caller: " + nextCaller, (class$com$raplix$rolloutexpress$executor$task$SnapshotUtil == null ? SnapshotUtil.class$("com.raplix.rolloutexpress.executor.task.SnapshotUtil") : class$com$raplix$rolloutexpress$executor$task$SnapshotUtil).getName());
                        }
                        InstalledTarget[] targets = null;
                        targets = targeter.isBulkTargeter() ? targeter.getAllInstalledTargets(inTargetContext, nextCaller, inTaskInfo.getInstallDBContext()) : new InstalledTarget[]{targeter.getInstalledTarget(inTargetContext, nextCaller, inTaskInfo.getInstallDBContext())};
                        InstalledTarget installedTarget = null;
                        for (int j = 0; j < targets.length; ++j) {
                            installedTarget = targets[j];
                            SnapshotUtil.gatherStepsForInstalledComponent(inState, installedTarget, csStep.getBlockName(), csStep.getArgs(), inTaskInfo, inTargetContext, inTopLevelSessionConfigGen, inTE, inGatherer, inTmpFileNameGen);
                        }
                        continue block10;
                    }
                    default: {
                        throw new PlanExecutionException(new ROXMessage("pe.UNRECOGNIZED_STEP", captures[i].toString()));
                    }
                }
            }
        }
        finally {
            inGatherer.endSnapshot();
        }
    }

    public static SnapshotBlock findSnapshotBlock(Component inComp, String inName, CallSpec inCallSpec) throws PlanExecutionException {
        SnapshotBlock snapshotBlock = inComp.resolveSnapshotBlock(inName, inCallSpec);
        if (snapshotBlock == null) {
            throw new PlanExecutionException(new ROXMessage("pe.NAMED_BLOCK_DNE", inName, ExecStep.getStepTypeStringRepresentation(116), inComp.getName()));
        }
        return snapshotBlock;
    }

    private static void handleOneResourceStep(TaskInfo inTaskInfo, CaptureResourceStep inStep, ComponentConfigManager configMgr, Component inComp, ResourceDefinition inRDef, RsrcInfo inInfo, Target inTarget, SnapshotItemGatherer inGatherer) throws PlanExecutionException {
        ResourceDefinition generatedRDef = null;
        try {
            if (inRDef == null) {
                if (Logger.isDebugEnabled(LOGGER_NAME)) {
                    Logger.debug(" didn't find resource in component " + inInfo.getName(), LOGGER_NAME);
                }
                throw new PlanExecutionException(new ROXMessage("pe.ERR_SNAPSHOT_RESOURCE_NOT_FOUND", inComp.getName(), inTarget.getCurrentHost().getName()));
            }
            MachineInfo mi = inTaskInfo.getHostResolver().getHost(inTarget.getPhysicalHostID()).getMachineInfo();
            generatedRDef = inRDef.generate(configMgr, inComp, mi);
            inGatherer.handlePlainResource(inStep, generatedRDef);
        }
        catch (ConfigGenException cfe) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_SNAPSHOT_RESOURCE_ACCUMULATE", inInfo.getName()), (Throwable)cfe);
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_SNAPSHOT_RESOURCE_ACCUMULATE", inInfo.getName()), (Throwable)pme);
        }
        catch (PathDoesNotExistException pne) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_SNAPSHOT_RESOURCE_ACCUMULATE", inInfo.getName()), (Throwable)pne);
        }
        catch (RPCException rpce) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_SNAPSHOT_RESOURCE_ACCUMULATE", inInfo.getName()), (Throwable)rpce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gatherStepsForInstalledComponent(ExecutionState inState, InstalledTarget inInstalledTarget, String inSnapshotBlockName, VariableSettingsSource inArgs, TaskInfo inTaskInfo, PlanTargetedConfigContext inTargetContext, ConfigGenerator inTopLevelSessionConfigGen, TaskExecutor inTE, SnapshotItemGatherer inGatherer, TmpFileNameGenerator inTmpFileNameGen) throws ResourceException, PlanExecutionException, InstallDBException, RPCException, PersistenceManagerException, ConfigGenException {
        InstalledComponent installedComp = inInstalledTarget.getInstalledComponent();
        Component comp = inTE.getComponentByComponentID(installedComp.getComponentID());
        Target target = installedComp.getTargetID().getByIDQuery().select();
        Host oldHost = inTargetContext.getTargetHost();
        try {
            inTargetContext.setTargetHost(inInstalledTarget.getHost());
            VariableSettingsHolder args = new VariableSettingsHolder(inArgs);
            args.setVarValue(ARG_UNIQUE_FILE_PREFIX, inTmpFileNameGen.getTmpFileName());
            SnapshotUtil.traverseSnapshotBlock(inState, inTaskInfo, inTargetContext, inTopLevelSessionConfigGen, args, comp, installedComp, target, inTE, inSnapshotBlockName, inGatherer, inInstalledTarget, inTmpFileNameGen);
        }
        finally {
            inTargetContext.setTargetHost(oldHost);
        }
    }

    public static String getCompressedString(ObjectID inID) {
        if (inID == null) {
            return null;
        }
        char[] c = inID.toString().toCharArray();
        StringBuffer sb = new StringBuffer(c.length);
        int i = 0;
        if (c.length > 12) {
            i = 12;
        }
        while (i < c.length) {
            if (Character.isDigit(c[i])) {
                sb.append(c[i]);
            }
            ++i;
        }
        BigInteger big = new BigInteger(sb.toString(), 10);
        return big.toString(36);
    }

    private static class TmpFileNameGenerator {
        private int mCnt = 1;
        private String mInstCompPrefix;

        public TmpFileNameGenerator(InstalledComponent inInstComp) {
            this.mInstCompPrefix = SnapshotUtil.getCompressedString(inInstComp.getID());
        }

        public String getTmpFileName() {
            return TMP_FILE_PREFIX + this.mInstCompPrefix + this.mCnt++;
        }
    }
}

