/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PEXComponentLookupException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanPermissionException;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VACreationData;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.security.AccessController;

public abstract class RetargetingTaskExecutorBase
extends TaskExecutor {
    private static final String LOGGER_CATEGORY = RetargetingTaskExecutorBase.class.getName();

    public RetargetingTaskExecutorBase(Application inApp, ExecStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        RepoTarget[] theTargets = this.getRepoComponentTargets(inGeneratedStep, inState);
        for (int i = 0; i < theTargets.length; ++i) {
            this.performSingleRetargetedAction(theTargets[i], theTargets[i].getHost(), inVirtualAgent, inState, inStepInfo, inGeneratedStep);
        }
    }

    protected void performSingleRetargetedAction(RepoTarget inTarget, Host inHost, VirtualAgent inOldVA, ExecutionState inState, StepInfo inStepInfo, ExecStep inGeneratedStep) throws PlanExecutionException, InterruptedException, RPCException {
        RetargetingTaskExecutorBase.performRetargetableAction(new RetargetedExecutor(inTarget, inState, inGeneratedStep, inStepInfo), inTarget, inHost, inOldVA, inState, inStepInfo);
    }

    public static Object performRetargetableAction(RetargetableAction action, RepoTarget inTarget, Host inHost, VirtualAgent inOldVA, ExecutionState inState, StepInfo inStepInfo) throws PlanExecutionException, InterruptedException, RPCException {
        Object object;
        VALockInfo vaLockInfo = null;
        PlanTargetedConfigContext planCtx = inState.getCurrPlanTargetedCtx();
        Host oldCurHost = planCtx.getTargetHost();
        Target origTarget = inOldVA.getTarget();
        try {
            Host theTargetHost = inTarget == null ? inHost : inTarget.getHost();
            vaLockInfo = RetargetingTaskExecutorBase.getRetargetedAgent(theTargetHost, inOldVA, inState, inStepInfo, inTarget, action.suppressPermissionChecks());
            if (Logger.isDebugEnabled(RetargetingTaskExecutorBase.class)) {
                Logger.debug("Setting targetHost to " + theTargetHost.getName(), RetargetingTaskExecutorBase.class);
            }
            planCtx.setTargetHost(theTargetHost);
            object = action.execute(vaLockInfo.getVA());
            Object var13_13 = null;
        }
        catch (PersistenceManagerException ex) {
            try {
                throw new PlanExecutionException(ex);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (vaLockInfo != null && vaLockInfo.mfNeedsUnlocking) {
                    inState.getTaskInfo().getVirtualAgentManager().release(vaLockInfo.getVA(), inState.getPER(), inState.getTaskInfo());
                }
                inOldVA.setTarget(origTarget);
                if (Logger.isDebugEnabled(RetargetingTaskExecutorBase.class)) {
                    Logger.debug("Resetting the planTargetCtx back to oldHost " + oldCurHost.getName(), RetargetingTaskExecutorBase.class);
                }
                planCtx.setTargetHost(oldCurHost);
                throw throwable;
            }
        }
        if (vaLockInfo != null && vaLockInfo.mfNeedsUnlocking) {
            inState.getTaskInfo().getVirtualAgentManager().release(vaLockInfo.getVA(), inState.getPER(), inState.getTaskInfo());
        }
        inOldVA.setTarget(origTarget);
        if (Logger.isDebugEnabled(RetargetingTaskExecutorBase.class)) {
            Logger.debug("Resetting the planTargetCtx back to oldHost " + oldCurHost.getName(), RetargetingTaskExecutorBase.class);
        }
        planCtx.setTargetHost(oldCurHost);
        return object;
    }

    protected abstract InstalledComponentTargeter getInstalledCompTargeter(ExecStep var1);

    protected RepoTarget[] getRepoComponentTargets(ExecStep inGeneratedStep, ExecutionState inState) throws RPCException, PlanExecutionException {
        InstalledComponentTargeter theTargeter = this.getInstalledCompTargeter(inGeneratedStep);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Inspecting targeter " + theTargeter, this);
        }
        RepoTarget[] theTargets = new InstalledTarget[]{};
        try {
            theTargets = theTargeter.isBulkTargeter() ? theTargeter.getAllInstalledTargets(inState.getCurrPlanTargetedCtx(), inState.getCaller(), inState.getTaskInfo().getInstallDBContext()) : new InstalledTarget[]{theTargeter.getInstalledTarget(inState.getCurrPlanTargetedCtx(), inState.getCaller(), inState.getTaskInfo().getInstallDBContext())};
        }
        catch (ConfigGenException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (PersistenceManagerException ex) {
            throw new PEXComponentLookupException(((Object)theTargeter).toString(), inState.getCurrPlanTargetedCtx().getTargetHost().getName(), ex);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Returning " + theTargets.length + " repoTargets for step " + ExecStep.getStepTypeStringRepresentation(inGeneratedStep.getStepType()), this);
        }
        return theTargets;
    }

    protected abstract void doRetargetedAction(RepoTarget var1, VirtualAgent var2, ExecutionState var3, ExecStep var4, StepInfo var5) throws PlanExecutionException, InterruptedException, RPCException;

    public static VALockInfo getRetargetedAgent(Host inNewCurrent, VirtualAgent inOldVA, ExecutionState inState, StepInfo inParentInfo, RepoTarget inRepoTarget, boolean suppressPermissionChecks) throws PlanExecutionException, PersistenceManagerException {
        Target newTarget;
        try {
            newTarget = Target.create(inOldVA.getTarget().getInitialHostID(), inNewCurrent.getID(), inState.getTaskInfo().getHostResolver());
            if (Logger.isDebugEnabled(RetargetingTaskExecutorBase.class)) {
                Logger.debug("Created a new retargeted target: " + newTarget, RetargetingTaskExecutorBase.class);
            }
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
        if (!suppressPermissionChecks) {
            RetargetingTaskExecutorBase.checkTargetPermission(inRepoTarget, newTarget, inState);
        }
        if (newTarget.getPhysicalHostID().equals(inOldVA.getTarget().getPhysicalHostID()) && newTarget.getCurrentHostID().equals(inOldVA.getTarget().getCurrentHostID())) {
            if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
                Logger.debug("Shortcutting, returning incoming VA", LOGGER_CATEGORY);
            }
            return new VALockInfo(inOldVA, false);
        }
        BagID bagID = inState.getTaskInfo().getIsNonPlanTaskInfo() ? null : new BagID(inState.getTaskInfo().getTaskID().toString());
        VACreationData vaData = new VACreationData(newTarget, inState.getCurrConfigGenerator(), inState.getCurrPasswdSafeConfigGenerator(), inState.getConfigGenMgr(), bagID);
        VirtualAgent outVA = inState.getPER().getRetargetedVA(inState, vaData, inParentInfo, false, true);
        if (Logger.isDebugEnabled(LOGGER_CATEGORY)) {
            Logger.debug("returning a new VA", LOGGER_CATEGORY);
        }
        return new VALockInfo(outVA, true);
    }

    private static void checkTargetPermission(RepoTarget inRepoTarget, Target inTarget, ExecutionState inState) throws PlanPermissionException {
        FolderID path = null;
        path = inRepoTarget != null ? inRepoTarget.getActualComponent().getPath() : inState.getCaller().getActualPath();
        RetargetingTaskExecutorBase.checkOneHostPermission(path, inTarget.getCurrentHostID());
        if (!inTarget.getCurrentHostID().equals(inTarget.getPhysicalHostID())) {
            RetargetingTaskExecutorBase.checkOneHostPermission(path, inTarget.getPhysicalHostID());
        }
    }

    private static void checkOneHostPermission(FolderID inPath, HostID inHostID) throws PlanPermissionException {
        try {
            AccessController.checkPermission(FolderPermission.createExecutePermission(inPath, inHostID));
        }
        catch (AccessControlException e) {
            throw new PlanPermissionException((ROXPermission)((Object)e.getPermission()));
        }
    }

    public static class VALockInfo {
        private boolean mfNeedsUnlocking;
        private VirtualAgent mVA;

        private VALockInfo(VirtualAgent inVA, boolean inNeedsUnlocking) {
            this.mVA = inVA;
            this.mfNeedsUnlocking = inNeedsUnlocking;
        }

        public VirtualAgent getVA() {
            return this.mVA;
        }
    }

    public static abstract class RetargetableAction {
        public abstract Object execute(VirtualAgent var1) throws PlanExecutionException, InterruptedException, RPCException;

        public boolean suppressPermissionChecks() {
            return false;
        }
    }

    private class RetargetedExecutor
    extends RetargetableAction {
        private RepoTarget mTarget;
        private ExecutionState mState;
        private ExecStep mGeneratedStep;
        private StepInfo mStepInfo;

        public RetargetedExecutor(RepoTarget inTarget, ExecutionState inState, ExecStep inGeneratedStep, StepInfo inStepInfo) {
            this.mTarget = inTarget;
            this.mState = inState;
            this.mGeneratedStep = inGeneratedStep;
            this.mStepInfo = inStepInfo;
        }

        public Object execute(VirtualAgent inNewAgent) throws PlanExecutionException, InterruptedException, RPCException {
            RetargetingTaskExecutorBase.this.doRetargetedAction(this.mTarget, inNewAgent, this.mState, this.mGeneratedStep, this.mStepInfo);
            return null;
        }

        public boolean suppressPermissionChecks() {
            return this.mGeneratedStep.getStepType() == 114;
        }
    }
}

