/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.RetargetStep;
import com.raplix.util.logger.Logger;

public class RetargetTaskExecutor
extends RetargetingTaskExecutorBase {
    private String mHostName;

    public RetargetTaskExecutor(Application inApp, RetargetStep inStep) {
        super(inApp, inStep);
        this.mHostName = inStep.getHost();
    }

    protected InstalledComponentTargeter getInstalledCompTargeter(ExecStep inStep) {
        return null;
    }

    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        RetargetStep theStep = (RetargetStep)inGeneratedStep;
        String hostName = theStep.getHost();
        Host targetHost = this.getTargetHost(hostName, inState);
        this.mHostName = targetHost.getName();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Retargeting to new current host " + this.mHostName, this);
        }
        this.performSingleRetargetedAction(null, targetHost, inVirtualAgent, inState, inStepInfo, theStep);
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.RETARGET", this.mHostName);
        return msg.toString();
    }

    protected Host getTargetHost(String inHostName, ExecutionState inState) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Looking up host " + inHostName, this);
        }
        try {
            return inState.getCurrPlanTargetedCtx().resolveHost(inHostName);
        }
        catch (CommandException ex) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Error while resolving host name " + inHostName, ex, this);
            }
            throw new PlanExecutionException(ex);
        }
    }

    protected void doRetargetedAction(RepoTarget inTarget, VirtualAgent inVirtualAgent, ExecutionState inState, ExecStep inGeneratedStep, StepInfo inCurrentStep) throws PlanExecutionException, InterruptedException, RPCException {
        ExecStep[] theSteps = ((RetargetStep)inGeneratedStep).getSteps();
        inCurrentStep.setChildrenMappable(false);
        try {
            MultiStepExecutor.execMultiStepsOnNewTarget(inCurrentStep, theSteps, inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null), inVirtualAgent.getTarget().getCurrentHost(), ((RetargetStep)inGeneratedStep).getLocalVars());
        }
        catch (ConfigGenException e) {
            throw new PlanExecutionException(e);
        }
    }
}

