/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.exceptions.PathDoesNotExistException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;

public abstract class ResourceTaskExecutorBase
extends TaskExecutor {
    protected String mCompName;

    public ResourceTaskExecutorBase(Application inApp, ExecStep inStep) {
        super(inApp, inStep);
    }

    protected void initInternalData(ExecutionState inState) {
        InstalledComponent theInstalledComp = inState.getCurrInstalledComponent();
        if (theInstalledComp != null) {
            try {
                this.mCompName = this.getComponentNameByID(theInstalledComp.getComponentID());
            }
            catch (PlanExecutionException ex) {
                this.mCompName = ARG_NOT_AVAILABLE;
            }
        } else {
            this.mCompName = ARG_NOT_AVAILABLE;
        }
    }

    protected void configGenResourceDefs(ResourceDefinition[] ioDefs, ComponentConfigManager inManager, Component inComp, VirtualAgent agent, ExecutionState state) throws ConfigGenException, PersistenceManagerException, PathDoesNotExistException, RPCException {
        HostID physHostID = agent.getTarget().getPhysicalHostID();
        Host physHost = state.getTaskInfo().getHostResolver().getHost(physHostID);
        MachineInfo mi = physHost.getMachineInfo();
        for (int i = 0; i < ioDefs.length; ++i) {
            ioDefs[i] = ioDefs[i].generate(inManager, inComp, mi);
        }
    }
}

