/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.RemoveSnapshotStep;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;

public class RemoveSnapshotTaskExecutor
extends TaskExecutor {
    public RemoveSnapshotTaskExecutor(Application inApp, ExecStep inOrigStep) {
        super(inApp, inOrigStep);
    }

    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        RemoveSnapshotStep removeSnapshotStep = (RemoveSnapshotStep)inGeneratedStep;
        Snapshot snapshot = removeSnapshotStep.getSnapshot();
        this.doRemove(snapshot, inStepInfo, inState, inVirtualAgent);
    }

    private void doRemove(Snapshot inSnapshot, StepInfo inParentInfo, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, RPCException, InterruptedException {
        try {
            HostID[] hosts = inSnapshot.getID().getVisitedHosts();
            Host host = null;
            if (hosts != null && hosts.length > 0) {
                for (int i = 0; i < hosts.length; ++i) {
                    host = inState.getTaskInfo().getHostResolver().getHost(hosts[i]);
                    RetargetingTaskExecutorBase.performRetargetableAction(new RetargetingTaskExecutorBase.RetargetableAction(){

                        public Object execute(VirtualAgent inNewAgent) throws PlanExecutionException {
                            inNewAgent.purgeSnapshots();
                            return null;
                        }
                    }, null, host, inVirtualAgent, inState, inParentInfo);
                }
            }
        }
        catch (PersistenceManagerException e) {
            throw new PlanExecutionException(e);
        }
    }

    public String toString() {
        String blockName = null;
        Snapshot snapshot = ((RemoveSnapshotStep)this.getOriginalStep()).getSnapshot();
        if (snapshot != null) {
            blockName = snapshot.getName();
        }
        if (blockName == null) {
            blockName = "";
        }
        ROXMessage msg = new ROXMessage("pe.step.REMOVE_SNAPSHOT", blockName);
        return msg.toString();
    }
}

