/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RebootStep;
import com.raplix.util.TimeUtil;
import com.raplix.util.logger.Logger;

public class RebootTaskExecutor
extends TaskExecutor {
    public RebootTaskExecutor(Application inApp, RebootStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        long timeout;
        int delay;
        try {
            delay = this.mApp.getPlanSubsystem().getConfigRebootInterval();
        }
        catch (UnsupportedSubsystemException ex) {
            throw new PlanExecutionException("pe.ERR_REBOOT", (Throwable)ex);
        }
        delay = (int)TimeUtil.convert(delay, 1, 0);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Delay set to " + delay + "ms", this);
        }
        if ((timeout = ((RebootStep)inGeneratedStep).getTimeout()) == Long.MIN_VALUE) {
            timeout = inState.getTaskInfo().getNativeCallTimeoutSecs();
        }
        timeout = (long)TimeUtil.convert(timeout, 1, 0);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Timeout set to " + timeout + "s", this);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Attempting reboot initiation", this);
        }
        inVirtualAgent.reboot();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Reboot successfully initiated", this);
        }
        long end = System.currentTimeMillis() + timeout;
        while (true) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Checking for reboot completion", this);
            }
            boolean isPending = true;
            PlanExecutionException thrownEx = null;
            try {
                isPending = inVirtualAgent.isRebootPending();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Reboot pending: " + isPending, this);
                }
            }
            catch (PlanExecutionException ex) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Agent not responding", ex, this);
                }
                thrownEx = ex;
            }
            if (!isPending) {
                return;
            }
            if (System.currentTimeMillis() > end) {
                if (thrownEx == null) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Step timed out", this);
                    }
                    throw new PlanExecutionException("pe.ERR_REBOOT_STILL_RUNNING");
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Step timed out", thrownEx, this);
                }
                throw new PlanExecutionException("pe.ERR_REBOOT_UNREACHABLE", (Throwable)thrownEx);
            }
            Thread.sleep(delay);
        }
    }

    public String toString() {
        return new ROXMessage("pe.step.REBOOT").toString();
    }
}

