/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ProcessTestStep;

public class ProcessTestTaskExecutor
extends TaskExecutor {
    public ProcessTestTaskExecutor(Application inApp, ProcessTestStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, RPCException {
        ProcessTestStep theStepToUse = (ProcessTestStep)inGeneratedStep;
        String procName = theStepToUse.getProcessNamePattern();
        String userName = this.getUserName(theStepToUse);
        int delaySeconds = theStepToUse.getDelaySecs();
        int timeout = theStepToUse.getTimeoutSecs();
        inVirtualAgent.checkProcess(procName, userName, delaySeconds, timeout);
    }

    public String toString() {
        ProcessTestStep theStepToUse = (ProcessTestStep)this.getOriginalStep();
        ROXMessage msg = new ROXMessage("pe.step.PROCESS_TEST", new String[]{theStepToUse.getProcessNamePattern()});
        return msg.toString();
    }

    private String getUserName(ProcessTestStep inStepToUse) {
        String user = inStepToUse.getUser();
        if (user == null || user.length() == 0) {
            user = null;
        }
        return user;
    }
}

