/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PauseStep;
import com.raplix.util.logger.Logger;
import java.util.Random;

public class PauseTaskExecutor
extends TaskExecutor {
    private static final int MILLIS_MULTIPLIER = 1000;
    private Random mRandom = new Random();

    public PauseTaskExecutor(Application inApp, PauseStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        PauseStep theStepToUse = (PauseStep)inGeneratedStep;
        long delay = 1000 * theStepToUse.getDelaySecs();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("starting to wait for " + theStepToUse.getDelaySecs() + " secs runlevel " + inVirtualAgent.getRunLevel(), this);
        }
        inVirtualAgent.handlePause(delay);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("finished waiting runlevel: " + inVirtualAgent.getRunLevel(), this);
        }
    }

    public String toString() {
        PauseStep theStepToUse = (PauseStep)this.getOriginalStep();
        ROXMessage msg = new ROXMessage("pe.step.PAUSE", new Integer[]{new Integer(theStepToUse.getDelaySecs())});
        return msg.toString();
    }

    protected ROXMessage getTimeoutMessage() {
        return new ROXMessage("pe.PLAN_TIMED_OUT_PAUSE_STEP");
    }
}

