/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStep;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;

public class OutputGeneratorStepExecManager {
    private Hashtable mStepTable = new Hashtable();

    void stepStarted(OutputGeneratorStep inStep) {
        if (inStep.getTaskID() != null) {
            OutputGeneratorStep obj = null;
            obj = this.mStepTable.put(new TaskStepIDKey(inStep.getTaskID(), inStep.getStepID()), inStep);
            if (obj != null && Logger.isErrorEnabled(this)) {
                Logger.error("Duplicate Step descriptor registered. Exisiting:" + obj + ":New:" + inStep, this);
            }
        }
    }

    void stepCompleted(OutputGeneratorStep inStep) {
        if (inStep.getTaskID() != null) {
            this.mStepTable.remove(new TaskStepIDKey(inStep.getTaskID(), inStep.getStepID()));
        }
    }

    public ExecNativeOutput getCurrentOutput(TaskID inTaskID, StepID stepID) throws CommandExecutionErrorException {
        OutputGeneratorStep step = (OutputGeneratorStep)this.mStepTable.get(new TaskStepIDKey(inTaskID, stepID));
        if (step != null) {
            return step.snapshotStreams();
        }
        return null;
    }

    private static class TaskStepIDKey {
        private TaskID mTaskID;
        private StepID mStepID;

        TaskStepIDKey(TaskID inTaskID, StepID inStepID) {
            this.mTaskID = inTaskID;
            this.mStepID = inStepID;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof TaskStepIDKey) {
                TaskStepIDKey tmp = (TaskStepIDKey)obj;
                return this.mStepID.equals(tmp.mStepID) && this.mTaskID.equals(tmp.mTaskID);
            }
            return false;
        }

        public int hashCode() {
            return this.mStepID.hashCode() ^ this.mTaskID.hashCode();
        }

        public String toString() {
            return "TaskID:" + this.mTaskID + ":stepID:" + this.mStepID;
        }
    }
}

