/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.PersistentVariableSettingsTable;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PETransaction;
import com.raplix.rolloutexpress.executor.PlanExecutionDeploymentWarning;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.InstallSystemServiceStep;
import com.raplix.rolloutexpress.executor.task.RemoveSnapshotStep;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.resource.DeploymentScope;
import com.raplix.rolloutexpress.resource.exception.ResourceCallbackException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.OverrideRepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;

public class InstallTaskExecutor
extends RetargetingTaskExecutorBase {
    private String mBlockName;
    private String mCompName;
    private boolean mfPlanInitiated;
    private boolean mfInternalTarget;

    public InstallTaskExecutor(Application inApp, InstallStep inStep) {
        super(inApp, inStep);
        this.mBlockName = inStep.getBlockName();
        this.mCompName = ((Object)inStep.getTargeter()).toString();
        this.mfPlanInitiated = inStep.getTargeter() instanceof OverrideRepoComponentTargeter;
        this.mfInternalTarget = false;
    }

    protected InstalledComponentTargeter getInstalledCompTargeter(ExecStep inStep) {
        return null;
    }

    protected RepoTarget[] getRepoComponentTargets(ExecStep inGeneratedStep, ExecutionState inState) throws RPCException, PlanExecutionException {
        InstallStep theStep = (InstallStep)inGeneratedStep;
        RepoComponentTargeter targeter = theStep.getTargeter();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("setting up to perform multiple retargets on " + targeter + " for step " + inGeneratedStep, this);
        }
        RepoTarget[] theTargets = new RepoTarget[]{};
        try {
            Caller theCaller = this.getCaller(theStep, inState);
            if (targeter instanceof OverrideRepoComponentTargeter) {
                OverrideRepoComponentTargeter overrideTargeter = (OverrideRepoComponentTargeter)targeter;
                theTargets = new RepoTarget[]{overrideTargeter.getRepoTarget(inState.getCurrPlanTargetedCtx(), theCaller, inState.getTaskInfo().getInstallDBContext(), inState.getCurrPlanInitiatedInstallStepCID((InstallStep)inGeneratedStep).getComponent())};
            } else if (targeter.isBulkTargeter()) {
                theTargets = targeter.getAllRepoTargets(inState.getCurrPlanTargetedCtx(), inState.getCaller(), inState.getTaskInfo().getInstallDBContext());
            } else if (targeter.isInternalTarget()) {
                this.mfInternalTarget = true;
                theTargets = new RepoTarget[]{targeter.getRepoTarget(inState.getCurrPlanTargetedCtx(), theCaller, inState.getTaskInfo().getInstallDBContext())};
            } else {
                theTargets = new RepoTarget[]{targeter.getRepoTarget(inState.getCurrPlanTargetedCtx(), theCaller, inState.getTaskInfo().getInstallDBContext())};
            }
        }
        catch (ConfigGenException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        return theTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRetargetedAction(RepoTarget inTarget, VirtualAgent inVirtualAgent, ExecutionState inState, ExecStep inStep, StepInfo inCurrentStep) throws PlanExecutionException, InterruptedException, RPCException {
        boolean fInstallSucceeded;
        RemoveSnapshotStep[] removeSnapshotData;
        InstalledComponent previouslyInstalledComp;
        InstalledComponent theInstalledComp;
        ComponentInstallData theCID;
        Component theComponent;
        block17: {
            InstallStep stepToUse = (InstallStep)inStep;
            theComponent = inTarget.getActualComponent();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Beginning of install of comp: " + theComponent.getName() + " using block " + this.mBlockName, this);
            }
            InstallBlock installBlock = theComponent.resolveInstallBlock(this.mBlockName, inTarget.getCallSpec());
            if (stepToUse.getAssignTo() != null && !installBlock.getReturns()) {
                throw new PlanExecutionException(new ROXMessage("pe.ERR_INSTALL_DOES_NOT_RETURN_VALUE", this.mBlockName, theComponent.getName()));
            }
            Host thePhysicalHost = inVirtualAgent.getTarget().getPhysicalHost();
            if (!this.mfInternalTarget) {
                this.verifyComponentsLimitToHostSet(inVirtualAgent.getTarget().getCurrentHost(), theComponent);
                this.verifyComponentCanBeInstalledOnHost(theComponent, thePhysicalHost);
            }
            ComponentRefDecl theDecl = inTarget.getTargetingCompRef();
            theCID = this.updateCID(inState, theDecl, theComponent, (InstallStep)inStep);
            theInstalledComp = null;
            previouslyInstalledComp = null;
            removeSnapshotData = null;
            if (!this.mfInternalTarget) {
                if (theDecl == null || InstallMode.TOPLEVEL.equals(theDecl.getInstallMode())) {
                    InstalledComponentRef compRef = new InstalledComponentRef(theComponent.getPath(), theComponent.getName(), null, null, false, theCID.getInstallPath(), false);
                    previouslyInstalledComp = inVirtualAgent.getInstalledComponent(compRef, inState, TargetType.CURRENT);
                }
                this.verifyCompTarget(previouslyInstalledComp, inVirtualAgent, "pe.ERR_COMP_INST_DIFF_TARGET");
                removeSnapshotData = this.collectRemoveSnapshotData(inState, this, previouslyInstalledComp);
                theInstalledComp = inVirtualAgent.createInstalledComponent(inState, theCID, this.mBlockName, theDecl);
            } else {
                theInstalledComp = inState.getCurrInstalledComponent();
            }
            fInstallSucceeded = false;
            boolean pushedCID = false;
            try {
                if (installBlock == null) {
                    throw new PlanExecutionException(new ROXMessage("pe.NAMED_BLOCK_DNE", this.mBlockName, ExecStep.getStepTypeStringRepresentation(this.getStepType()), theComponent.getName()));
                }
                ExecStep[] installSteps = installBlock.getExecSteps();
                Caller nextCaller = inTarget.getCallerForMember(installBlock, theInstalledComp);
                ConfigGenerator newCG = this.createCG(theCID.getConfigManager(), ((InstallStep)inStep).getArgs(), installBlock, nextCaller);
                ConfigGenerator passwdSafeCG = null;
                if (inState.getCurrPasswdSafeConfigGenerator() != null) {
                    passwdSafeCG = this.createCG(theCID.getPassSafeConfigManager(), ((InstallStep)this.generateStepPasswdSafe(inState)).getArgs(), installBlock, nextCaller);
                }
                inState.pushCID(theCID);
                pushedCID = true;
                ReturnStep returnStep = this.doDeploymentSteps(inVirtualAgent, theInstalledComp, inState, thePhysicalHost, theComponent, inCurrentStep, installSteps, newCG, passwdSafeCG, nextCaller);
                this.processReturnStep(stepToUse, returnStep, inState);
                fInstallSucceeded = true;
                Object var23_24 = null;
                if (!pushedCID) break block17;
                inState.popCID();
            }
            catch (Throwable throwable) {
                Object var23_25 = null;
                if (pushedCID) {
                    inState.popCID();
                }
                if (!fInstallSucceeded) {
                    this.handleFailedInstall(theInstalledComp, theComponent, inState);
                }
                throw throwable;
            }
        }
        if (!fInstallSucceeded) {
            this.handleFailedInstall(theInstalledComp, theComponent, inState);
        }
        if (!this.mfInternalTarget) {
            inVirtualAgent.markComponentInstalled(theInstalledComp, new InstalledComponentRef(theComponent.getPath(), theComponent.getName(), theComponent.getVersionNumber().getAsString(), Comparator.EQUAL, false, theCID.getInstallPath(), false), this.getCaller((InstallStep)inStep, inState), inState);
            try {
                if (previouslyInstalledComp != null && previouslyInstalledComp.getID() != null && removeSnapshotData != null) {
                    this.removeSnapshot(inCurrentStep, inState, 0, inVirtualAgent, previouslyInstalledComp, removeSnapshotData);
                }
            }
            catch (PersistenceManagerException pme) {
                throw new PlanExecutionDeploymentWarning(new ROXMessage("pe.ERR_REMOVE_SNAPSHOT"), (Throwable)pme);
            }
        }
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.INSTALL_BUILD", this.mCompName, this.mBlockName);
        return msg.toString();
    }

    private ConfigGenerator createCG(ComponentConfigManager inCurCM, VariableSettingsSource inArgs, NamedBlock inBlock, Caller caller) throws PlanExecutionException {
        try {
            return InstallTaskExecutor.createBlockCallerCG(inCurCM, inBlock, inArgs, caller);
        }
        catch (ConfigGenException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    private ComponentInstallData updateCID(ExecutionState inState, ComponentRefDecl inDecl, Component inComp, InstallStep inStep) throws PlanExecutionException {
        ComponentInstallData theCID = this.mfPlanInitiated ? inState.getCurrPlanInitiatedInstallStepCID(inStep) : new ComponentInstallData(inComp, null);
        try {
            ComponentConfigManager passSafeConfigMgr;
            ComponentConfigManager configMgr;
            ConfigGenerator theCG = inState.getTopLevelSessionConfigGen();
            ConfigGenerator passSafeCG = inState.getTopLevelPassSafeSessionConfigGen();
            theCG = theCG.newTargetScope(inState.getCurrPlanTargetedCtx(), inState.getTaskInfo().getInstallDBContext());
            passSafeCG = passSafeCG.newTargetScope(inState.getCurrPlanTargetedCtx(), inState.getTaskInfo().getInstallDBContext());
            if (Logger.isDebugEnabled(this)) {
                Host tHost = inState.getCurrPlanTargetedCtx().getTargetHost();
                Logger.debug("targetHost " + tHost.getName() + " vars are " + Util.getStringFromArray(inState.getCurrPlanTargetedCtx().getTargetHost().getVarNames(), ","), this);
            }
            if (this.mfPlanInitiated) {
                configMgr = theCG.newComponentManager(inComp, theCID.getGeneratedVarSettingsID());
                passSafeConfigMgr = passSafeCG.newComponentManager(inComp, theCID.getGeneratedVarSettingsID());
            } else if (this.mfInternalTarget) {
                GeneratedVariableSettingsID gvsID = inState.getCurrInstalledComponent().getVariableSettingsID();
                configMgr = theCG.newComponentManager(gvsID);
                passSafeConfigMgr = passSafeCG.newComponentManager(gvsID);
            } else {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Adding override vars " + Util.getStringFromArray(inDecl.getOverrideArgs().getVarNames(), ",") + " for nested comp " + inDecl.getName(), this);
                }
                InstalledComponent parentInstComp = inState.getCurrInstalledComponent();
                ComponentConfigManager parentCM = inState.getConfigGenMgr().getConfigGenerator().newComponentManager(parentInstComp.getVariableSettingsID());
                VariableSettingsSource args = inDecl.resolveOverrideArgs(parentCM);
                InstalledComponentID parentInstCompID = null;
                String refName = null;
                if (InstallMode.NESTED.equals(inDecl.getInstallMode())) {
                    parentInstCompID = parentInstComp.getID();
                    refName = inDecl.getName();
                }
                configMgr = theCG.newComponentRefManager(inComp, args, parentInstCompID, refName);
                passSafeConfigMgr = passSafeCG.newComponentRefManager(inComp, args, parentInstCompID, refName);
            }
            String installDir = inComp.getInstallPath(configMgr);
            theCID.setInstallPath(installDir);
            theCID.setConfigManager(configMgr);
            theCID.setPassSafeConfigManager(passSafeConfigMgr);
            final GeneratedVariableSettingsID gvsForIC = configMgr.saveSettings();
            theCID.setGeneratedVariableSettingsID(gvsForIC);
            if (inState.getRunLevel().equals(RunLevel.PREFLIGHT)) {
                inState.getTaskInfo().addCleanupTask(new PETransaction(){

                    public Object execute() throws ClassMapException, PersistenceManagerException, QueryException {
                        PersistentVariableSettingsTable t = PersistentVariableSettingsTable.DEFAULT;
                        PersistentVariableSettingsTable.execute(PersistentVariableSettingsTable.delete(t, PersistentVariableSettingsTable.where(PersistentVariableSettingsTable.equals(t.ID, gvsForIC))));
                        return null;
                    }

                    public String getTransactionIdentifier() {
                        return "cleanup gen var setting";
                    }
                });
            }
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
        return theCID;
    }

    private void verifyComponentCanBeInstalledOnHost(SummaryComponent inComp, SummaryHost inHost) throws PlanExecutionException {
        try {
            HostSetID setID = SingleHostSetQuery.byName(inComp.getPlatform()).selectSummaryView().getID();
            if (!setID.contains(inHost.getID())) {
                throw new PlanExecutionException(new ROXMessage("pe.COMPONENT_WRONG_HOST_SET", inComp.getName(), inHost.getName(), inComp.getPlatform()));
            }
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    private ReturnStep doDeploymentSteps(final VirtualAgent inVirtualAgent, final InstalledComponent inInstalledComp, final ExecutionState inState, Host inThePhysicalHost, Component inComponent, final StepInfo inCurrentStep, final ExecStep[] inInstallSteps, final ConfigGenerator inNewCG, final ConfigGenerator inPasswdSafeCG, final Caller inNextCaller) throws PlanExecutionException, InterruptedException {
        try {
            return (ReturnStep)new DeploymentScope(inState.getResourceSubsystem(), new Host[]{inThePhysicalHost}, this.getComponentRsrcInfos(inComponent)){

                public Object innerExec() throws ResourceCallbackException {
                    try {
                        return MultiStepExecutor.execMultiStepsInCurrentComponent(inCurrentStep, inInstallSteps, inState, 0, inVirtualAgent, InstallTaskExecutor.this.getTaskExecutorFactory(null), inInstalledComp, inNewCG, inPasswdSafeCG, inNextCaller);
                    }
                    catch (PlanExecutionException e) {
                        throw new ResourceCallbackException(e);
                    }
                    catch (InterruptedException e) {
                        throw new ResourceCallbackException(e);
                    }
                }
            }.exec();
        }
        catch (ResourceCallbackException e) {
            Throwable theThrowable = e.getInnerThrowable();
            if (theThrowable instanceof PlanExecutionException) {
                throw (PlanExecutionException)theThrowable;
            }
            if (theThrowable instanceof InterruptedException) {
                throw (InterruptedException)theThrowable;
            }
            throw new PlanExecutionException(e);
        }
        catch (ResourceException e) {
            throw new PlanExecutionException(e);
        }
    }

    private void handleFailedInstall(InstalledComponent inIComp, Component inComp, ExecutionState inState) throws PlanExecutionException {
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("handling failed Install of " + inComp.getName(), this);
            }
            inState.getTaskInfo().getInstallDBContext().installComponentFailed(inIComp);
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    protected void verifyComponentsLimitToHostSet(Host inCurrentHost, Component inComp) throws PlanExecutionException {
        if (inComp.getLimitToHostSet() != null) {
            try {
                HostSetID setID = SingleHostSetQuery.byName(inComp.getLimitToHostSet()).selectSummaryView().getID();
                if (!setID.contains(inCurrentHost.getID())) {
                    throw new PlanExecutionException(new ROXMessage("pe.COMP_LIMIT_TO_HOST_SET", new String[]{inCurrentHost.getName(), inComp.getLimitToHostSet(), inComp.getFullName()}));
                }
            }
            catch (NoResultsFoundException ex) {
                throw new PlanExecutionException(new ROXMessage("pe.HOST_SET_DNE_FOR_LIMIT", inComp.getLocalLimitToHostSet()));
            }
            catch (PersistenceManagerException ex) {
                throw new PlanExecutionException(ex);
            }
            catch (RPCException ex) {
                throw new PlanExecutionException(ex);
            }
        }
    }

    private Caller getCaller(InstallStep inStep, ExecutionState inState) {
        if (inStep instanceof InstallSystemServiceStep) {
            return ((InstallSystemServiceStep)inStep).getCaller();
        }
        return inState.getCaller();
    }
}

