/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.DynamicContainerStep;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.IfStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.util.logger.Logger;

public class IfTaskExecutor
extends TaskExecutor {
    private String mConditionDisplay;

    public IfTaskExecutor(Application inApp, IfStep inStep) {
        super(inApp, inStep);
        this.mConditionDisplay = inStep.getCondition().toString();
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        DynamicContainerStep children;
        boolean result;
        IfStep step = (IfStep)inGeneratedStep;
        try {
            result = step.getCondition().evaluate();
        }
        catch (PlanDBException ex) {
            throw new PlanExecutionException(ex);
        }
        if (result) {
            children = new DynamicContainerStep(step.getThenSteps(), new ROXMessage("pe.step.IF_THEN"));
        } else {
            ExecStep[] steps = step.getElseSteps();
            if (steps == null) {
                return;
            }
            children = new DynamicContainerStep(steps, new ROXMessage("pe.step.IF_ELSE"));
        }
        this.setReturnStep(MultiStepExecutor.execMultiSteps(inCurrentStep, new ExecStep[]{children}, inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null)));
    }

    public String toString() {
        String result = new ROXMessage("pe.step.IF", this.mConditionDisplay).toString();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("ifStep: " + result, this);
        }
        return result;
    }
}

